/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.energy.tesla;

import com.mcmoddev.lib.energy.EnergySystemRegistry;
import com.mcmoddev.lib.energy.ForgeEnergyValue;
import com.mcmoddev.lib.energy.IEnergyAdapter;
import com.mcmoddev.lib.energy.IEnergyValue;
import com.mcmoddev.lib.energy.IForgeEnergyCompatible;
import com.mcmoddev.lib.energy.IGenericEnergyStorage;
import com.mcmoddev.lib.energy.tesla.TeslaEnergyAdapter;
import com.mcmoddev.lib.energy.tesla.TeslaEnergyValue;
import java.util.Objects;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class TeslaEnergySystem
implements IForgeEnergyCompatible<Long> {
    @Override
    public String getDependencyModId() {
        return "tesla";
    }

    @Override
    @Nullable
    public ForgeEnergyValue convertToFE(IEnergyValue value) {
        if (value instanceof TeslaEnergyValue) {
            return new ForgeEnergyValue((Integer)value.getValue());
        }
        return null;
    }

    @Nullable
    public TeslaEnergyValue convertFromFE(ForgeEnergyValue value) {
        return new TeslaEnergyValue(((Integer)value.getValue()).intValue());
    }

    @Override
    @Nullable
    public IEnergyAdapter createAdapter(TileEntity tile, EnumFacing facing) {
        if (!this.isAvailable()) {
            return null;
        }
        ITeslaConsumer consumer = (ITeslaConsumer)tile.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, facing);
        ITeslaProducer producer = (ITeslaProducer)tile.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, facing);
        ITeslaHolder holder = (ITeslaHolder)tile.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, facing);
        if (consumer != null || producer != null && holder != null) {
            return new TeslaEnergyAdapter(consumer, holder, producer);
        }
        return null;
    }

    @Override
    @Nullable
    public IEnergyAdapter createAdapter(ItemStack stack) {
        if (!this.isAvailable()) {
            return null;
        }
        ITeslaConsumer consumer = (ITeslaConsumer)stack.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null);
        ITeslaProducer producer = (ITeslaProducer)stack.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null);
        ITeslaHolder holder = (ITeslaHolder)stack.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, null);
        if (consumer != null || producer != null && holder != null) {
            return new TeslaEnergyAdapter(consumer, holder, producer);
        }
        return null;
    }

    @Nullable
    public TeslaEnergyValue convertToTesla(IEnergyValue value) {
        return (TeslaEnergyValue)TeslaEnergyValue.class.cast(this.convertFrom(value));
    }

    @Override
    public boolean hasCapability(Capability<?> capability, IGenericEnergyStorage storage) {
        return this.isAvailable() && EnergySystemRegistry.TESLA.isCompatibleWith(storage.getBaseSystem()) && (capability == TeslaCapabilities.CAPABILITY_HOLDER || capability == TeslaCapabilities.CAPABILITY_PRODUCER || capability == TeslaCapabilities.CAPABILITY_CONSUMER);
    }

    @Override
    @Nullable
    public <C> C getCapability(Capability<C> capability, IGenericEnergyStorage storage) {
        if (!this.hasCapability(capability, storage)) {
            return null;
        }
        if (capability == TeslaCapabilities.CAPABILITY_HOLDER) {
            return (C)TeslaCapabilities.CAPABILITY_HOLDER.cast((Object)new CapabilityHolder(storage));
        }
        if (capability == TeslaCapabilities.CAPABILITY_PRODUCER) {
            return (C)TeslaCapabilities.CAPABILITY_PRODUCER.cast((Object)new CapabilityProducer(storage));
        }
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER) {
            return (C)TeslaCapabilities.CAPABILITY_CONSUMER.cast((Object)new CapabilityConsumer(storage));
        }
        return null;
    }

    private static class CapabilityConsumer
    implements ITeslaConsumer {
        private final IGenericEnergyStorage storage;

        CapabilityConsumer(IGenericEnergyStorage storage) {
            this.storage = storage;
        }

        public long givePower(long power, boolean simulated) {
            return (Long)Objects.requireNonNull(EnergySystemRegistry.TESLA.convertFrom(this.storage.storeValue(new TeslaEnergyValue(power), !simulated))).getValue();
        }
    }

    private static class CapabilityProducer
    implements ITeslaProducer {
        private final IGenericEnergyStorage storage;

        CapabilityProducer(IGenericEnergyStorage storage) {
            this.storage = storage;
        }

        public long takePower(long power, boolean simulated) {
            return (Long)Objects.requireNonNull(EnergySystemRegistry.TESLA.convertFrom(this.storage.takeValue(new TeslaEnergyValue(power), !simulated))).getValue();
        }
    }

    private static class CapabilityHolder
    implements ITeslaHolder {
        private final IGenericEnergyStorage storage;

        CapabilityHolder(IGenericEnergyStorage storage) {
            this.storage = storage;
        }

        public long getStoredPower() {
            return (Long)Objects.requireNonNull(EnergySystemRegistry.TESLA.convertFrom(this.storage.getStoredValue())).getValue();
        }

        public long getCapacity() {
            return (Long)Objects.requireNonNull(EnergySystemRegistry.TESLA.convertFrom(this.storage.getCapacityValue())).getValue();
        }
    }
}

