/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container.gui;

import com.mcmoddev.lib.container.gui.IWidgetGui;
import com.mcmoddev.lib.container.gui.IWidgetLayout;
import com.mcmoddev.lib.container.gui.util.Padding;
import com.mcmoddev.lib.container.gui.util.Size2D;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class BaseWidgetGui
implements IWidgetGui {
    private Padding padding = Padding.EMPTY;
    private boolean isVisible = true;
    private IWidgetLayout parent = null;
    private Size2D size = null;

    protected BaseWidgetGui() {
    }

    protected BaseWidgetGui(int width, int height) {
        this(new Size2D(width, height));
    }

    protected BaseWidgetGui(Size2D size) {
        this.size = size;
    }

    @Override
    public Padding getPadding() {
        return this.padding;
    }

    @Override
    public IWidgetGui setPadding(Padding value) {
        this.padding = value;
        return this;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public boolean setVisibility(boolean isVisible) {
        if (this.canSetVisibility()) {
            this.setVisibilityProtected(isVisible);
        }
        return this.isVisible();
    }

    protected void setVisibilityProtected(boolean isVisible) {
        this.isVisible = isVisible;
    }

    protected boolean canSetVisibility() {
        return true;
    }

    @Override
    @Nullable
    public IWidgetLayout getParentLayout() {
        return this.parent;
    }

    @Override
    public IWidgetGui setParentLayout(@Nullable IWidgetLayout layout) {
        this.parent = layout;
        return this;
    }

    @Override
    public Size2D getSize() {
        if (this.size == null) {
            return Size2D.ZERO;
        }
        return this.size;
    }

    public void setSize(Size2D value) {
        this.size = value;
    }

    protected boolean isInside(int x, int y) {
        Size2D size = this.getSize();
        return x >= 0 && y >= 0 && x <= size.width && y <= size.height;
    }
}

