/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.os3.ISpawnEntry;
import com.mcmoddev.orespawn.data.Constants;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import net.minecraft.crash.CrashReport;

public class OreSpawnWriter {
    public static void saveConfigs() {
        Map<Path, List<String>> configs = OreSpawn.API.getSpawnsByFile();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        configs.entrySet().stream().forEach(ent -> OreSpawnWriter.saveSingle((Path)ent.getKey(), gson));
    }

    private static void saveSingle(Path filePath, Gson gson) {
        JsonObject root = new JsonObject();
        root.addProperty("version", "2.0");
        JsonObject spawns = new JsonObject();
        String k = filePath.getFileName().toString();
        Path saveDir = Constants.CONFDIR.resolve("forced-saves");
        Path conf = saveDir.resolve(k);
        if (!saveDir.toFile().exists()) {
            saveDir.toFile().mkdirs();
        }
        try (BufferedWriter p = Files.newBufferedWriter(conf, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            OreSpawn.API.getSpawnsForFile(k).stream().forEach(spawnName -> {
                JsonObject thisSpawn = new JsonObject();
                ISpawnEntry spawnEntry = OreSpawn.API.getSpawn((String)spawnName);
                thisSpawn.addProperty("enabled", Boolean.valueOf(spawnEntry.isEnabled()));
                thisSpawn.addProperty("retrogen", Boolean.valueOf(spawnEntry.isRetrogen()));
                thisSpawn.addProperty("feature", spawnEntry.getFeature().getFeatureName());
                thisSpawn.add("dimensions", (JsonElement)spawnEntry.getDimensions().serialize());
                thisSpawn.add("biomes", spawnEntry.getBiomes().serialize());
                thisSpawn.add("replaces", (JsonElement)spawnEntry.getMatcher().serialize());
                thisSpawn.add("parameters", (JsonElement)spawnEntry.getFeature().getFeatureParameters());
                spawns.add(spawnName, (JsonElement)thisSpawn);
            });
            root.add("spawns", (JsonElement)spawns);
            p.write(gson.toJson((JsonElement)root));
        }
        catch (IOException e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed writing config data " + conf.toString()));
            report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
        }
    }

    public static void saveSingle(String fileName) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        OreSpawnWriter.saveSingle(Constants.CONFDIR.resolve(fileName), gson);
    }
}

