/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.os3;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.api.IDimensionList;
import com.mcmoddev.orespawn.impl.os3.DimensionListAcceptAllOverworld;
import java.util.ArrayList;
import java.util.List;

public class DimensionList
implements IDimensionList {
    private final List<Integer> whitelist = new ArrayList<Integer>();
    private final List<Integer> blacklist = new ArrayList<Integer>();

    public DimensionList(List<Integer> whitelist, List<Integer> blacklist) {
        this.whitelist.addAll(whitelist);
        this.blacklist.addAll(blacklist);
    }

    @Override
    public boolean matches(int dimensionID) {
        if (this.whitelist.contains(dimensionID)) {
            return true;
        }
        if (this.blacklist.contains(dimensionID)) {
            return false;
        }
        if (!this.whitelist.isEmpty()) {
            return false;
        }
        if (!this.blacklist.isEmpty()) {
            return true;
        }
        return true;
    }

    @Override
    public JsonObject serialize() {
        JsonObject rv = new JsonObject();
        if (!this.whitelist.isEmpty()) {
            JsonArray wl = new JsonArray();
            this.whitelist.stream().forEach(arg_0 -> ((JsonArray)wl).add(arg_0));
            rv.add("includes", (JsonElement)wl);
        }
        if (!this.blacklist.isEmpty()) {
            JsonArray bl = new JsonArray();
            this.blacklist.stream().forEach(arg_0 -> ((JsonArray)bl).add(arg_0));
            rv.add("includes", (JsonElement)bl);
        } else if (this.whitelist.isEmpty()) {
            return new DimensionListAcceptAllOverworld().serialize();
        }
        return rv;
    }
}

