/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.position.Area;
import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.core.HarvestMode;
import powercrystals.minefactoryreloaded.core.IHarvestManager;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.SideOffset;
import powercrystals.minefactoryreloaded.core.TreeHarvestManager;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiHarvester;
import powercrystals.minefactoryreloaded.gui.container.ContainerHarvester;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityHarvester
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private static boolean skip = false;
    private static Map<String, Boolean> DEFAULT_SETTINGS;
    private Map<String, Boolean> _settings;
    private Map<String, Boolean> _immutableSettings;
    private Random _rand;
    private IHarvestManager _treeManager;
    private BlockPosition _lastTree;

    public TileEntityHarvester() {
        super(Machine.Harvester);
        TileEntityHarvester.createHAM(this, 1);
        this.setManageSolids(true);
        this._settings = new HashMap<String, Boolean>();
        this._settings.putAll(DEFAULT_SETTINGS);
        this._immutableSettings = Collections.unmodifiableMap(this._settings);
        this._rand = new Random();
        this.setCanRotate(true);
        skip = MFRConfig.harvesterSkip.getBoolean(false);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this._treeManager != null) {
            this._treeManager.free();
        }
        this._lastTree = null;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            TileEntityHarvester.createHAM(this, 1);
            this.onFactoryInventoryChanged();
            if (this._treeManager != null && this._areaManager.getHarvestArea().contains(this._treeManager.getOrigin())) {
                this._treeManager.setWorld(this.field_145850_b);
            } else {
                this._treeManager = new TreeHarvestManager(this.field_145850_b, new Area(new BlockPosition((TileEntity)this), 0, 0, 0), HarvestMode.FruitTree, this._immutableSettings);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiHarvester(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerHarvester getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerHarvester(this, inventoryPlayer);
    }

    public Map<String, Boolean> getSettings() {
        return this._settings;
    }

    public Map<String, Boolean> getImmutableSettings() {
        return this._immutableSettings;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 5 + this.getExtraIdleTime(10);
    }

    protected int getExtraIdleTime(int n) {
        return this._tanks[0].getFluidAmount() * n / this._tanks[0].getCapacity();
    }

    @Override
    public boolean activateMachine() {
        BlockPosition blockPosition = this.getNextHarvest();
        if (blockPosition == null) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        Block block = this.field_145850_b.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z);
        int n = this.field_145850_b.func_72805_g(blockPosition.x, blockPosition.y, blockPosition.z);
        IFactoryHarvestable iFactoryHarvestable = MFRRegistry.getHarvestables().get(block);
        List<ItemStack> list = iFactoryHarvestable.getDrops(this.field_145850_b, this._rand, this._immutableSettings, blockPosition.x, blockPosition.y, blockPosition.z);
        iFactoryHarvestable.preHarvest(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z);
        if (list instanceof ArrayList) {
            ForgeEventFactory.fireBlockHarvesting((ArrayList)((ArrayList)list), (World)this.field_145850_b, (Block)block, (int)blockPosition.x, (int)blockPosition.y, (int)blockPosition.z, (int)n, (int)0, (float)1.0f, (this._settings.get("silkTouch") == Boolean.TRUE ? 1 : 0) != 0, null);
        }
        if (iFactoryHarvestable.breakBlock()) {
            if (!this.field_145850_b.func_147465_d(blockPosition.x, blockPosition.y, blockPosition.z, Blocks.field_150350_a, 0, 2)) {
                return false;
            }
            if (this._settings.get("playSounds") == Boolean.TRUE) {
                this.field_145850_b.func_72889_a(null, 2001, blockPosition.x, blockPosition.y, blockPosition.z, Block.func_149682_b((Block)block) + (n << 12));
            }
        }
        this.setIdleTicks(this.getExtraIdleTime(10));
        this.doDrop(list);
        this._tanks[0].fill(FluidRegistry.getFluidStack((String)"sludge", (int)10), true);
        iFactoryHarvestable.postHarvest(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z);
        return true;
    }

    private BlockPosition getNextHarvest() {
        int n;
        if (!this._treeManager.getIsDone()) {
            return this.getNextTreeSegment(this._lastTree, false);
        }
        BlockPosition blockPosition = this._areaManager.getNextBlock();
        this._lastTree = null;
        if (skip && (n = this.getExtraIdleTime(10)) > 0 && n > this._rand.nextInt(15)) {
            return null;
        }
        if (!this.field_145850_b.func_72899_e(blockPosition.x, blockPosition.y, blockPosition.z)) {
            return null;
        }
        Block block = this.field_145850_b.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (!MFRRegistry.getHarvestables().containsKey(block)) {
            this._lastTree = null;
            return null;
        }
        this._settings.put("isHarvestingTree", false);
        IFactoryHarvestable iFactoryHarvestable = MFRRegistry.getHarvestables().get(block);
        HarvestType harvestType = iFactoryHarvestable.getHarvestType();
        if (harvestType == HarvestType.Gourd || iFactoryHarvestable.canBeHarvested(this.field_145850_b, this._immutableSettings, blockPosition.x, blockPosition.y, blockPosition.z)) {
            switch (harvestType) {
                case Gourd: {
                    return this.getNextAdjacent(blockPosition.x, blockPosition.y, blockPosition.z, iFactoryHarvestable);
                }
                case Column: 
                case LeaveBottom: {
                    return this.getNextVertical(blockPosition.x, blockPosition.y, blockPosition.z, harvestType == HarvestType.Column ? 0 : 1, iFactoryHarvestable);
                }
                case Tree: 
                case TreeFlipped: 
                case TreeLeaf: {
                    return this.getNextTreeSegment(blockPosition, harvestType == HarvestType.TreeFlipped);
                }
                case TreeFruit: 
                case Normal: {
                    return blockPosition;
                }
            }
        }
        return null;
    }

    private BlockPosition getNextAdjacent(int n, int n2, int n3, IFactoryHarvestable iFactoryHarvestable) {
        for (SideOffset sideOffset : SideOffset.SIDES) {
            int n4 = n + sideOffset.offsetX;
            int n5 = n2 + sideOffset.offsetY;
            int n6 = n3 + sideOffset.offsetX;
            if (!this.field_145850_b.func_72899_e(n4, n5, n6) || !iFactoryHarvestable.canBeHarvested(this.field_145850_b, this._immutableSettings, n4, n5, n6)) continue;
            return new BlockPosition(n4, n5, n6);
        }
        return null;
    }

    private BlockPosition getNextVertical(int n, int n2, int n3, int n4, IFactoryHarvestable iFactoryHarvestable) {
        Block block;
        int n5 = -1;
        int n6 = MFRConfig.verticalHarvestSearchMaxVertical.getInt();
        Block block2 = iFactoryHarvestable.getPlant();
        int n7 = n4;
        while (n7 < n6 && (block = this.field_145850_b.func_147439_a(n, n2 + n7, n3)).equals(block2) && iFactoryHarvestable.canBeHarvested(this.field_145850_b, this._immutableSettings, n, n2 + n7, n3)) {
            n5 = n7++;
        }
        if (n5 >= 0) {
            return new BlockPosition(n, n2 + n5, n3);
        }
        return null;
    }

    private BlockPosition getNextTreeSegment(BlockPosition blockPosition, boolean bl) {
        Object object;
        this._settings.put("isHarvestingTree", true);
        if (!blockPosition.equals(this._lastTree) || this._treeManager.getIsDone()) {
            int n = 0;
            int n2 = MFRConfig.treeSearchMaxVertical.getInt();
            if (bl) {
                n = n2;
                n2 = 0;
            }
            this._lastTree = new BlockPosition(blockPosition);
            object = new Area(this._lastTree, MFRConfig.treeSearchMaxHorizontal.getInt(), n, n2);
            this._treeManager.reset(this.field_145850_b, (Area)object, bl ? HarvestMode.HarvestTreeInverted : HarvestMode.HarvestTree, this._immutableSettings);
        }
        Map<Block, IFactoryHarvestable> map = MFRRegistry.getHarvestables();
        while (!this._treeManager.getIsDone()) {
            HarvestType harvestType;
            BlockPosition blockPosition2 = this._treeManager.getNextBlock();
            this._treeManager.moveNext();
            if (!this.field_145850_b.func_72899_e(blockPosition2.x, blockPosition2.y, blockPosition2.z)) {
                return null;
            }
            Block block = this.field_145850_b.func_147439_a(blockPosition2.x, blockPosition2.y, blockPosition2.z);
            if (!map.containsKey(block) || !((harvestType = (object = map.get(block)).getHarvestType()) == HarvestType.Tree | harvestType == HarvestType.TreeFlipped | harvestType == HarvestType.TreeLeaf | harvestType == HarvestType.TreeFruit) || !object.canBeHarvested(this.field_145850_b, this._immutableSettings, blockPosition2.x, blockPosition2.y, blockPosition2.z)) continue;
            return blockPosition2;
        }
        return null;
    }

    @Override
    public boolean allowBucketDrain(ItemStack itemStack) {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.drain(fluidStack, bl);
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(4000)};
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        for (Map.Entry<String, Boolean> entry : this._settings.entrySet()) {
            String string = entry.getKey();
            if ("playSounds" == string || "isHarvestingTree" == string) continue;
            nBTTagCompound2.func_74757_a(string, entry.getValue() == Boolean.TRUE);
        }
        nBTTagCompound.func_74782_a("harvesterSettings", (NBTBase)nBTTagCompound2);
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagCompound.func_74781_a("harvesterSettings");
        if (nBTTagCompound2 != null) {
            for (String string : this._settings.keySet()) {
                if ("playSounds".equals(string)) continue;
                boolean bl = nBTTagCompound2.func_74767_n(string);
                this._settings.put(string.intern(), bl);
            }
        }
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        for (Map.Entry<String, Boolean> entry : this._settings.entrySet()) {
            String string = entry.getKey();
            if ("playSounds" == string | "isHarvestingTree" == string || DEFAULT_SETTINGS.get(string) == entry.getValue()) continue;
            nBTTagCompound2.func_74757_a(string, entry.getValue() == Boolean.TRUE);
        }
        if (!nBTTagCompound2.func_82582_d()) {
            nBTTagCompound.func_74782_a("harvesterSettings", (NBTBase)nBTTagCompound2);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        this._treeManager.writeToNBT(nBTTagCompound);
        nBTTagCompound.func_74768_a("bpos", this._areaManager.getPosition());
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagCompound.func_74781_a("harvesterSettings");
        if (nBTTagCompound2 != null) {
            for (String string : this._settings.keySet()) {
                if ("playSounds".equals(string)) continue;
                boolean bl = nBTTagCompound2.func_74767_n(string);
                this._settings.put(string.intern(), bl);
            }
        }
        if (this._treeManager != null) {
            this._treeManager.free();
        }
        this._treeManager = new TreeHarvestManager(nBTTagCompound, this._immutableSettings);
        if (!this._treeManager.getIsDone()) {
            this._lastTree = this._treeManager.getOrigin();
        }
        this._areaManager.getHarvestArea();
        this._areaManager.setPosition(nBTTagCompound.func_74762_e("bpos"));
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    @Override
    public int getUpgradeSlot() {
        return 0;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n == 0 && this.isUsableAugment(itemStack);
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    static {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("silkTouch", false);
        hashMap.put("harvestSmallMushrooms", false);
        hashMap.put("playSounds", MFRConfig.playSounds.getBoolean(true));
        hashMap.put("isHarvestingTree", false);
        DEFAULT_SETTINGS = Collections.unmodifiableMap(hashMap);
    }
}

