/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.fluid.FluidTankAdv;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.lang.reflect.Field;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.IFactoryLaserTarget;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiChunkLoader;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerChunkLoader;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.net.ConnectionHandler;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityChunkLoader
extends TileEntityFactoryPowered
implements ITankContainerBucketable,
IFactoryLaserTarget {
    protected static TObjectIntHashMap<String> fluidConsumptionRate = new TObjectIntHashMap();
    protected short _radius = 0;
    protected boolean activated;
    protected boolean unableToRequestTicket;
    public boolean useAltPower = MFRConfig.enableConfigurableCLEnergy.getBoolean(false);
    protected ForgeChunkManager.Ticket _ticket;
    protected int consumptionTicks;
    protected int emptyTicks;
    protected int prevEmpty;
    protected int unactivatedTicks;

    private static void bypassLimit(ForgeChunkManager.Ticket ticket) {
        try {
            Field field = ForgeChunkManager.Ticket.class.getDeclaredField("maxDepth");
            field.setAccessible(true);
            field.setInt(ticket, Short.MAX_VALUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public TileEntityChunkLoader() {
        super(Machine.ChunkLoader);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiChunkLoader(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        if (this.unableToRequestTicket && inventoryPlayer.field_70458_d.func_70005_c_().equals(this._owner)) {
            inventoryPlayer.field_70458_d.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.chunkloader.noticket", new Object[0]));
        }
        return new ContainerChunkLoader(this, inventoryPlayer);
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(10000)};
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this._ticket != null) {
            this.unforceChunks();
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this._ticket);
        }
    }

    public void setRadius(short n) {
        int n2 = 38;
        if (this._ticket != null) {
            n2 = Math.min((int)Math.sqrt((double)this._ticket.getChunkListDepth() / Math.PI), n2);
        }
        if (n < 0 | n > n2 | n == this._radius) {
            return;
        }
        this._radius = (short)n;
        this.func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.forceChunks();
        }
    }

    @Override
    protected boolean activateMachine() {
        this.activated = true;
        this.unactivatedTicks = 0;
        if (this.consumptionTicks > 0) {
            --this.consumptionTicks;
        } else {
            this.emptyTicks = Math.min(65535, this.emptyTicks + 1);
            FluidStack fluidStack = this._tanks[0].getFluid();
            if (this.drain(this._tanks[0], 1, true) == 1) {
                this.consumptionTicks = fluidConsumptionRate.get((Object)this.getFluidName(fluidStack));
                this.emptyTicks = Math.max(-65535, this.emptyTicks - 2);
            }
        }
        return true;
    }

    @Override
    public void func_145845_h() {
        block14: {
            block13: {
                ImmutableSet immutableSet;
                block16: {
                    block15: {
                        if (this._owner.isEmpty()) {
                            return;
                        }
                        if (this.unableToRequestTicket) {
                            this.setIdleTicks(this.getIdleTicksMax());
                            super.setIsActive(false);
                            return;
                        }
                        this.activated = false;
                        if (!this.field_145850_b.field_72995_K && MFRConfig.enableChunkLoaderRequiresOwner.getBoolean(false) && !ConnectionHandler.onlinePlayerMap.containsKey(this._owner)) {
                            this.setIdleTicks(this.getIdleTicksMax());
                        }
                        super.func_145845_h();
                        if (this.field_145850_b.field_72995_K) {
                            return;
                        }
                        if (this.getIdleTicks() > 0) {
                            if (this._ticket != null) {
                                this.unforceChunks();
                            }
                            return;
                        }
                        if (this.activated) break block13;
                        if (this._ticket == null || (immutableSet = this._ticket.getChunkList()).size() == 0) break block14;
                        this.unactivatedTicks = Math.min(this._tanks[0].getCapacity() + 10, this.unactivatedTicks + 1);
                        if (this.consumptionTicks <= 0) break block15;
                        this.consumptionTicks /= 10;
                        break block16;
                    }
                    this.emptyTicks = Math.min(65535, this.emptyTicks + 1);
                    FluidStack fluidStack = this._tanks[0].getFluid();
                    if (this.drain(this._tanks[0], Math.min(this.unactivatedTicks, this._tanks[0].getFluidAmount()), true) != this.unactivatedTicks) break block16;
                    this.consumptionTicks = fluidConsumptionRate.get((Object)this.getFluidName(fluidStack));
                    this.consumptionTicks = Math.max(0, this.consumptionTicks - this.unactivatedTicks);
                    this.activated = this.emptyTicks == 1 && this.unactivatedTicks < this._tanks[0].getCapacity();
                    this.emptyTicks = Math.max(-65535, this.emptyTicks - 2);
                    if (this.activated) break block14;
                }
                for (ChunkCoordIntPair chunkCoordIntPair : immutableSet) {
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this._ticket, (ChunkCoordIntPair)chunkCoordIntPair);
                }
                break block14;
            }
            if (this.activated & !this.isActive()) {
                if (this._ticket == null) {
                    this._ticket = ForgeChunkManager.requestPlayerTicket((Object)((Object)MineFactoryReloadedCore.instance()), (String)this._owner, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                    if (this._ticket == null) {
                        this.unableToRequestTicket = true;
                        return;
                    }
                    this._ticket.getModData().func_74768_a("X", this.field_145851_c);
                    this._ticket.getModData().func_74768_a("Y", this.field_145848_d);
                    this._ticket.getModData().func_74768_a("Z", this.field_145849_e);
                }
                this.forceChunks();
            }
        }
        if (this.prevEmpty != this.emptyTicks) {
            this.prevEmpty = this.emptyTicks;
            this.onFactoryInventoryChanged();
        }
        super.setIsActive(this.activated);
    }

    protected void unforceChunks() {
        ImmutableSet immutableSet = this._ticket.getChunkList();
        if (immutableSet.size() == 0) {
            return;
        }
        for (ChunkCoordIntPair chunkCoordIntPair : immutableSet) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this._ticket, (ChunkCoordIntPair)chunkCoordIntPair);
        }
    }

    protected void forceChunks() {
        int n;
        if (this._ticket == null) {
            return;
        }
        if (MFRConfig.enableChunkLimitBypassing.getBoolean(false)) {
            TileEntityChunkLoader.bypassLimit(this._ticket);
        }
        ImmutableSet immutableSet = this._ticket.getChunkList();
        int n2 = this.field_145851_c >> 4;
        int n3 = this.field_145849_e >> 4;
        int n4 = this._radius * this._radius;
        for (ChunkCoordIntPair chunkCoordIntPair : immutableSet) {
            n = chunkCoordIntPair.field_77276_a - n2;
            int n5 = chunkCoordIntPair.field_77275_b - n3;
            if (n * n + n5 * n5 <= n4) continue;
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this._ticket, (ChunkCoordIntPair)chunkCoordIntPair);
        }
        for (int i = -this._radius; i <= this._radius; ++i) {
            int n6 = i * i;
            for (n = (int)(-this._radius); n <= this._radius; ++n) {
                ChunkCoordIntPair chunkCoordIntPair;
                if (n6 + n * n > n4 || immutableSet.contains(chunkCoordIntPair = new ChunkCoordIntPair(n2 + i, n3 + n))) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this._ticket, (ChunkCoordIntPair)chunkCoordIntPair);
            }
        }
    }

    @Override
    protected void onFactoryInventoryChanged() {
        int n;
        int n2;
        int n3;
        super.onFactoryInventoryChanged();
        if (this.func_145837_r()) {
            return;
        }
        int n4 = this._radius + 1;
        int n5 = this._radius * this._radius;
        if (this._ticket == null) {
            n3 = 0;
            for (n2 = -this._radius; n2 <= this._radius; ++n2) {
                n = n2 * n2;
                for (int i = -this._radius; i <= this._radius; ++i) {
                    if (n + i * i > n5) continue;
                    ++n3;
                }
            }
        } else {
            n3 = this._ticket.getChunkList().size();
        }
        if (this.useAltPower) {
            n = (n5 + 1) * n3 * 16 * this._machine.getActivationEnergy();
            n &= ~n >> 31;
            n2 = n;
            n3 *= 16;
        } else {
            double d = n4 * n4 * 32 - 17 + n4 * n4 * n4;
            int n6 = n4 / 10;
            while (n6-- > 0) {
                d *= (double)n4 / 6.0;
            }
            n2 = (int)(d * 10.0);
        }
        n2 += (int)(StrictMath.cbrt(this.emptyTicks) * (double)n3);
        n2 &= ~n2 >> 31;
        if (n2 == 0) {
            n2 = 1;
        }
        this.setActivationEnergy(n2);
    }

    public boolean receiveTicket(ForgeChunkManager.Ticket ticket) {
        if (!MFRConfig.enableChunkLoaderRequiresOwner.getBoolean(false) || ConnectionHandler.onlinePlayerMap.containsKey(this._owner)) {
            if (this._ticket == null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                this._ticket = ForgeChunkManager.requestPlayerTicket((Object)((Object)MineFactoryReloadedCore.instance()), (String)this._owner, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                if (this._ticket == null) {
                    this.unableToRequestTicket = true;
                    return true;
                }
                this._ticket.getModData().func_74768_a("X", this.field_145851_c);
                this._ticket.getModData().func_74768_a("Y", this.field_145848_d);
                this._ticket.getModData().func_74768_a("Z", this.field_145849_e);
            }
            return true;
        }
        this._ticket = ticket;
        this.unforceChunks();
        this._ticket = null;
        return false;
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74777_a("radius", this._radius);
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.setRadius(nBTTagCompound.func_74765_d("radius"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74777_a("radius", this._radius);
        nBTTagCompound.func_74768_a("empty", this.emptyTicks);
        nBTTagCompound.func_74768_a("inactive", this.unactivatedTicks);
        nBTTagCompound.func_74768_a("consumed", this.consumptionTicks);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.setRadius(nBTTagCompound.func_74765_d("radius"));
        this.emptyTicks = nBTTagCompound.func_74762_e("empty");
        this.unactivatedTicks = nBTTagCompound.func_74762_e("inactive");
        this.consumptionTicks = nBTTagCompound.func_74762_e("consumed");
        this.onFactoryInventoryChanged();
    }

    protected boolean isFluidFuel(FluidStack fluidStack) {
        String string = this.getFluidName(fluidStack);
        if (string == null) {
            return false;
        }
        return fluidConsumptionRate.containsKey((Object)string);
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (!this.unableToRequestTicket & fluidStack != null && this.isFluidFuel(fluidStack)) {
            for (FluidTankAdv fluidTankAdv : this.getTanks()) {
                if (fluidTankAdv.getFluidAmount() != 0 && !fluidStack.isFluidEqual(fluidTankAdv.getFluid())) continue;
                return fluidTankAdv.fill(fluidStack, bl);
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.drain(fluidStack, bl);
    }

    @Override
    public boolean allowBucketFill(ItemStack itemStack) {
        return !this.unableToRequestTicket;
    }

    @Override
    public boolean allowBucketDrain(ItemStack itemStack) {
        return true;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return !this.unableToRequestTicket;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return this.unableToRequestTicket;
    }

    protected String getFluidName(FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return null;
        }
        String string = fluidStack.getFluid().getName();
        if (string == null) {
            return null;
        }
        return string;
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 40;
    }

    public short getRadius() {
        return this._radius;
    }

    public boolean getUnableToWork() {
        return this.unableToRequestTicket;
    }

    @SideOnly(value=Side.CLIENT)
    public void setEmpty(int n) {
        this.emptyTicks = n;
        this.onFactoryInventoryChanged();
    }

    public short getEmpty() {
        return (short)this.emptyTicks;
    }

    @Override
    public void setIsActive(boolean bl) {
    }

    @Override
    public boolean canFormBeamWith(ForgeDirection forgeDirection) {
        return true;
    }

    @Override
    public int addEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.storeEnergy(n, !bl);
    }

    static {
        fluidConsumptionRate.put((Object)"mobessence", 10);
        fluidConsumptionRate.put((Object)"liquidessence", 20);
        fluidConsumptionRate.put((Object)"ender", 40);
    }
}

