/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityBlockBreaker
extends TileEntityFactoryPowered {
    protected BlockPosition bp;

    public TileEntityBlockBreaker() {
        super(Machine.BlockBreaker);
        this.setManageSolids(true);
        this.setCanRotate(true);
    }

    @Override
    protected void onRotate() {
        this.bp = BlockPosition.fromRotateableTile((TileEntity)this).moveForwards(1);
        super.onRotate();
    }

    @Override
    public void onNeighborBlockChange() {
        if (this.bp != null && !this.field_145850_b.func_147437_c(this.bp.x, this.bp.y, this.bp.z)) {
            this.setIdleTicks(0);
        }
    }

    @Override
    public boolean activateMachine() {
        int n = this.bp.x;
        int n2 = this.bp.y;
        int n3 = this.bp.z;
        World world = this.field_145850_b;
        Block block = world.func_147439_a(n, n2, n3);
        int n4 = world.func_72805_g(n, n2, n3);
        if (!block.isAir((IBlockAccess)world, n, n2, n3) && !block.func_149688_o().func_76224_d() && block.func_149712_f(world, n, n2, n3) >= 0.0f) {
            ArrayList arrayList = block.getDrops(world, n, n2, n3, n4, 0);
            if (world.func_147468_f(n, n2, n3)) {
                this.doDrop(arrayList);
                if (MFRConfig.playSounds.getBoolean(true)) {
                    world.func_72889_a(null, 2001, n, n2, n3, Block.func_149682_b((Block)block) + (n4 << 12));
                }
            }
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 60;
    }

    public int func_70302_i_() {
        return 0;
    }
}

