/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetInfo;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetOmniNode;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;
import powercrystals.minefactoryreloaded.block.BlockFactory;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.item.ItemLogicUpgradeCard;
import powercrystals.minefactoryreloaded.item.tool.ItemRedNetMemoryCard;
import powercrystals.minefactoryreloaded.item.tool.ItemRedNetMeter;
import powercrystals.minefactoryreloaded.render.block.RedNetLogicRenderer;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetLogic;

public class BlockRedNetLogic
extends BlockFactory
implements IRedNetOmniNode,
IRedNetInfo,
ITileEntityProvider {
    private int[] _sideRemap = new int[]{3, 1, 2, 0};

    public BlockRedNetLogic() {
        super(0.8f);
        this.func_149663_c("mfr.rednet.logic");
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        TileEntity tileEntity;
        if (entityLivingBase != null && (tileEntity = BlockRedNetLogic.getTile(world, n, n2, n3)) instanceof TileEntityRedNetLogic) {
            int n4 = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            world.func_72921_c(n, n2, n3, n4 + 3 & 3, 3);
        }
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
    }

    public TileEntity func_149915_a(World world, int n) {
        return new TileEntityRedNetLogic();
    }

    @Override
    public int func_149692_a(int n) {
        return 0;
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TileEntityRedNetLogic tileEntityRedNetLogic = (TileEntityRedNetLogic)world.func_147438_o(n, n2, n3);
        if (tileEntityRedNetLogic != null && forgeDirection.ordinal() > 1 && forgeDirection.ordinal() < 6 && world.func_72805_g(n, n2, n3) == this._sideRemap[forgeDirection.ordinal() - 2]) {
            return RedNetConnectionType.None;
        }
        return RedNetConnectionType.CableAll;
    }

    @Override
    public int getOutputValue(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        TileEntityRedNetLogic tileEntityRedNetLogic = (TileEntityRedNetLogic)world.func_147438_o(n, n2, n3);
        if (tileEntityRedNetLogic != null) {
            return tileEntityRedNetLogic.getOutputValue(forgeDirection, n4);
        }
        return 0;
    }

    @Override
    public int[] getOutputValues(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TileEntityRedNetLogic tileEntityRedNetLogic = (TileEntityRedNetLogic)world.func_147438_o(n, n2, n3);
        if (tileEntityRedNetLogic != null) {
            return tileEntityRedNetLogic.getOutputValues(forgeDirection);
        }
        return new int[16];
    }

    @Override
    public void onInputsChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int[] nArray) {
        TileEntityRedNetLogic tileEntityRedNetLogic = (TileEntityRedNetLogic)world.func_147438_o(n, n2, n3);
        if (tileEntityRedNetLogic != null) {
            tileEntityRedNetLogic.onInputsChanged(forgeDirection, nArray);
        }
    }

    @Override
    public void onInputChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
    }

    @Override
    public boolean activated(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4) {
        if (MFRUtil.isHoldingUsableTool(entityPlayer, n, n2, n3) && this.rotateBlock(world, n, n2, n3, ForgeDirection.getOrientation((int)n4))) {
            MFRUtil.usedWrench(entityPlayer, n, n2, n3);
            return true;
        }
        if (MFRUtil.isHolding(entityPlayer, ItemLogicUpgradeCard.class)) {
            TileEntityRedNetLogic tileEntityRedNetLogic = (TileEntityRedNetLogic)world.func_147438_o(n, n2, n3);
            if (tileEntityRedNetLogic != null) {
                if (tileEntityRedNetLogic.insertUpgrade(entityPlayer.field_71071_by.func_70448_g().func_77960_j() + 1)) {
                    // empty if block
                }
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                }
                return true;
            }
            return false;
        }
        if (!MFRUtil.isHolding(entityPlayer, ItemRedNetMeter.class) && !MFRUtil.isHolding(entityPlayer, ItemRedNetMemoryCard.class)) {
            if (!world.field_72995_K) {
                entityPlayer.openGui((Object)MineFactoryReloadedCore.instance(), 0, world, n, n2, n3);
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        this.field_149761_L = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_149739_a());
        RedNetLogicRenderer.updateUVT(this.field_149761_L);
    }

    public int func_149645_b() {
        return MineFactoryReloadedCore.renderIdRedNetLogic;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return forgeDirection.ordinal() <= 1 || forgeDirection.ordinal() >= 6 || iBlockAccess.func_72805_g(n, n2, n3) != this._sideRemap[forgeDirection.ordinal() - 2];
    }

    @Override
    public void getRedNetInfo(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, EntityPlayer entityPlayer, List<IChatComponent> list) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetLogic) {
            int n4 = 0;
            for (int i = 0; i < ((TileEntityRedNetLogic)tileEntity).getBufferLength(13); ++i) {
                int n5 = ((TileEntityRedNetLogic)tileEntity).getVariableValue(i);
                if (n5 == 0) continue;
                list.add(new ChatComponentTranslation("chat.info.mfr.rednet.meter.varprefix", new Object[0]).func_150258_a(" " + i + ": " + n5));
                ++n4;
            }
            if (n4 == 0) {
                list.add((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.meter.var.allzero", new Object[0]));
            } else if (n4 < 16) {
                list.add((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.meter.var.restzero", new Object[0]));
            }
        }
    }
}

