/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.gui.MFRCreativeTab;
import powercrystals.minefactoryreloaded.setup.MFRThings;

public class BlockFertileSoil
extends Block
implements IGrowable {
    public BlockFertileSoil() {
        super(Material.field_151578_c);
        this.func_149711_c(0.6f);
        this.func_149713_g(255);
        this.func_149675_a(false);
        this.setHarvestLevel("hoe", 0);
        this.setHarvestLevel("shovel", 0);
        this.func_149663_c("mfr.farmland");
        this.func_149672_a(Block.field_149767_g);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        this.func_149647_a(MFRCreativeTab.tab);
        this.field_149783_u = true;
    }

    public boolean canSustainPlant(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, IPlantable iPlantable) {
        if (forgeDirection != ForgeDirection.UP) {
            return false;
        }
        EnumPlantType enumPlantType = iPlantable.getPlantType(iBlockAccess, n, n2 + 1, n3);
        switch (enumPlantType) {
            case Cave: 
            case Crop: 
            case Beach: 
            case Desert: 
            case Nether: 
            case Plains: {
                return true;
            }
        }
        return false;
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
    }

    public void func_149719_a(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        if (iBlockAccess.func_147439_a(n, n2 + 1, n3).func_149688_o().func_76220_a()) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int n, int n2, int n3) {
        return AxisAlignedBB.func_72330_a((double)(n + 0), (double)(n2 + 0), (double)(n3 + 0), (double)(n + 1), (double)(n2 + 1), (double)(n3 + 1));
    }

    public boolean func_149727_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        if (!this.func_149851_a(world, n, n2, n3, world.field_72995_K)) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_71045_bC();
        if (itemStack != null && MFRRegistry.getFertilizers().get(itemStack.func_77973_b()) != null) {
            if (this.func_149852_a(world, world.field_73012_v, n, n2, n3)) {
                this.func_149853_b(world, world.field_73012_v, n, n2, n3);
                world.func_72889_a(null, 2005, n, n2, n3, 0);
            }
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                entityPlayer.func_70062_b(0, UtilInventory.consumeItem(itemStack, entityPlayer));
            }
            return true;
        }
        return false;
    }

    public boolean isFertile(World world, int n, int n2, int n3) {
        return world.func_72805_g(n, n2, n3) > 0;
    }

    protected void alterMetadata(World world, int n, int n2, int n3, int n4) {
        world.func_72921_c(n, n2, n3, Math.min(15, Math.max(0, world.func_72805_g(n, n2, n3) + n4)), 6);
    }

    public void onPlantGrow(World world, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.isFertile(world, n, n2, n3)) {
            world.func_147449_b(n, n2, n3, (Block)Blocks.field_150354_m);
        } else {
            this.alterMetadata(world, n, n2, n3, -1);
        }
    }

    public void func_149695_a(World world, int n, int n2, int n3, Block block) {
        super.func_149695_a(world, n, n2, n3, block);
    }

    public void func_149674_a(World world, int n, int n2, int n3, Random random) {
    }

    public void func_149746_a(World world, int n, int n2, int n3, Entity entity, float f) {
        if (f > 10.0f && !world.field_72995_K && world.field_73012_v.nextFloat() * 20.0f < f) {
            if (!(entity instanceof EntityPlayer) && !world.func_82736_K().func_82766_b("mobGriefing")) {
                return;
            }
            world.func_147449_b(n, n2, n3, Blocks.field_150458_ak);
            if ((double)world.field_73012_v.nextFloat() >= 0.25) {
                this.func_149642_a(world, n, n2, n3, new ItemStack(MFRThings.fertilizerItem));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        this.field_149761_L = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_149739_a());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int n, int n2) {
        return n == 1 ? this.field_149761_L : Blocks.field_150346_d.func_149691_a(n, 2);
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return forgeDirection != ForgeDirection.UP;
    }

    public ArrayList<ItemStack> getDrops(World world, int n, int n2, int n3, int n4, int n5) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        arrayList.add(new ItemStack(Blocks.field_150346_d));
        if ((double)world.field_73012_v.nextFloat() >= 0.5) {
            arrayList.add(new ItemStack(MFRThings.fertilizerItem));
        }
        return arrayList;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149851_a(World world, int n, int n2, int n3, boolean bl) {
        return world.func_72805_g(n, n2, n3) < 15;
    }

    public boolean func_149852_a(World world, Random random, int n, int n2, int n3) {
        return world.func_72805_g(n, n2, n3) < 15 && random.nextInt(3) == 0;
    }

    public void func_149853_b(World world, Random random, int n, int n2, int n3) {
        this.alterMetadata(world, n, n2, n3, 1 + (int)(random.nextFloat() * 1.5f));
    }
}

