/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded;

import cofh.lib.util.WeightedRandomItemStack;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizer;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.api.IFactoryGrindable;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.api.IFactoryRanchable;
import powercrystals.minefactoryreloaded.api.ILiquidDrinkHandler;
import powercrystals.minefactoryreloaded.api.IMobEggHandler;
import powercrystals.minefactoryreloaded.api.IMobSpawnHandler;
import powercrystals.minefactoryreloaded.api.INeedleAmmo;
import powercrystals.minefactoryreloaded.api.IRandomMobProvider;
import powercrystals.minefactoryreloaded.api.ISafariNetHandler;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicCircuit;
import powercrystals.minefactoryreloaded.core.UtilInventory;

public abstract class MFRRegistry {
    private static Map<Item, IFactoryPlantable> _plantables = new HashMap<Item, IFactoryPlantable>();
    private static Map<Block, IFactoryHarvestable> _harvestables = new HashMap<Block, IFactoryHarvestable>();
    private static Map<Item, IFactoryFertilizer> _fertilizers = new HashMap<Item, IFactoryFertilizer>();
    private static Map<Block, IFactoryFertilizable> _fertilizables = new HashMap<Block, IFactoryFertilizable>();
    private static Map<Class<? extends EntityLivingBase>, IFactoryRanchable> _ranchables = new HashMap<Class<? extends EntityLivingBase>, IFactoryRanchable>();
    private static Map<String, ILiquidDrinkHandler> _liquidDrinkHandlers = new HashMap<String, ILiquidDrinkHandler>();
    private static Map<Item, INeedleAmmo> _needleAmmoTypes = new HashMap<Item, INeedleAmmo>();
    private static List<Block> _fruitLogBlocks = new ArrayList<Block>();
    private static Map<Block, IFactoryFruit> _fruitBlocks = new HashMap<Block, IFactoryFruit>();
    private static List<WeightedRandom.Item> _sludgeDrops = new ArrayList<WeightedRandom.Item>();
    private static List<String> _rubberTreeBiomes = new ArrayList<String>();
    private static List<IRedNetLogicCircuit> _redNetLogicCircuits = new ArrayList<IRedNetLogicCircuit>();
    private static Map<Class<? extends EntityLivingBase>, IFactoryGrindable> _grindables = new HashMap<Class<? extends EntityLivingBase>, IFactoryGrindable>();
    private static List<Class<?>> _grindableBlacklist = new ArrayList();
    private static List<Class<?>> _safariNetBlacklist = new ArrayList();
    private static List<IMobEggHandler> _eggHandlers = new ArrayList<IMobEggHandler>();
    private static List<ISafariNetHandler> _safariNetHandlers = new ArrayList<ISafariNetHandler>();
    private static List<IRandomMobProvider> _randomMobProviders = new ArrayList<IRandomMobProvider>();
    private static Map<Class<? extends EntityLivingBase>, IMobSpawnHandler> _spawnHandlers = new HashMap<Class<? extends EntityLivingBase>, IMobSpawnHandler>();
    private static List<String> _autoSpawnerBlacklist = new ArrayList<String>();
    private static List<Class<?>> _autoSpawnerClassBlacklist = new ArrayList();
    private static TObjectIntHashMap<String> _autoSpawnerCostMap = new TObjectIntHashMap(10, 0.5f, 0);
    private static List<Class<?>> _slaughterhouseBlacklist = new ArrayList();
    private static List<Class<? extends Entity>> _conveyerBlacklist = new ArrayList<Class<? extends Entity>>();
    private static Map<String, Boolean> _unifierBlacklist = new TreeMap<String, Boolean>();
    private static List<WeightedRandom.Item> _laserOres = new ArrayList<WeightedRandom.Item>();
    private static Map<Integer, List<ItemStack>> _laserPreferredOres = new HashMap<Integer, List<ItemStack>>(16);
    private static Map<String, String> remaps = new HashMap<String, String>();
    private static Map<String, Block> blocks = new HashMap<String, Block>();
    private static Map<String, Item> items = new HashMap<String, Item>();

    public static void registerPlantable(IFactoryPlantable iFactoryPlantable) {
        _plantables.put(iFactoryPlantable.getSeed(), iFactoryPlantable);
    }

    public static Map<Item, IFactoryPlantable> getPlantables() {
        return _plantables;
    }

    public static void registerHarvestable(IFactoryHarvestable iFactoryHarvestable) {
        _harvestables.put(iFactoryHarvestable.getPlant(), iFactoryHarvestable);
    }

    public static Map<Block, IFactoryHarvestable> getHarvestables() {
        return _harvestables;
    }

    public static void registerFertilizable(IFactoryFertilizable iFactoryFertilizable) {
        _fertilizables.put(iFactoryFertilizable.getPlant(), iFactoryFertilizable);
    }

    public static Map<Block, IFactoryFertilizable> getFertilizables() {
        return _fertilizables;
    }

    public static void registerFertilizer(IFactoryFertilizer iFactoryFertilizer) {
        _fertilizers.put(iFactoryFertilizer.getFertilizer(), iFactoryFertilizer);
    }

    public static Map<Item, IFactoryFertilizer> getFertilizers() {
        return _fertilizers;
    }

    public static void registerRanchable(IFactoryRanchable iFactoryRanchable) {
        _ranchables.put(iFactoryRanchable.getRanchableEntity(), iFactoryRanchable);
    }

    public static Map<Class<? extends EntityLivingBase>, IFactoryRanchable> getRanchables() {
        return _ranchables;
    }

    public static void registerGrindable(IFactoryGrindable iFactoryGrindable) {
        _grindables.put(iFactoryGrindable.getGrindableEntity(), iFactoryGrindable);
    }

    public static Map<Class<? extends EntityLivingBase>, IFactoryGrindable> getGrindables() {
        return _grindables;
    }

    public static void registerGrinderBlacklist(Class<?> clazz) {
        _grindableBlacklist.add(clazz);
        if (_safariNetBlacklist.contains(clazz)) {
            _slaughterhouseBlacklist.add(clazz);
        }
    }

    public static List<Class<?>> getGrinderBlacklist() {
        return _grindableBlacklist;
    }

    public static List<Class<?>> getSlaughterhouseBlacklist() {
        return _slaughterhouseBlacklist;
    }

    public static void registerSludgeDrop(int n, ItemStack itemStack) {
        _sludgeDrops.add((WeightedRandom.Item)new WeightedRandomItemStack(itemStack.func_77946_l(), n));
    }

    public static List<WeightedRandom.Item> getSludgeDrops() {
        return _sludgeDrops;
    }

    public static void registerMobEggHandler(IMobEggHandler iMobEggHandler) {
        _eggHandlers.add(iMobEggHandler);
    }

    public static List<IMobEggHandler> getModMobEggHandlers() {
        return _eggHandlers;
    }

    public static void registerSafariNetHandler(ISafariNetHandler iSafariNetHandler) {
        _safariNetHandlers.add(iSafariNetHandler);
    }

    public static List<ISafariNetHandler> getSafariNetHandlers() {
        return _safariNetHandlers;
    }

    public static void registerRubberTreeBiome(String string) {
        _rubberTreeBiomes.add(string);
    }

    public static List<String> getRubberTreeBiomes() {
        return _rubberTreeBiomes;
    }

    public static void registerSafariNetBlacklist(Class<?> clazz) {
        _safariNetBlacklist.add(clazz);
        if (_grindableBlacklist.contains(clazz)) {
            _slaughterhouseBlacklist.add(clazz);
        }
    }

    public static List<Class<?>> getSafariNetBlacklist() {
        return _safariNetBlacklist;
    }

    public static void registerRandomMobProvider(IRandomMobProvider iRandomMobProvider) {
        _randomMobProviders.add(iRandomMobProvider);
    }

    public static List<IRandomMobProvider> getRandomMobProviders() {
        return _randomMobProviders;
    }

    public static void registerLiquidDrinkHandler(String string, ILiquidDrinkHandler iLiquidDrinkHandler) {
        _liquidDrinkHandlers.put(string, iLiquidDrinkHandler);
    }

    public static Map<String, ILiquidDrinkHandler> getLiquidDrinkHandlers() {
        return _liquidDrinkHandlers;
    }

    public static void registerRedNetLogicCircuit(IRedNetLogicCircuit iRedNetLogicCircuit) {
        _redNetLogicCircuits.add(iRedNetLogicCircuit);
    }

    public static List<IRedNetLogicCircuit> getRedNetLogicCircuits() {
        return _redNetLogicCircuits;
    }

    public static void registerLaserOre(int n, ItemStack itemStack) {
        for (WeightedRandom.Item item : _laserOres) {
            if (!UtilInventory.stacksEqual(((WeightedRandomItemStack)item).getStack(), itemStack)) continue;
            item.field_76292_a += n;
            item.field_76292_a /= 2;
            return;
        }
        _laserOres.add((WeightedRandom.Item)new WeightedRandomItemStack(itemStack.func_77946_l(), n));
    }

    public static List<WeightedRandom.Item> getLaserOres() {
        return _laserOres;
    }

    public static void registerFruitLogBlock(Block block) {
        _fruitLogBlocks.add(block);
    }

    public static List<Block> getFruitLogBlocks() {
        return _fruitLogBlocks;
    }

    public static void registerFruit(IFactoryFruit iFactoryFruit) {
        _fruitBlocks.put(iFactoryFruit.getPlant(), iFactoryFruit);
    }

    public static Map<Block, IFactoryFruit> getFruits() {
        return _fruitBlocks;
    }

    public static void registerAutoSpawnerBlacklistClass(Class<? extends EntityLivingBase> clazz) {
        _autoSpawnerClassBlacklist.add(clazz);
    }

    public static List<Class<?>> getAutoSpawnerClassBlacklist() {
        return _autoSpawnerClassBlacklist;
    }

    public static void registerAutoSpawnerBlacklist(String string) {
        _autoSpawnerBlacklist.add(string);
    }

    public static List<String> getAutoSpawnerBlacklist() {
        return _autoSpawnerBlacklist;
    }

    public static void registerSpawnHandler(IMobSpawnHandler iMobSpawnHandler) {
        _spawnHandlers.put(iMobSpawnHandler.getMobClass(), iMobSpawnHandler);
    }

    public static Map<Class<? extends EntityLivingBase>, IMobSpawnHandler> getSpawnHandlers() {
        return _spawnHandlers;
    }

    public static void setBaseSpawnCost(String string, int n) {
        _autoSpawnerCostMap.put((Object)string, n);
    }

    public static int getBaseSpawnCost(String string) {
        return _autoSpawnerCostMap.get((Object)string);
    }

    public static void registerUnifierBlacklist(String string) {
        _unifierBlacklist.put(string, null);
    }

    public static Map<String, Boolean> getUnifierBlacklist() {
        return _unifierBlacklist;
    }

    public static void registerConveyerBlacklist(Class<? extends Entity> clazz) {
        _conveyerBlacklist.add(clazz);
    }

    public static List<Class<? extends Entity>> getConveyerBlacklist() {
        return _conveyerBlacklist;
    }

    public static void addLaserPreferredOre(int n, ItemStack itemStack) {
        if (n < 0 || 16 <= n) {
            return;
        }
        List<ItemStack> list = _laserPreferredOres.get(n);
        if (list == null) {
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            arrayList.add(itemStack);
            _laserPreferredOres.put(n, arrayList);
        } else {
            for (ItemStack itemStack2 : list) {
                if (!UtilInventory.stacksEqual(itemStack2, itemStack)) continue;
                return;
            }
            list.add(itemStack);
        }
    }

    public static List<ItemStack> getLaserPreferredOres(int n) {
        return _laserPreferredOres.get(n);
    }

    public static void registerNeedleAmmoType(Item item, INeedleAmmo iNeedleAmmo) {
        _needleAmmoTypes.put(item, iNeedleAmmo);
    }

    public static Map<Item, INeedleAmmo> getNeedleAmmoTypes() {
        return _needleAmmoTypes;
    }

    private static String remapPhrase(String string) {
        if (!remaps.containsKey(string)) {
            return string;
        }
        return remaps.get(string);
    }

    private static String remapName(String string) {
        String string2 = remaps.get(string);
        if (string2 == null) {
            int n;
            String[] stringArray = string.split("\\.");
            if (stringArray.length < 3) {
                return string2;
            }
            string2 = MFRRegistry.remapPhrase(stringArray[2]);
            string2 = string2 == null ? "" : "." + string2;
            int n2 = stringArray.length;
            for (n = 3; n < n2; ++n) {
                stringArray[n - 2] = MFRRegistry.remapPhrase(stringArray[n]);
            }
            n2 = stringArray.length - 2;
            for (n = 1; n < n2; ++n) {
                if (stringArray[n] == null) continue;
                string2 = string2 + '.' + stringArray[n];
            }
            string2 = string2.substring(1);
        }
        return string2;
    }

    static Block remapBlock(String string) {
        Block block = blocks.get(string);
        if (block == null) {
            block = GameRegistry.findBlock((String)"MineFactoryReloaded", (String)MFRRegistry.remapName(string));
        }
        return block;
    }

    static Item remapItem(String string) {
        Item item = items.get(string);
        if (item == null) {
            item = GameRegistry.findItem((String)"MineFactoryReloaded", (String)MFRRegistry.remapName(string));
        }
        return item;
    }

    static void registerBlock(Block block, Class<? extends ItemBlock> clazz, Object ... objectArray) {
        String string = block.func_149739_a();
        blocks.put(string, block);
        string = MFRRegistry.remapName(string);
        GameRegistry.registerBlock((Block)block, clazz, (String)string, (Object[])objectArray);
        if (clazz != null) {
            items.put(block.func_149739_a(), Item.func_150898_a((Block)block));
        }
    }

    public static void registerItem(Item item, String string) {
        items.put(string, item);
        string = MFRRegistry.remapName(string);
        GameRegistry.registerItem((Item)item, (String)string);
    }

    static {
        remaps.put("liquid", null);
        remaps.put("armor", null);
        remaps.put("decorative", null);
        remaps.put("tile.mfr.decorativebrick", "brick");
        remaps.put("tile.mfr.decorativestone", "stone");
        remaps.put("item.mfr.bucket.plasticcup", "plastic.cup");
        remaps.put("item.mfr.armor.boots.plastic", "plastic.boots");
        remaps.put("item.mfr.pinkslimeball", "pinkslime");
    }
}

