/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.UUID;
import mtr.MTRClient;
import mtr.client.Config;
import mtr.data.TrainClient;
import mtr.entity.EntitySeat;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class TrainRendererBase {
    protected static Camera camera;
    protected static EntityRenderDispatcher entityRenderDispatcher;
    protected static Level world;
    protected static LocalPlayer player;
    protected static float lastFrameDuration;
    protected static PoseStack matrices;
    protected static MultiBufferSource vertexConsumers;
    private static Entity cameraEntity;
    private static boolean hasEntity;
    private static double entityX;
    private static double entityY;
    private static double entityZ;
    private static Vec3 playerEyePosition;

    protected BlockPos getPosAverage(TrainClient train, double x, double y, double z) {
        Vec3 viewOffset = train.getViewOffset();
        boolean noOffset = viewOffset == null;
        Vec3 cameraPos = cameraEntity == null ? null : cameraEntity.m_20182_();
        BlockPos posAverage = new BlockPos(x + (noOffset || cameraPos == null ? 0.0 : cameraPos.f_82479_), y + (noOffset || cameraPos == null ? 0.0 : cameraPos.f_82480_), z + (noOffset || cameraPos == null ? 0.0 : cameraPos.f_82481_));
        if (RenderTrains.shouldNotRender(posAverage, UtilitiesClient.getRenderDistance() * (Config.trainRenderDistanceRatio() + 1), null)) {
            return null;
        }
        matrices.m_85836_();
        if (viewOffset != null) {
            double offsetZ;
            double offsetY;
            double offsetX;
            if (MTRClient.isVivecraft() && hasEntity) {
                offsetX = entityX;
                offsetY = entityY;
                offsetZ = entityZ;
            } else {
                Vec3 cameraOffset = camera.m_90594_() ? playerEyePosition : camera.m_90583_();
                offsetX = cameraOffset.f_82479_;
                offsetY = cameraOffset.f_82480_;
                offsetZ = cameraOffset.f_82481_;
            }
            float cameraYaw = camera.m_90590_();
            matrices.m_85837_(offsetX, offsetY, offsetZ);
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(Utilities.getYaw((Entity)player) - cameraYaw + (float)(Math.abs(Utilities.getYaw((Entity)player) - cameraYaw) > 90.0f ? 180 : 0)));
            matrices.m_85837_(-viewOffset.f_82479_, -viewOffset.f_82480_, -viewOffset.f_82481_);
        }
        return posAverage;
    }

    public abstract TrainRendererBase createTrainInstance(TrainClient var1);

    public abstract void renderCar(int var1, double var2, double var4, double var6, float var8, float var9, boolean var10, float var11, float var12, boolean var13, boolean var14);

    public abstract void renderConnection(Vec3 var1, Vec3 var2, Vec3 var3, Vec3 var4, Vec3 var5, Vec3 var6, Vec3 var7, Vec3 var8, double var9, double var11, double var13, float var15, float var16);

    public abstract void renderBarrier(Vec3 var1, Vec3 var2, Vec3 var3, Vec3 var4, Vec3 var5, Vec3 var6, Vec3 var7, Vec3 var8, double var9, double var11, double var13, float var15, float var16);

    public abstract void renderRidingPlayer(UUID var1, Vec3 var2);

    public static void setupStaticInfo(PoseStack matrices, MultiBufferSource vertexConsumers, EntitySeat entity, float tickDelta) {
        Minecraft client = Minecraft.m_91087_();
        camera = client.f_91063_.m_109153_();
        entityRenderDispatcher = client.m_91290_();
        world = client.f_91073_;
        player = client.f_91074_;
        lastFrameDuration = MTRClient.getLastFrameDuration();
        TrainRendererBase.matrices = matrices;
        TrainRendererBase.vertexConsumers = vertexConsumers;
        cameraEntity = client.f_91075_;
        hasEntity = entity != null;
        entityX = hasEntity ? Mth.m_14139_((double)tickDelta, (double)entity.f_19790_, (double)entity.m_20185_()) : 0.0;
        entityY = hasEntity ? Mth.m_14139_((double)tickDelta, (double)entity.f_19791_, (double)entity.m_20186_()) : 0.0;
        entityZ = hasEntity ? Mth.m_14139_((double)tickDelta, (double)entity.f_19792_, (double)entity.m_20189_()) : 0.0;
        playerEyePosition = player == null ? Vec3.f_82478_ : player.m_20299_(client.m_91296_());
    }
}

