/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Vector3f;
import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Text;
import mtr.render.RenderRouteBase;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class RenderStationNameBase<T extends BlockStationNameBase.TileEntityStationNameBase>
extends BlockEntityRendererMapper<T>
implements IGui,
IDrawing {
    public RenderStationNameBase(BlockEntityRenderDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        BlockState state = world.m_8055_(pos);
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, BlockStationNameBase.f_54117_);
        int color = RenderRouteBase.getShadingColor(facing, ((BlockStationNameBase.TileEntityStationNameBase)entity).getColor(state));
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.5 + (double)((BlockStationNameBase.TileEntityStationNameBase)entity).yOffset, 0.5);
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(-facing.m_122435_()));
        matrices.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
        MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        for (int i = 0; i < (((BlockStationNameBase.TileEntityStationNameBase)entity).isDoubleSided ? 2 : 1); ++i) {
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 0.5 - (double)((BlockStationNameBase.TileEntityStationNameBase)entity).zOffset - (double)0.003125f);
            this.drawStationName((BlockGetter)world, pos, state, facing, matrices, vertexConsumers, immediate, station == null ? Text.translatable("gui.mtr.untitled", new Object[0]).getString() : station.name, station == null ? 0 : station.color, color, light);
            matrices.m_85849_();
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        }
        immediate.m_109911_();
        matrices.m_85849_();
    }

    protected abstract void drawStationName(BlockGetter var1, BlockPos var2, BlockState var3, Direction var4, PoseStack var5, MultiBufferSource var6, MultiBufferSource.BufferSource var7, String var8, int var9, int var10, int var11);
}

