/*
 * Decompiled with CFR 0.152.
 */
package mtr.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mtr.data.IGui;
import mtr.mappings.ModelMapper;
import mtr.render.MoreRenderLayers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public abstract class ModelTrainBase
extends EntityModel<Entity>
implements IGui {
    public void m_6973_(Entity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
    }

    public final void m_7695_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
    }

    public final void render(PoseStack matrices, MultiBufferSource vertexConsumers, ResourceLocation texture, int light, float doorLeftValue, float doorRightValue, boolean opening, int currentCar, int trainCars, boolean head1IsFront, boolean lightsOn, boolean isTranslucent, boolean renderDetails) {
        int lightOnGlowingLevel;
        float doorLeftX = this.getDoorAnimationX(doorLeftValue, opening);
        float doorRightX = this.getDoorAnimationX(doorRightValue, opening);
        float doorLeftZ = this.getDoorAnimationZ(doorLeftValue, opening);
        float doorRightZ = this.getDoorAnimationZ(doorRightValue, opening);
        int lightOnInteriorLevel = lightsOn ? 0xF000B0 : light;
        int n = lightOnGlowingLevel = lightsOn ? 0xF000F0 : light;
        if (isTranslucent) {
            if (renderDetails) {
                RenderType renderLayerInteriorTranslucent = lightsOn ? MoreRenderLayers.getInteriorTranslucent(texture) : MoreRenderLayers.getExteriorTranslucent(texture);
                this.render(matrices, vertexConsumers.m_6299_(renderLayerInteriorTranslucent), RenderStage.INTERIOR_TRANSLUCENT, lightOnInteriorLevel, doorLeftX, doorRightX, doorLeftZ, doorRightZ, currentCar, trainCars, head1IsFront, renderDetails);
            }
        } else {
            RenderType renderLayerLight = lightsOn ? MoreRenderLayers.getLight(texture, false) : MoreRenderLayers.getExterior(texture);
            RenderType renderLayerInterior = lightsOn ? MoreRenderLayers.getInterior(texture) : MoreRenderLayers.getExterior(texture);
            this.render(matrices, vertexConsumers.m_6299_(renderLayerLight), RenderStage.LIGHTS, lightOnGlowingLevel, doorLeftX, doorRightX, doorLeftZ, doorRightZ, currentCar, trainCars, head1IsFront, renderDetails);
            this.render(matrices, vertexConsumers.m_6299_(renderLayerInterior), RenderStage.INTERIOR, lightOnInteriorLevel, doorLeftX, doorRightX, doorLeftZ, doorRightZ, currentCar, trainCars, head1IsFront, renderDetails);
            if (renderDetails) {
                this.renderExtraDetails(matrices, vertexConsumers, light, lightOnInteriorLevel, lightsOn, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
            }
            this.render(matrices, vertexConsumers.m_6299_(MoreRenderLayers.getExterior(texture)), RenderStage.EXTERIOR, light, doorLeftX, doorRightX, doorLeftZ, doorRightZ, currentCar, trainCars, head1IsFront, renderDetails);
            this.render(matrices, vertexConsumers.m_6299_(MoreRenderLayers.getLight(texture, true)), RenderStage.ALWAYS_ON_LIGHTS, 0xF000F0, doorLeftX, doorRightX, doorLeftZ, doorRightZ, currentCar, trainCars, head1IsFront, renderDetails);
        }
    }

    protected void renderExtraDetails(PoseStack matrices, MultiBufferSource vertexConsumers, int light, int lightOnInteriorLevel, boolean lightsOn, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ) {
    }

    protected abstract void render(PoseStack var1, VertexConsumer var2, RenderStage var3, int var4, float var5, float var6, float var7, float var8, int var9, int var10, boolean var11, boolean var12);

    protected abstract float getDoorAnimationX(float var1, boolean var2);

    protected abstract float getDoorAnimationZ(float var1, boolean var2);

    protected static void setRotationAngle(ModelMapper bone, float x, float y, float z) {
        bone.setRotationAngle(x, y, z);
    }

    protected static void renderMirror(ModelMapper bone, PoseStack matrices, VertexConsumer vertices, int light, float position) {
        ModelTrainBase.renderOnce(bone, matrices, vertices, light, position);
        ModelTrainBase.renderOnceFlipped(bone, matrices, vertices, light, position);
    }

    protected static void renderOnce(ModelMapper bone, PoseStack matrices, VertexConsumer vertices, int light, float position) {
        bone.render(matrices, vertices, 0.0f, position, 0.0f, light, OverlayTexture.f_118083_);
    }

    protected static void renderOnce(ModelMapper bone, PoseStack matrices, VertexConsumer vertices, int light, float positionX, float positionZ) {
        bone.render(matrices, vertices, positionX, positionZ, 0.0f, light, OverlayTexture.f_118083_);
    }

    protected static void renderOnceFlipped(ModelMapper bone, PoseStack matrices, VertexConsumer vertices, int light, float position) {
        bone.render(matrices, vertices, 0.0f, position, (float)Math.PI, light, OverlayTexture.f_118083_);
    }

    protected static void renderOnceFlipped(ModelMapper bone, PoseStack matrices, VertexConsumer vertices, int light, float positionX, float positionZ) {
        bone.render(matrices, vertices, -positionX, positionZ, (float)Math.PI, light, OverlayTexture.f_118083_);
    }

    protected static boolean isIndex(int index, int value, int[] array) {
        int finalIndex = index < 0 ? array.length + index : index;
        return finalIndex < array.length && finalIndex >= 0 && array[finalIndex] == value;
    }

    protected static float smoothEnds(float startValue, float endValue, float startTime, float endTime, float time) {
        if (time < startTime) {
            return startValue;
        }
        if (time > endTime) {
            return endValue;
        }
        float timeChange = endTime - startTime;
        float valueChange = endValue - startValue;
        return valueChange * (float)(1.0 - Math.cos(Math.PI * (double)(time - startTime) / (double)timeChange)) / 2.0f + startValue;
    }

    public static enum RenderStage {
        LIGHTS,
        ALWAYS_ON_LIGHTS,
        INTERIOR,
        INTERIOR_TRANSLUCENT,
        EXTERIOR;

    }
}

