/*
 * Decompiled with CFR 0.152.
 */
package mtr.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mtr.model.ModelDoorOverlay;
import mtr.model.ModelDoorOverlayTopBase;
import mtr.model.ModelTrainBase;
import net.minecraft.client.renderer.MultiBufferSource;

public abstract class ModelSimpleTrainBase
extends ModelTrainBase {
    @Override
    protected final void render(PoseStack matrices, VertexConsumer vertices, ModelTrainBase.RenderStage renderStage, int light, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, int car, int totalCars, boolean head1IsFront, boolean renderDetails) {
        boolean isEnd1Head = car == 0;
        boolean isEnd2Head = car == totalCars - 1;
        for (int position : this.getWindowPositions()) {
            this.renderWindowPositions(matrices, vertices, renderStage, light, position, renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, isEnd1Head, isEnd2Head);
        }
        for (int position : this.getDoorPositions()) {
            this.renderDoorPositions(matrices, vertices, renderStage, light, position, renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, isEnd1Head, isEnd2Head);
        }
        if (isEnd1Head) {
            this.renderHeadPosition1(matrices, vertices, renderStage, light, this.getEndPositions()[0], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, head1IsFront);
        } else {
            this.renderEndPosition1(matrices, vertices, renderStage, light, this.getEndPositions()[0], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
        }
        if (isEnd2Head) {
            this.renderHeadPosition2(matrices, vertices, renderStage, light, this.getEndPositions()[1], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, !head1IsFront);
        } else {
            this.renderEndPosition2(matrices, vertices, renderStage, light, this.getEndPositions()[1], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
        }
    }

    @Override
    protected void renderExtraDetails(PoseStack matrices, MultiBufferSource vertexConsumers, int light, int lightOnInteriorLevel, boolean lightsOn, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ) {
        for (int position : this.getDoorPositions()) {
            ModelDoorOverlayTopBase modelDoorOverlayTop;
            ModelDoorOverlay modelDoorOverlay = this.getModelDoorOverlay();
            if (modelDoorOverlay != null) {
                modelDoorOverlay.render(matrices, vertexConsumers, ModelTrainBase.RenderStage.INTERIOR, lightOnInteriorLevel, position, doorLeftX, doorRightX, doorLeftZ, doorRightZ, lightsOn);
                modelDoorOverlay.render(matrices, vertexConsumers, ModelTrainBase.RenderStage.EXTERIOR, light, position, doorLeftX, doorRightX, doorLeftZ, doorRightZ, lightsOn);
            }
            if ((modelDoorOverlayTop = this.getModelDoorOverlayTop()) == null) continue;
            modelDoorOverlayTop.render(matrices, vertexConsumers, light, position, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
        }
    }

    protected abstract void renderWindowPositions(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11, boolean var12);

    protected abstract void renderDoorPositions(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11, boolean var12);

    protected abstract void renderHeadPosition1(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11);

    protected abstract void renderHeadPosition2(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11);

    protected abstract void renderEndPosition1(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10);

    protected abstract void renderEndPosition2(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10);

    protected abstract ModelDoorOverlay getModelDoorOverlay();

    protected abstract ModelDoorOverlayTopBase getModelDoorOverlayTop();

    protected abstract int[] getWindowPositions();

    protected abstract int[] getDoorPositions();

    protected abstract int[] getEndPositions();
}

