/*
 * Decompiled with CFR 0.152.
 */
package mtr.mappings;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.function.Function;
import mtr.mappings.BlockEntityMapper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.io.IOUtils;

public interface Utilities {
    public static float getYaw(Entity entity) {
        return entity.m_146908_();
    }

    public static void setYaw(Entity entity, float yaw) {
        entity.m_146922_(yaw);
    }

    public static void incrementYaw(Entity entity, float yaw) {
        Utilities.setYaw(entity, entity.m_146908_() + yaw);
    }

    public static boolean isHolding(Player player, Function<Item, Boolean> predicate) {
        return player.m_21093_(itemStack -> (Boolean)predicate.apply(itemStack.m_41720_()));
    }

    public static Inventory getInventory(Player player) {
        return player.m_150109_();
    }

    public static Abilities getAbilities(Player player) {
        return player.m_150110_();
    }

    public static void scheduleBlockTick(Level world, BlockPos pos, Block block, int ticks) {
        world.m_186460_(pos, block, ticks);
    }

    public static boolean entityRemoved(Entity entity) {
        return entity == null || entity.m_146910_();
    }

    public static InputStream getInputStream(Resource resource) throws IOException {
        return resource.m_6679_();
    }

    public static InputStream getInputStream(Optional<Resource> optionalResource) throws IOException {
        if (optionalResource.isPresent()) {
            return optionalResource.get().m_6679_();
        }
        return IOUtils.toInputStream((String)"", (Charset)Charset.defaultCharset());
    }

    public static void closeResource(Resource resource) throws IOException {
        resource.close();
    }

    public static void sendCommand(MinecraftServer server, CommandSourceStack commandSourceStack, String command) {
        server.m_129892_().m_82117_(commandSourceStack, command);
    }

    @FunctionalInterface
    public static interface TileEntitySupplier<T extends BlockEntityMapper> {
        public T supplier(BlockPos var1, BlockState var2);
    }
}

