/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mtr.MTRClient;
import mtr.RegistryClient;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.client.TrainClientRegistry;
import mtr.data.Depot;
import mtr.data.RailType;
import mtr.data.Siding;
import mtr.data.Train;
import mtr.entity.EntitySeat;
import mtr.mappings.Utilities;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.path.PathData;
import mtr.render.RenderDrivingOverlay;
import mtr.render.TrainRendererBase;
import mtr.sound.TrainSoundBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class TrainClient
extends Train {
    public boolean isRemoved = false;
    private float clientPrevYaw;
    private boolean justMounted;
    private int previousInterval;
    private float oldSpeed;
    private double oldRailProgress;
    private float oldDoorValue;
    private float oldPercentageX;
    private float oldPercentageZ;
    private double lastSentX;
    private double lastSentY;
    private double lastSentZ;
    private float lastSentTicks;
    private boolean isSitting;
    private boolean previousShifting;
    private SpeedCallback speedCallback;
    private AnnouncementCallback announcementCallback;
    private AnnouncementCallback lightRailAnnouncementCallback;
    private Depot depot;
    private List<Long> routeIds = new ArrayList<Long>();
    public final TrainRendererBase trainRenderer;
    private final TrainSoundBase trainSound;
    private final Set<Runnable> trainTranslucentRenders = new HashSet<Runnable>();
    private final List<Double> offset = new ArrayList<Double>();
    private final Map<UUID, Float> percentagesX = new HashMap<UUID, Float>();
    private final Map<UUID, Float> percentagesZ = new HashMap<UUID, Float>();
    private final Map<UUID, Float> newPercentagesX = new HashMap<UUID, Float>();
    private final Map<UUID, Float> newPercentagesZ = new HashMap<UUID, Float>();
    private final Map<UUID, Vec3> riderPositions = new HashMap<UUID, Vec3>();
    private static final float CONNECTION_HEIGHT = 2.25f;
    private static final float CONNECTION_Z_OFFSET = 0.5f;
    private static final float CONNECTION_X_OFFSET = 0.25f;
    private static final float TRAIN_WALKING_SPEED_MULTIPLIER = 0.25f;
    private static final int TRAIN_PERCENTAGE_UPDATE_INTERVAL = 20;

    public TrainClient(FriendlyByteBuf packet) {
        super(packet);
        TrainClientRegistry.TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(this.trainId);
        this.trainRenderer = trainProperties.renderer.createTrainInstance(this);
        this.trainSound = trainProperties.sound.createTrainInstance(this);
    }

    @Override
    protected void simulateCar(Level world, int ridingCar, float ticksElapsed, double carX, double carY, double carZ, float carYaw, float carPitch, double prevCarX, double prevCarY, double prevCarZ, float prevCarYaw, float prevCarPitch, boolean doorLeftOpen, boolean doorRightOpen, double realSpacing) {
        boolean noOffset;
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer == null) {
            return;
        }
        BlockPos soundPos = new BlockPos(carX, carY, carZ);
        this.trainSound.playAllCars(world, soundPos, ridingCar);
        if (doorLeftOpen || doorRightOpen) {
            this.trainSound.playAllCarsDoorOpening(world, soundPos, ridingCar);
        }
        double newX = carX - ((noOffset = this.offset.isEmpty()) ? 0.0 : this.offset.get(0));
        double newY = carY - (noOffset ? 0.0 : this.offset.get(1));
        double newZ = carZ - (noOffset ? 0.0 : this.offset.get(2));
        this.riderPositions.forEach((uuid, position) -> {
            if (noOffset) {
                this.trainRenderer.renderRidingPlayer((UUID)uuid, (Vec3)position);
            } else {
                this.trainRenderer.renderRidingPlayer((UUID)uuid, position.m_82492_(this.offset.get(0).doubleValue(), this.offset.get(1).doubleValue(), this.offset.get(2).doubleValue()));
            }
        });
        boolean opening = this.doorValue > this.oldDoorValue;
        this.trainRenderer.renderCar(ridingCar, newX, newY, newZ, carYaw, carPitch, false, doorLeftOpen ? this.doorValue : 0.0f, doorRightOpen ? this.doorValue : 0.0f, opening, !this.reversed);
        this.trainTranslucentRenders.add(() -> this.trainRenderer.renderCar(ridingCar, newX, newY, newZ, carYaw, carPitch, true, doorLeftOpen ? this.doorValue : 0.0f, doorRightOpen ? this.doorValue : 0.0f, opening, !this.reversed));
        if (ridingCar > 0) {
            double newPrevCarX = prevCarX - (noOffset ? 0.0 : this.offset.get(0));
            double newPrevCarY = prevCarY - (noOffset ? 0.0 : this.offset.get(1));
            double newPrevCarZ = prevCarZ - (noOffset ? 0.0 : this.offset.get(2));
            Vec3 prevPos0 = new Vec3(0.0, 0.0, (double)this.spacing / 2.0 - 1.0).m_82496_(prevCarPitch).m_82524_(prevCarYaw).m_82520_(newPrevCarX, newPrevCarY, newPrevCarZ);
            Vec3 thisPos0 = new Vec3(0.0, 0.0, -((double)this.spacing / 2.0 - 1.0)).m_82496_(carPitch).m_82524_(carYaw).m_82520_(newX, newY, newZ);
            Vec3 connectPos = prevPos0.m_82549_(thisPos0).m_82490_(0.5);
            float connectYaw = (float)Mth.m_14136_((double)(thisPos0.f_82479_ - prevPos0.f_82479_), (double)(thisPos0.f_82481_ - prevPos0.f_82481_));
            float connectPitch = realSpacing == 0.0 ? 0.0f : (float)this.asin((thisPos0.f_82480_ - prevPos0.f_82480_) / realSpacing);
            for (int i = 0; i < 2; ++i) {
                double xStart = (double)this.width / 2.0 + (i == 0 ? -1.0 : 0.5) * 0.25;
                double zStart = (double)this.spacing / 2.0 - (double)((float)(i == 0 ? 1 : 2) * 0.5f);
                Vec3 prevPos1 = new Vec3(xStart, (double)0.003125f, zStart).m_82496_(prevCarPitch).m_82524_(prevCarYaw).m_82520_(newPrevCarX, newPrevCarY, newPrevCarZ);
                Vec3 prevPos2 = new Vec3(xStart, 2.253124952316284, zStart).m_82496_(prevCarPitch).m_82524_(prevCarYaw).m_82520_(newPrevCarX, newPrevCarY, newPrevCarZ);
                Vec3 prevPos3 = new Vec3(-xStart, 2.253124952316284, zStart).m_82496_(prevCarPitch).m_82524_(prevCarYaw).m_82520_(newPrevCarX, newPrevCarY, newPrevCarZ);
                Vec3 prevPos4 = new Vec3(-xStart, (double)0.003125f, zStart).m_82496_(prevCarPitch).m_82524_(prevCarYaw).m_82520_(newPrevCarX, newPrevCarY, newPrevCarZ);
                Vec3 thisPos1 = new Vec3(-xStart, (double)0.003125f, -zStart).m_82496_(carPitch).m_82524_(carYaw).m_82520_(newX, newY, newZ);
                Vec3 thisPos2 = new Vec3(-xStart, 2.253124952316284, -zStart).m_82496_(carPitch).m_82524_(carYaw).m_82520_(newX, newY, newZ);
                Vec3 thisPos3 = new Vec3(xStart, 2.253124952316284, -zStart).m_82496_(carPitch).m_82524_(carYaw).m_82520_(newX, newY, newZ);
                Vec3 thisPos4 = new Vec3(xStart, (double)0.003125f, -zStart).m_82496_(carPitch).m_82524_(carYaw).m_82520_(newX, newY, newZ);
                if (i == 0) {
                    this.trainRenderer.renderConnection(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, connectPos.f_82479_, connectPos.f_82480_, connectPos.f_82481_, connectYaw, connectPitch);
                    continue;
                }
                this.trainRenderer.renderBarrier(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, connectPos.f_82479_, connectPos.f_82480_, connectPos.f_82481_, connectYaw, connectPitch);
            }
        }
    }

    @Override
    protected boolean handlePositions(Level world, Vec3[] positions, float ticksElapsed) {
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer clientPlayer = client.f_91074_;
        if (clientPlayer == null) {
            return false;
        }
        int interval = (int)Math.floor(MTRClient.getGameTick() / 20.0f);
        if (ticksElapsed > 0.0f) {
            this.offset.clear();
            this.riderPositions.clear();
            if (this.ridingEntities.contains(clientPlayer.m_142081_())) {
                double targetProgress;
                int trainSpacing = this.spacing;
                int headIndex = this.getIndex(0, trainSpacing, false);
                int stopIndex = ((PathData)this.path.get((int)headIndex)).stopIndex - 1;
                if (this.speedCallback != null) {
                    this.speedCallback.speedCallback(this.speed * 20.0f, stopIndex, this.routeIds);
                }
                if (this.announcementCallback != null && this.oldRailProgress < (targetProgress = (Double)this.distances.get(this.getPreviousStoppingIndex(headIndex)) + (double)((this.trainCars + 1) * trainSpacing)) && this.railProgress >= targetProgress) {
                    this.announcementCallback.announcementCallback(stopIndex, this.routeIds);
                }
                if (this.lightRailAnnouncementCallback != null && (this.justOpening() || this.justMounted)) {
                    this.lightRailAnnouncementCallback.announcementCallback(stopIndex, this.routeIds);
                }
            }
            TrainClientRegistry.TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(this.trainId);
            this.ridingEntities.forEach(uuid -> {
                boolean isClientPlayer = uuid.equals(clientPlayer.m_142081_());
                if (!this.percentagesX.containsKey(uuid) || !this.newPercentagesX.containsKey(uuid)) {
                    this.percentagesX.put((UUID)uuid, Float.valueOf(0.5f));
                    this.newPercentagesX.put((UUID)uuid, Float.valueOf(0.5f));
                }
                if (!this.percentagesZ.containsKey(uuid) || !this.newPercentagesZ.containsKey(uuid)) {
                    this.percentagesZ.put((UUID)uuid, Float.valueOf(0.5f));
                    this.newPercentagesZ.put((UUID)uuid, Float.valueOf(0.5f));
                }
                Train.CalculateCarCallback calculateCarCallback = (x, y, z, yaw, pitch, realSpacingRender, doorLeftOpenRender, doorRightOpenRender) -> {
                    Vec3 playerOffset = new Vec3(TrainClient.getValueFromPercentage(this.percentagesX.get(uuid).floatValue(), this.width), doorLeftOpenRender || doorRightOpenRender ? 0.0 : (double)trainProperties.riderOffset, TrainClient.getValueFromPercentage(Mth.m_14187_((float)this.percentagesZ.get(uuid).floatValue()), realSpacingRender)).m_82496_(this.transportMode.hasPitch ? pitch : 0.0f).m_82524_(yaw);
                    ClientData.updatePlayerRidingOffset(uuid);
                    this.riderPositions.put((UUID)uuid, playerOffset.m_82520_(x, y, z));
                    if (isClientPlayer) {
                        boolean movePlayer;
                        double moveX = x + playerOffset.f_82479_;
                        double moveY = y + playerOffset.f_82480_;
                        double moveZ = z + playerOffset.f_82481_;
                        if (MTRClient.isVivecraft()) {
                            boolean movedFar;
                            Entity vehicle = clientPlayer.m_20202_();
                            if (vehicle instanceof EntitySeat) {
                                ((EntitySeat)vehicle).setPosByTrain(moveX, moveY, moveZ);
                                movePlayer = false;
                            } else {
                                movePlayer = true;
                            }
                            float tempPercentageX = this.percentagesX.get(uuid).floatValue();
                            boolean doorOpen = doorLeftOpenRender && tempPercentageX < 0.0f || doorRightOpenRender && tempPercentageX > 1.0f;
                            boolean bl = movedFar = Math.abs(this.lastSentX - moveX) > 2.0 || Math.abs(this.lastSentY - moveY) > 2.0 || Math.abs(this.lastSentZ - moveZ) > 2.0;
                            if (doorOpen || MTRClient.getGameTick() - this.lastSentTicks > 60.0f && movedFar) {
                                PacketTrainDataGuiClient.sendUpdateEntitySeatPassengerPosition(moveX, moveY, moveZ);
                                this.lastSentX = moveX;
                                this.lastSentY = moveY;
                                this.lastSentZ = moveZ;
                                this.lastSentTicks = MTRClient.getGameTick();
                            }
                        } else {
                            movePlayer = true;
                        }
                        if (movePlayer) {
                            clientPlayer.f_19789_ = 0.0f;
                            clientPlayer.m_20334_(0.0, 0.0, 0.0);
                            clientPlayer.m_7910_(0.0f);
                            if (MTRClient.getGameTick() > 40.0f) {
                                clientPlayer.m_20248_(moveX, moveY, moveZ);
                            }
                        }
                        boolean isShifting = clientPlayer.m_6144_();
                        if (Config.shiftToToggleSitting() && !MTRClient.isVivecraft()) {
                            if (isShifting && !this.previousShifting) {
                                this.isSitting = !this.isSitting;
                            }
                            clientPlayer.m_20124_(this.isSitting && client.f_91063_.m_109153_().m_90594_() ? Pose.CROUCHING : Pose.STANDING);
                        }
                        if (this.speed > 0.0f) {
                            if (this.doorValue == 0.0f) {
                                float angleDifference = (float)Math.toDegrees(this.clientPrevYaw - yaw);
                                if (angleDifference > 180.0f) {
                                    angleDifference -= 360.0f;
                                } else if (angleDifference < -180.0f) {
                                    angleDifference += 360.0f;
                                }
                                Utilities.incrementYaw((Entity)clientPlayer, angleDifference);
                            }
                            this.offset.add(x);
                            this.offset.add(y);
                            this.offset.add(z);
                            this.offset.add(playerOffset.f_82479_);
                            this.offset.add(playerOffset.f_82480_ + (double)(MTRClient.isVivecraft() ? 0.0f : clientPlayer.m_20192_()));
                            this.offset.add(playerOffset.f_82481_);
                        }
                        this.clientPrevYaw = yaw;
                        this.previousShifting = isShifting;
                    }
                };
                int currentRidingCar = Mth.m_14045_((int)((int)Math.floor(this.percentagesZ.get(uuid).floatValue())), (int)0, (int)(positions.length - 2));
                this.calculateCar(world, positions, currentRidingCar, 0, (x, y, z, yaw, pitch, realSpacingRender, doorLeftOpenRender, doorRightOpenRender) -> {
                    float newPercentageZ;
                    float newPercentageX;
                    boolean noGangwayConnection = !trainProperties.hasGangwayConnection;
                    float speedMultiplier = ticksElapsed * 0.25f;
                    if (isClientPlayer) {
                        Vec3 movement = new Vec3((double)Math.abs(clientPlayer.f_20900_) > 0.5 ? (double)Math.copySign(speedMultiplier, clientPlayer.f_20900_) : 0.0, 0.0, (double)Math.abs(clientPlayer.f_20902_) > 0.5 ? (double)Math.copySign(speedMultiplier, clientPlayer.f_20902_) : 0.0).m_82524_((float)(-Math.toRadians(Utilities.getYaw((Entity)clientPlayer))) - yaw);
                        float tempPercentageX = this.percentagesX.get(uuid).floatValue() + (float)movement.f_82479_ / (float)this.width;
                        float tempPercentageZ = this.percentagesZ.get(uuid).floatValue() + (float)(realSpacingRender == 0.0 ? 0.0 : movement.f_82481_ / realSpacingRender);
                        newPercentageX = Mth.m_14036_((float)tempPercentageX, (float)(doorLeftOpenRender ? -3.0f : 0.0f), (float)(doorRightOpenRender ? 4.0f : 1.0f));
                        newPercentageZ = Mth.m_14036_((float)tempPercentageZ, (float)((noGangwayConnection ? (float)currentRidingCar + 0.05f : 0.0f) + 0.01f), (float)((noGangwayConnection ? (float)currentRidingCar + 0.95f : (float)this.trainCars) - 0.01f));
                        if (interval != this.previousInterval && (newPercentageX != this.oldPercentageX || newPercentageZ != this.oldPercentageZ)) {
                            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
                            packet.writeLong(this.id);
                            packet.writeFloat(newPercentageX);
                            packet.writeFloat(newPercentageZ);
                            packet.m_130077_(uuid);
                            RegistryClient.sendToServer(PACKET_UPDATE_TRAIN_PASSENGER_POSITION, packet);
                            this.oldPercentageX = newPercentageX;
                            this.oldPercentageZ = newPercentageZ;
                        }
                    } else {
                        double distanceZ;
                        double distanceX = TrainClient.getValueFromPercentage(this.newPercentagesX.get(uuid).floatValue(), this.width) - TrainClient.getValueFromPercentage(this.percentagesX.get(uuid).floatValue(), this.width);
                        double manhattanDistance = Math.abs(distanceX + (distanceZ = TrainClient.getValueFromPercentage(this.newPercentagesZ.get(uuid).floatValue(), realSpacingRender) - TrainClient.getValueFromPercentage(this.percentagesZ.get(uuid).floatValue(), realSpacingRender)));
                        if (manhattanDistance == 0.0 || distanceX * distanceX + distanceZ * distanceZ < (double)(speedMultiplier * speedMultiplier)) {
                            newPercentageX = this.newPercentagesX.get(uuid).floatValue();
                            newPercentageZ = this.newPercentagesZ.get(uuid).floatValue();
                        } else {
                            newPercentageX = this.percentagesX.get(uuid).floatValue() + (float)(distanceX / manhattanDistance * (double)speedMultiplier / (double)this.width);
                            newPercentageZ = this.percentagesZ.get(uuid).floatValue() + (float)(realSpacingRender == 0.0 ? 0.0 : distanceZ / manhattanDistance * (double)speedMultiplier / realSpacingRender);
                        }
                    }
                    this.percentagesX.put((UUID)uuid, Float.valueOf(newPercentageX));
                    this.percentagesZ.put((UUID)uuid, Float.valueOf(newPercentageZ));
                    int newRidingCar = Mth.m_14045_((int)((int)Math.floor(newPercentageZ)), (int)0, (int)(positions.length - 2));
                    if (currentRidingCar == newRidingCar) {
                        calculateCarCallback.calculateCarCallback(x, y, z, yaw, pitch, realSpacingRender, doorLeftOpenRender, doorRightOpenRender);
                    } else {
                        this.calculateCar(world, positions, newRidingCar, 0, calculateCarCallback);
                    }
                });
            });
        }
        this.previousInterval = interval;
        this.justMounted = false;
        Entity camera = client.f_91075_;
        Vec3 cameraPos = camera == null ? Vec3.f_82478_ : camera.m_20182_();
        double nearestDistance = Double.POSITIVE_INFINITY;
        int nearestCar = 0;
        for (int i = 0; i < this.trainCars; ++i) {
            double checkDistance = cameraPos.m_82557_(positions[i]);
            if (!(checkDistance < nearestDistance)) continue;
            nearestCar = i;
            nearestDistance = checkDistance;
        }
        BlockPos soundPos = new BlockPos(positions[nearestCar].f_82479_, positions[nearestCar].f_82480_, positions[nearestCar].f_82481_);
        this.trainSound.playNearestCar(world, soundPos, nearestCar);
        return true;
    }

    @Override
    protected boolean canDeploy(Depot depot) {
        return false;
    }

    @Override
    protected boolean isRailBlocked(int checkIndex) {
        return false;
    }

    @Override
    protected boolean skipScanBlocks(Level world, double trainX, double trainY, double trainZ) {
        return false;
    }

    @Override
    protected boolean openDoors(Level world, Block block, BlockPos checkPos, int dwellTicks) {
        return true;
    }

    @Override
    protected float getModelZOffset() {
        return this.baseTrainType.startsWith("london_underground_199") || this.trainId.startsWith("london_underground_199") ? 0.5f : 0.0f;
    }

    @Override
    protected double asin(double value) {
        return Math.asin(value);
    }

    public void simulateTrain(Level world, float ticksElapsed, SpeedCallback speedCallback, AnnouncementCallback announcementCallback, AnnouncementCallback lightRailAnnouncementCallback) {
        this.trainTranslucentRenders.clear();
        this.speedCallback = speedCallback;
        this.announcementCallback = announcementCallback;
        this.lightRailAnnouncementCallback = lightRailAnnouncementCallback;
        this.oldSpeed = this.speed;
        this.oldRailProgress = this.railProgress;
        this.oldDoorValue = this.doorValue;
        this.simulateTrain(world, ticksElapsed, null);
        if (this.depot == null || this.routeIds.isEmpty()) {
            Siding siding = (Siding)ClientData.DATA_CACHE.sidingIdMap.get(this.sidingId);
            this.depot = siding == null ? null : (Depot)ClientData.DATA_CACHE.sidingIdToDepot.get(siding.id);
            List<Object> list = this.routeIds = this.depot == null ? new ArrayList() : this.depot.routeIds;
            if (this.depot != null) {
                this.depot.lastDeployedMillis = System.currentTimeMillis();
            }
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (this.isManual && Train.isHoldingKey((Player)player) && this.ridingEntities.contains(player.m_142081_())) {
            int stopIndex = ((PathData)this.path.get((int)this.getIndex((int)0, (int)this.spacing, (boolean)false))).stopIndex - 1;
            RenderDrivingOverlay.setData(this.manualAccelerationSign, this.doorValue, this.speed * 20.0f, stopIndex, this.routeIds);
        }
    }

    public void renderTranslucent() {
        this.trainTranslucentRenders.forEach(Runnable::run);
        this.trainTranslucentRenders.clear();
    }

    public Vec3 getViewOffset() {
        return this.offset.isEmpty() ? null : new Vec3(this.offset.get(3).doubleValue(), this.offset.get(4).doubleValue(), this.offset.get(5).doubleValue());
    }

    public void startRidingClient(UUID uuid, float percentageX, float percentageZ) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_142081_().equals(uuid)) {
            this.justMounted = true;
            this.isSitting = false;
        }
        this.ridingEntities.add(uuid);
        this.percentagesX.put(uuid, Float.valueOf(percentageX));
        this.percentagesZ.put(uuid, Float.valueOf(percentageZ));
        this.newPercentagesX.put(uuid, Float.valueOf(percentageX));
        this.newPercentagesZ.put(uuid, Float.valueOf(percentageZ));
    }

    public void updateRiderPercentages(UUID uuid, float percentageX, float percentageZ) {
        this.newPercentagesX.put(uuid, Float.valueOf(percentageX));
        this.newPercentagesZ.put(uuid, Float.valueOf(percentageZ));
    }

    public void copyFromTrain(Train train) {
        this.path.clear();
        this.distances.clear();
        this.ridingEntities.clear();
        this.path.addAll(train.path);
        this.distances.addAll(train.distances);
        this.ridingEntities.addAll(train.ridingEntities);
        this.speed = train.speed;
        this.railProgress = train.railProgress;
        this.stopCounter = train.stopCounter;
        this.nextStoppingIndex = train.nextStoppingIndex;
        this.reversed = train.reversed;
        this.isCurrentlyManual = train.isCurrentlyManual;
        this.isOnRoute = train.isOnRoute;
        this.manualAccelerationSign = train.manualAccelerationSign;
        this.doorOpen = train.doorOpen;
    }

    public float getSpeed() {
        return this.speed;
    }

    public final float speedChange() {
        return this.speed - this.oldSpeed;
    }

    public boolean justOpening() {
        return this.oldDoorValue == 0.0f && this.doorValue > 0.0f;
    }

    public boolean justClosing(float doorCloseTime) {
        return this.oldDoorValue >= doorCloseTime && this.doorValue < doorCloseTime;
    }

    private int getPreviousStoppingIndex(int headIndex) {
        for (int i = headIndex; i >= 0; --i) {
            if (((PathData)this.path.get((int)i)).dwellTime <= 0 || ((PathData)this.path.get((int)i)).rail.railType != RailType.PLATFORM) continue;
            return i;
        }
        return 0;
    }

    @FunctionalInterface
    public static interface SpeedCallback {
        public void speedCallback(float var1, int var2, List<Long> var3);
    }

    @FunctionalInterface
    public static interface AnnouncementCallback {
        public void announcementCallback(int var1, List<Long> var2);
    }
}

