/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mtr.Items;
import mtr.block.BlockPSDAPGBase;
import mtr.block.BlockPlatform;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.MessagePackHelper;
import mtr.data.NameColorDataBase;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.TrainType;
import mtr.data.TransportMode;
import mtr.packet.IPacket;
import mtr.path.PathData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public abstract class Train
extends NameColorDataBase
implements IPacket,
IGui {
    protected float speed;
    protected double railProgress;
    protected boolean doorOpen;
    protected float doorValue;
    protected float stopCounter;
    protected int nextStoppingIndex;
    protected boolean reversed;
    protected boolean isOnRoute = false;
    protected boolean isCurrentlyManual;
    protected int manualAccelerationSign;
    public final long sidingId;
    public final String trainId;
    public final String baseTrainType;
    public final TransportMode transportMode;
    public final int spacing;
    public final int width;
    public final int trainCars;
    public final float accelerationConstant;
    protected final boolean isManual;
    protected final int maxManualSpeed;
    protected final int manualToAutomaticTime;
    protected final List<PathData> path;
    protected final List<Double> distances;
    protected final int repeatIndex1;
    protected final int repeatIndex2;
    protected final Set<UUID> ridingEntities = new HashSet<UUID>();
    protected final SimpleContainer inventory;
    private final float railLength;
    public static final float ACCELERATION_DEFAULT = 0.01f;
    public static final float MAX_ACCELERATION = 0.05f;
    public static final float MIN_ACCELERATION = 0.001f;
    protected static final int MAX_CHECK_DISTANCE = 32;
    protected static final int DOOR_MOVE_TIME = 64;
    private static final int DOOR_DELAY = 20;
    private static final String KEY_SPEED = "speed";
    private static final String KEY_RAIL_PROGRESS = "rail_progress";
    private static final String KEY_STOP_COUNTER = "stop_counter";
    private static final String KEY_NEXT_STOPPING_INDEX = "next_stopping_index";
    private static final String KEY_REVERSED = "reversed";
    private static final String KEY_IS_CURRENTLY_MANUAL = "is_currently_manual";
    private static final String KEY_IS_ON_ROUTE = "is_on_route";
    private static final String KEY_TRAIN_TYPE = "train_type";
    private static final String KEY_TRAIN_CUSTOM_ID = "train_custom_id";
    private static final String KEY_RIDING_ENTITIES = "riding_entities";
    private static final String KEY_CARGO = "cargo";

    public Train(long id, long sidingId, float railLength, String trainId, String baseTrainType, int trainCars, List<PathData> path, List<Double> distances, int repeatIndex1, int repeatIndex2, float accelerationConstant, boolean isManual, int maxManualSpeed, int manualToAutomaticTime) {
        super(id);
        this.sidingId = sidingId;
        this.railLength = railLength;
        this.trainId = trainId;
        this.baseTrainType = baseTrainType = baseTrainType.startsWith("base_") ? baseTrainType.replace("base_", "train_") : baseTrainType;
        this.transportMode = TrainType.getTransportMode(baseTrainType);
        this.spacing = TrainType.getSpacing(baseTrainType);
        this.width = TrainType.getWidth(baseTrainType);
        this.trainCars = trainCars;
        this.isManual = isManual;
        this.isCurrentlyManual = isManual;
        this.maxManualSpeed = maxManualSpeed;
        this.manualToAutomaticTime = manualToAutomaticTime;
        this.path = path;
        this.distances = distances;
        this.repeatIndex1 = repeatIndex1;
        this.repeatIndex2 = repeatIndex2;
        float tempAccelerationConstant = RailwayData.round(accelerationConstant, 3);
        this.accelerationConstant = tempAccelerationConstant <= 0.0f ? 0.01f : tempAccelerationConstant;
        this.inventory = new SimpleContainer(trainCars);
    }

    public Train(long sidingId, float railLength, List<PathData> path, List<Double> distances, int repeatIndex1, int repeatIndex2, float accelerationConstant, boolean isManual, int maxManualSpeed, int manualToAutomaticTime, Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.sidingId = sidingId;
        this.railLength = railLength;
        this.path = path;
        this.distances = distances;
        this.repeatIndex1 = repeatIndex1;
        this.repeatIndex2 = repeatIndex2;
        this.accelerationConstant = accelerationConstant;
        this.isManual = isManual;
        this.maxManualSpeed = maxManualSpeed;
        this.manualToAutomaticTime = manualToAutomaticTime;
        this.speed = messagePackHelper.getFloat(KEY_SPEED);
        this.railProgress = messagePackHelper.getDouble(KEY_RAIL_PROGRESS);
        this.stopCounter = messagePackHelper.getFloat(KEY_STOP_COUNTER);
        this.nextStoppingIndex = messagePackHelper.getInt(KEY_NEXT_STOPPING_INDEX);
        this.reversed = messagePackHelper.getBoolean(KEY_REVERSED);
        String tempTrainId = messagePackHelper.getString(KEY_TRAIN_CUSTOM_ID).toLowerCase();
        String tempBaseTrainType = messagePackHelper.getString(KEY_TRAIN_TYPE).toLowerCase();
        this.baseTrainType = tempBaseTrainType.startsWith("base_") ? tempBaseTrainType.replace("base_", "train_") : tempBaseTrainType;
        this.trainId = tempTrainId.isEmpty() ? this.baseTrainType : tempTrainId;
        this.transportMode = TrainType.getTransportMode(this.baseTrainType);
        this.spacing = TrainType.getSpacing(this.baseTrainType);
        this.width = TrainType.getWidth(this.baseTrainType);
        this.trainCars = Math.min(this.transportMode.maxLength, (int)Math.floor(railLength / (float)this.spacing + 0.01f));
        this.isCurrentlyManual = messagePackHelper.getBoolean(KEY_IS_CURRENTLY_MANUAL);
        this.isOnRoute = messagePackHelper.getBoolean(KEY_IS_ON_ROUTE);
        messagePackHelper.iterateArrayValue(KEY_RIDING_ENTITIES, value -> this.ridingEntities.add(UUID.fromString(value.asStringValue().asString())));
        SimpleContainer inventory1 = new SimpleContainer(this.trainCars);
        if (map.containsKey(KEY_CARGO) && !map.get(KEY_CARGO).isNilValue()) {
            byte[] rawNbt = map.get(KEY_CARGO).asBinaryValue().asByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(rawNbt);
            try {
                CompoundTag compoundTag = NbtIo.m_128928_((DataInput)new DataInputStream(inputStream));
                NonNullList stacks = NonNullList.m_122780_((int)this.trainCars, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)compoundTag.m_128469_(KEY_CARGO), (NonNullList)stacks);
                inventory1 = new SimpleContainer((ItemStack[])stacks.toArray((Object[])new ItemStack[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.inventory = inventory1;
    }

    @Deprecated
    public Train(long sidingId, float railLength, List<PathData> path, List<Double> distances, int repeatIndex1, int repeatIndex2, float accelerationConstant, boolean isManual, int maxManualSpeed, int manualToAutomaticTime, CompoundTag compoundTag) {
        super(compoundTag);
        this.sidingId = sidingId;
        this.railLength = railLength;
        this.path = path;
        this.distances = distances;
        this.repeatIndex1 = repeatIndex1;
        this.repeatIndex2 = repeatIndex2;
        this.accelerationConstant = accelerationConstant;
        this.isManual = isManual;
        this.maxManualSpeed = maxManualSpeed;
        this.manualToAutomaticTime = manualToAutomaticTime;
        this.speed = compoundTag.m_128457_(KEY_SPEED);
        this.railProgress = compoundTag.m_128459_(KEY_RAIL_PROGRESS);
        this.stopCounter = compoundTag.m_128457_(KEY_STOP_COUNTER);
        this.nextStoppingIndex = compoundTag.m_128451_(KEY_NEXT_STOPPING_INDEX);
        this.reversed = compoundTag.m_128471_(KEY_REVERSED);
        this.trainId = compoundTag.m_128461_(KEY_TRAIN_CUSTOM_ID);
        this.baseTrainType = compoundTag.m_128461_(KEY_TRAIN_TYPE);
        this.transportMode = TrainType.getTransportMode(this.baseTrainType);
        this.spacing = TrainType.getSpacing(this.baseTrainType);
        this.width = TrainType.getWidth(this.baseTrainType);
        this.trainCars = Math.min(this.transportMode.maxLength, (int)Math.floor(railLength / (float)this.spacing + 0.01f));
        this.isCurrentlyManual = compoundTag.m_128471_(KEY_IS_CURRENTLY_MANUAL);
        this.isOnRoute = compoundTag.m_128471_(KEY_IS_ON_ROUTE);
        CompoundTag tagRidingEntities = compoundTag.m_128469_(KEY_RIDING_ENTITIES);
        tagRidingEntities.m_128431_().forEach(key -> this.ridingEntities.add(tagRidingEntities.m_128342_(key)));
        NonNullList stacks = NonNullList.m_122780_((int)this.trainCars, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag.m_128469_(KEY_CARGO), (NonNullList)stacks);
        this.inventory = new SimpleContainer((ItemStack[])stacks.toArray((Object[])new ItemStack[0]));
    }

    public Train(FriendlyByteBuf packet) {
        super(packet);
        this.path = new ArrayList<PathData>();
        this.distances = new ArrayList<Double>();
        int pathSize = packet.readInt();
        for (int i = 0; i < pathSize; ++i) {
            this.path.add(new PathData(packet));
            this.distances.add(packet.readDouble());
        }
        this.repeatIndex1 = packet.readInt();
        this.repeatIndex2 = packet.readInt();
        this.sidingId = packet.readLong();
        this.railLength = packet.readFloat();
        this.speed = packet.readFloat();
        float tempAccelerationConstant = RailwayData.round(packet.readFloat(), 3);
        this.accelerationConstant = tempAccelerationConstant <= 0.0f ? 0.01f : tempAccelerationConstant;
        this.railProgress = packet.readDouble();
        this.stopCounter = packet.readFloat();
        this.nextStoppingIndex = packet.readInt();
        this.reversed = packet.readBoolean();
        this.trainId = packet.m_130136_(Short.MAX_VALUE);
        this.baseTrainType = packet.m_130136_(Short.MAX_VALUE);
        this.transportMode = TrainType.getTransportMode(this.baseTrainType);
        this.spacing = TrainType.getSpacing(this.baseTrainType);
        this.width = TrainType.getWidth(this.baseTrainType);
        this.trainCars = Math.min(this.transportMode.maxLength, (int)Math.floor(this.railLength / (float)this.spacing + 0.01f));
        this.isManual = packet.readBoolean();
        this.isCurrentlyManual = packet.readBoolean();
        this.maxManualSpeed = packet.readInt();
        this.manualToAutomaticTime = packet.readInt();
        this.isOnRoute = packet.readBoolean();
        this.manualAccelerationSign = packet.readInt();
        this.doorOpen = packet.readBoolean();
        int ridingEntitiesCount = packet.readInt();
        for (int i = 0; i < ridingEntitiesCount; ++i) {
            this.ridingEntities.add(packet.m_130259_());
        }
        this.inventory = null;
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_SPEED).packFloat(this.speed);
        messagePacker.packString(KEY_RAIL_PROGRESS).packDouble(this.railProgress);
        messagePacker.packString(KEY_STOP_COUNTER).packFloat(this.stopCounter);
        messagePacker.packString(KEY_NEXT_STOPPING_INDEX).packLong(this.nextStoppingIndex);
        messagePacker.packString(KEY_REVERSED).packBoolean(this.reversed);
        messagePacker.packString(KEY_TRAIN_CUSTOM_ID).packString(this.trainId);
        messagePacker.packString(KEY_TRAIN_TYPE).packString(this.baseTrainType);
        messagePacker.packString(KEY_IS_CURRENTLY_MANUAL).packBoolean(this.isCurrentlyManual);
        messagePacker.packString(KEY_IS_ON_ROUTE).packBoolean(this.isOnRoute);
        messagePacker.packString(KEY_RIDING_ENTITIES).packArrayHeader(this.ridingEntities.size());
        for (UUID uuid : this.ridingEntities) {
            messagePacker.packString(uuid.toString());
        }
        messagePacker.packString(KEY_CARGO);
        if (this.inventory != null) {
            NonNullList stacks = NonNullList.m_122780_((int)this.inventory.m_6643_(), (Object)ItemStack.f_41583_);
            int totalCount = 0;
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                stacks.set(i, (Object)this.inventory.m_8020_(i));
                totalCount += this.inventory.m_8020_(i).m_41613_();
            }
            if (totalCount > 0) {
                CompoundTag tag = ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), (NonNullList)stacks);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                NbtIo.m_128941_((CompoundTag)tag, (DataOutput)new DataOutputStream(outputStream));
                messagePacker.packBinaryHeader(outputStream.size());
                messagePacker.writePayload(outputStream.toByteArray());
            } else {
                messagePacker.packNil();
            }
        } else {
            messagePacker.packNil();
        }
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 11;
    }

    @Override
    public void writePacket(FriendlyByteBuf packet) {
        super.writePacket(packet);
        int pathSize = Math.min(this.path.size(), this.distances.size());
        packet.writeInt(pathSize);
        for (int i = 0; i < pathSize; ++i) {
            this.path.get(i).writePacket(packet);
            packet.writeDouble(this.distances.get(i).doubleValue());
        }
        packet.writeInt(this.repeatIndex1);
        packet.writeInt(this.repeatIndex2);
        packet.writeLong(this.sidingId);
        packet.writeFloat(this.railLength);
        packet.writeFloat(this.speed);
        packet.writeFloat(this.accelerationConstant);
        packet.writeDouble(this.railProgress);
        packet.writeFloat(this.stopCounter);
        packet.writeInt(this.nextStoppingIndex);
        packet.writeBoolean(this.reversed);
        packet.m_130070_(this.trainId);
        packet.m_130070_(this.baseTrainType);
        packet.writeBoolean(this.isManual);
        packet.writeBoolean(this.isCurrentlyManual);
        packet.writeInt(this.maxManualSpeed);
        packet.writeInt(this.manualToAutomaticTime);
        packet.writeBoolean(this.isOnRoute);
        packet.writeInt(this.manualAccelerationSign);
        packet.writeBoolean(this.doorOpen);
        packet.writeInt(this.ridingEntities.size());
        this.ridingEntities.forEach(arg_0 -> ((FriendlyByteBuf)packet).m_130077_(arg_0));
    }

    @Override
    protected final boolean hasTransportMode() {
        return false;
    }

    public final boolean getIsOnRoute() {
        return this.isOnRoute;
    }

    public final double getRailProgress() {
        return this.railProgress;
    }

    public final boolean closeToDepot(int trainDistance) {
        return !this.isOnRoute || this.railProgress < (double)((float)trainDistance + this.railLength);
    }

    public final boolean isCurrentlyManual() {
        return this.isCurrentlyManual;
    }

    public boolean changeManualSpeed(boolean isAccelerate) {
        if (this.doorValue == 0.0f && isAccelerate && this.manualAccelerationSign >= -2 && this.manualAccelerationSign < 2) {
            ++this.manualAccelerationSign;
            return true;
        }
        if (!isAccelerate && this.manualAccelerationSign > -2) {
            --this.manualAccelerationSign;
            return true;
        }
        return false;
    }

    public boolean toggleDoors() {
        if (this.speed == 0.0f) {
            this.doorOpen = !this.doorOpen;
            this.manualAccelerationSign = -2;
            return true;
        }
        this.doorOpen = false;
        return false;
    }

    protected final void simulateTrain(Level world, float ticksElapsed, Depot depot) {
        if (world == null) {
            return;
        }
        try {
            float tempDoorValue1;
            if (this.nextStoppingIndex >= this.path.size()) {
                return;
            }
            int dwellTicks = this.path.get((int)this.nextStoppingIndex).dwellTime * 10;
            if (!this.isOnRoute) {
                this.railProgress = (this.railLength + (float)(this.trainCars * this.spacing)) / 2.0f;
                this.reversed = false;
                tempDoorValue1 = 0.0f;
                this.speed = 0.0f;
                this.nextStoppingIndex = 0;
                if (!this.isCurrentlyManual && this.canDeploy(depot) || this.isCurrentlyManual && this.manualAccelerationSign > 0) {
                    this.startUp(world, this.trainCars, this.spacing, this.isOppositeRail());
                }
            } else {
                float newAcceleration = this.accelerationConstant * ticksElapsed;
                if (this.railProgress >= this.distances.get(this.distances.size() - 1) - (double)((this.railLength - (float)(this.trainCars * this.spacing)) / 2.0f)) {
                    this.isOnRoute = false;
                    this.manualAccelerationSign = -2;
                    this.ridingEntities.clear();
                    tempDoorValue1 = 0.0f;
                } else {
                    float tempDoorValue2;
                    if (this.speed <= 0.0f) {
                        this.speed = 0.0f;
                        if (dwellTicks == 0) {
                            tempDoorValue2 = 0.0f;
                        } else {
                            if (this.stopCounter == 0.0f && this.isRepeat() && this.getIndex(this.railProgress, false) >= this.repeatIndex2 && this.distances.size() > this.repeatIndex1) {
                                if (this.path.get(this.repeatIndex2).isOppositeRail(this.path.get(this.repeatIndex1))) {
                                    this.railProgress = this.distances.get(this.repeatIndex1 - 1) + (double)(this.trainCars * this.spacing);
                                    this.reversed = !this.reversed;
                                } else {
                                    this.railProgress = this.distances.get(this.repeatIndex1);
                                }
                            }
                            this.stopCounter += ticksElapsed;
                            if (this.isCurrentlyManual) {
                                this.doorValue = Mth.m_14036_((float)(this.doorValue + ticksElapsed * (float)(this.doorOpen ? 1 : -1) / 64.0f), (float)0.0f, (float)1.0f);
                            }
                            tempDoorValue2 = this.getDoorValue();
                        }
                        if (!world.m_5776_() && (this.isCurrentlyManual || this.stopCounter >= (float)dwellTicks)) {
                            boolean isOppositeRail = this.isOppositeRail();
                            if (!(this.isRailBlocked(this.getIndex(0, this.spacing, true) + (isOppositeRail ? 2 : 1)) || this.isCurrentlyManual && this.manualAccelerationSign <= 0)) {
                                this.startUp(world, this.trainCars, this.spacing, isOppositeRail);
                            }
                        }
                    } else {
                        int checkIndex;
                        if (!world.m_5776_() && this.isRailBlocked(checkIndex = this.getIndex(0, this.spacing, true) + 1)) {
                            this.nextStoppingIndex = checkIndex - 1;
                        }
                        double stoppingDistance = this.distances.get(this.nextStoppingIndex) - this.railProgress;
                        if (!this.transportMode.continuousMovement && stoppingDistance < 0.5 * (double)this.speed * (double)this.speed / (double)this.accelerationConstant) {
                            this.speed = stoppingDistance <= 0.0 ? 0.01f : (float)Math.max((double)this.speed - 0.5 * (double)this.speed * (double)this.speed / stoppingDistance * (double)ticksElapsed, (double)0.01f);
                            this.manualAccelerationSign = -3;
                        } else if (this.isCurrentlyManual) {
                            if (this.manualAccelerationSign >= -2) {
                                RailType railType = Train.convertMaxManualSpeed(this.maxManualSpeed);
                                this.speed = Mth.m_14036_((float)(this.speed + (float)this.manualAccelerationSign * newAcceleration / 2.0f), (float)0.0f, (float)(railType == null ? RailType.IRON.maxBlocksPerTick : railType.maxBlocksPerTick));
                            }
                        } else {
                            float railSpeed = this.getRailSpeed(this.getIndex(0, this.spacing, false));
                            if (this.speed < railSpeed) {
                                this.speed = Math.min(this.speed + newAcceleration, railSpeed);
                                this.manualAccelerationSign = 2;
                            } else if (this.speed > railSpeed) {
                                this.speed = Math.max(this.speed - newAcceleration, railSpeed);
                                this.manualAccelerationSign = -2;
                            } else {
                                this.manualAccelerationSign = 0;
                            }
                        }
                        tempDoorValue2 = 0.0f;
                        this.doorOpen = false;
                        this.doorValue = 0.0f;
                    }
                    this.railProgress += (double)(this.speed * ticksElapsed);
                    if (!this.transportMode.continuousMovement && this.railProgress > this.distances.get(this.nextStoppingIndex)) {
                        this.railProgress = this.distances.get(this.nextStoppingIndex);
                        this.speed = 0.0f;
                        this.manualAccelerationSign = -2;
                    }
                    tempDoorValue1 = tempDoorValue2 + (this.transportMode.continuousMovement ? this.getDoorValueContinuous() : 0.0f);
                }
            }
            this.doorValue = tempDoorValue1;
            if (!this.path.isEmpty()) {
                Vec3[] positions = new Vec3[this.trainCars + 1];
                for (int i = 0; i <= this.trainCars; ++i) {
                    positions[i] = this.getRoutePosition(this.reversed ? this.trainCars - i : i, this.spacing);
                }
                if (this.handlePositions(world, positions, ticksElapsed)) {
                    double[] prevX = new double[]{0.0};
                    double[] prevY = new double[]{0.0};
                    double[] prevZ = new double[]{0.0};
                    float[] prevYaw = new float[]{0.0f};
                    float[] prevPitch = new float[]{0.0f};
                    for (int i = 0; i < this.trainCars; ++i) {
                        int ridingCar = i;
                        this.calculateCar(world, positions, i, dwellTicks, (x, y, z, yaw, pitch, realSpacing, doorLeftOpen, doorRightOpen) -> {
                            this.simulateCar(world, ridingCar, ticksElapsed, x, y, z, yaw, pitch, prevX[0], prevY[0], prevZ[0], prevYaw[0], prevPitch[0], doorLeftOpen, doorRightOpen, realSpacing);
                            prevX[0] = x;
                            prevY[0] = y;
                            prevZ[0] = z;
                            prevYaw[0] = yaw;
                            prevPitch[0] = pitch;
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected final void calculateCar(Level world, Vec3[] positions, int index, int dwellTicks, CalculateCarCallback calculateCarCallback) {
        Vec3 pos1 = positions[index];
        Vec3 pos2 = positions[index + 1];
        if (pos1 != null && pos2 != null) {
            double x = Train.getAverage(pos1.f_82479_, pos2.f_82479_);
            double y = Train.getAverage(pos1.f_82480_, pos2.f_82480_) + 1.0;
            double z = Train.getAverage(pos1.f_82481_, pos2.f_82481_);
            double realSpacing = pos2.m_82554_(pos1);
            float yaw = (float)Mth.m_14136_((double)(pos2.f_82479_ - pos1.f_82479_), (double)(pos2.f_82481_ - pos1.f_82481_));
            float pitch = realSpacing == 0.0 ? 0.0f : (float)this.asin((pos2.f_82480_ - pos1.f_82480_) / realSpacing);
            boolean doorLeftOpen = this.scanDoors(world, x, y, z, (float)Math.PI + yaw, pitch, realSpacing / 2.0, dwellTicks) && this.doorValue > 0.0f;
            boolean doorRightOpen = this.scanDoors(world, x, y, z, yaw, pitch, realSpacing / 2.0, dwellTicks) && this.doorValue > 0.0f;
            calculateCarCallback.calculateCarCallback(x, y, z, yaw, pitch, realSpacing, doorLeftOpen, doorRightOpen);
        }
    }

    public final int getIndex(int car, int trainSpacing, boolean roundDown) {
        return this.getIndex(this.getRailProgress(car, trainSpacing), roundDown);
    }

    public final int getIndex(double tempRailProgress, boolean roundDown) {
        for (int i = 0; i < this.path.size(); ++i) {
            double tempDistance = this.distances.get(i);
            if (!(tempRailProgress < tempDistance) && (!roundDown || tempRailProgress != tempDistance)) continue;
            return i;
        }
        return this.path.size() - 1;
    }

    public final float getRailSpeed(int railIndex) {
        float railSpeed;
        RailType thisRail = this.path.get((int)railIndex).rail.railType;
        if (thisRail.canAccelerate) {
            railSpeed = thisRail.maxBlocksPerTick;
        } else {
            RailType lastRail = railIndex > 0 ? this.path.get((int)(railIndex - 1)).rail.railType : thisRail;
            railSpeed = Math.max(lastRail.canAccelerate ? lastRail.maxBlocksPerTick : RailType.getDefaultMaxBlocksPerTick(this.transportMode), this.speed);
        }
        return railSpeed;
    }

    protected void startUp(Level world, int trainCars, int trainSpacing, boolean isOppositeRail) {
        this.doorOpen = false;
        this.doorValue = 0.0f;
    }

    protected float getModelZOffset() {
        return 0.0f;
    }

    protected boolean isRepeat() {
        return this.repeatIndex1 > 0 && this.repeatIndex2 > 0;
    }

    protected abstract void simulateCar(Level var1, int var2, float var3, double var4, double var6, double var8, float var10, float var11, double var12, double var14, double var16, float var18, float var19, boolean var20, boolean var21, double var22);

    protected abstract boolean handlePositions(Level var1, Vec3[] var2, float var3);

    protected abstract boolean canDeploy(Depot var1);

    protected abstract boolean isRailBlocked(int var1);

    protected abstract boolean skipScanBlocks(Level var1, double var2, double var4, double var6);

    protected abstract boolean openDoors(Level var1, Block var2, BlockPos var3, int var4);

    protected abstract double asin(double var1);

    private boolean isOppositeRail() {
        return this.path.size() > this.nextStoppingIndex + 1 && this.railProgress == this.distances.get(this.nextStoppingIndex) && this.path.get(this.nextStoppingIndex).isOppositeRail(this.path.get(this.nextStoppingIndex + 1));
    }

    private double getRailProgress(int car, int trainSpacing) {
        return this.railProgress - (double)(car * trainSpacing);
    }

    private Vec3 getRoutePosition(int car, int trainSpacing) {
        double tempRailProgress = Math.max(this.getRailProgress(car, trainSpacing) - (double)this.getModelZOffset(), 0.0);
        int index = this.getIndex(tempRailProgress, false);
        return this.path.get((int)index).rail.getPosition(tempRailProgress - (index == 0 ? 0.0 : this.distances.get(index - 1))).m_82520_(0.0, (double)this.transportMode.railOffset, 0.0);
    }

    private float getDoorValue() {
        if (!this.isCurrentlyManual) {
            int dwellTicks = this.path.get((int)this.nextStoppingIndex).dwellTime * 10;
            float maxDoorMoveTime = Math.min(64, dwellTicks / 2 - 20);
            float stage1 = 20.0f;
            float stage2 = 20.0f + maxDoorMoveTime;
            float stage3 = (float)(dwellTicks - 20) - maxDoorMoveTime;
            float stage4 = dwellTicks - 20;
            if (this.stopCounter < 20.0f || this.stopCounter >= stage4) {
                this.doorOpen = false;
                this.doorValue = 0.0f;
            } else if (this.stopCounter >= stage2 && this.stopCounter < stage3) {
                this.doorOpen = true;
                this.doorValue = 1.0f;
            } else if (this.stopCounter < stage2) {
                this.doorOpen = true;
                this.doorValue = (this.stopCounter - 20.0f) / 64.0f;
            } else if (this.stopCounter >= stage3) {
                this.doorOpen = false;
                this.doorValue = (stage4 - this.stopCounter) / 64.0f;
            } else {
                this.doorOpen = false;
                this.doorValue = 0.0f;
            }
        }
        if (this.doorOpen || this.doorValue != 0.0f) {
            this.manualAccelerationSign = -2;
        }
        return this.doorValue;
    }

    private float getDoorValueContinuous() {
        int index = this.getIndex(this.railProgress, false);
        if (this.path.get((int)index).dwellTime > 0 && index > 0) {
            double distance1 = this.distances.get(index - 1);
            double distance2 = this.distances.get(index);
            return (float)Mth.m_14008_((double)(Math.min(this.railProgress - distance1, distance2 - this.railProgress) * 0.5), (double)0.0, (double)1.0);
        }
        return 0.0f;
    }

    private boolean scanDoors(Level world, double trainX, double trainY, double trainZ, float checkYaw, float pitch, double halfSpacing, int dwellTicks) {
        if (this.skipScanBlocks(world, trainX, trainY, trainZ)) {
            return false;
        }
        boolean hasPlatform = false;
        Vec3 offsetVec = new Vec3(1.0, 0.0, 0.0).m_82524_(checkYaw).m_82496_(pitch);
        Vec3 traverseVec = new Vec3(0.0, 0.0, 1.0).m_82524_(checkYaw).m_82496_(pitch);
        for (int checkX = 1; checkX <= 3; ++checkX) {
            for (int checkY = -2; checkY <= 0; ++checkY) {
                for (double checkZ = -halfSpacing; checkZ <= halfSpacing; checkZ += 1.0) {
                    BlockPos checkPos = new BlockPos(trainX + offsetVec.f_82479_ * (double)checkX + traverseVec.f_82479_ * checkZ, trainY + (double)checkY, trainZ + offsetVec.f_82481_ * (double)checkX + traverseVec.f_82481_ * checkZ);
                    Block block = world.m_8055_(checkPos).m_60734_();
                    if (!(block instanceof BlockPlatform) && !(block instanceof BlockPSDAPGBase)) continue;
                    if (this.openDoors(world, block, checkPos, dwellTicks)) {
                        return true;
                    }
                    hasPlatform = true;
                }
            }
        }
        return hasPlatform;
    }

    public static boolean isHoldingKey(Player player) {
        return player != null && player.m_21055_(Items.DRIVER_KEY.get());
    }

    public static double getAverage(double a, double b) {
        return (a + b) / 2.0;
    }

    public static double getValueFromPercentage(double percentage, double total) {
        return (percentage - 0.5) * total;
    }

    public static RailType convertMaxManualSpeed(int maxManualSpeed) {
        if (maxManualSpeed >= 0 && maxManualSpeed <= RailType.DIAMOND.ordinal()) {
            return RailType.values()[maxManualSpeed];
        }
        return null;
    }

    @FunctionalInterface
    protected static interface CalculateCarCallback {
        public void calculateCarCallback(double var1, double var3, double var5, float var7, float var8, double var9, boolean var11, boolean var12);
    }
}

