/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mtr.data.DataCache;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.RailwayDataModuleBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;

public class RailwayDataRouteFinderModule
extends RailwayDataModuleBase {
    private Map<BlockPos, Map<BlockPos, Integer>> connectionDensityOld = new HashMap<BlockPos, Map<BlockPos, Integer>>();
    private Map<BlockPos, Map<BlockPos, Integer>> connectionDensity = new HashMap<BlockPos, Map<BlockPos, Integer>>();
    private BlockPos startPos;
    private BlockPos endPos;
    private int totalTime;
    private int count;
    private TickStage tickStage = TickStage.GET_POS;
    private final RailwayData railwayData;
    private final Map<BlockPos, Integer> globalBlacklist = new HashMap<BlockPos, Integer>();
    private final Map<BlockPos, Integer> localBlacklist = new HashMap<BlockPos, Integer>();
    private final List<BlockPos> tempPositions = new ArrayList<BlockPos>();
    private final List<Integer> tempDurations = new ArrayList<Integer>();
    private final Set<BlockPos> platformPositions = new HashSet<BlockPos>();
    private final List<BlockPos> positions = new ArrayList<BlockPos>();
    private static final int WALKING_SPEED_TICKS_PER_METER = 5;

    public RailwayDataRouteFinderModule(RailwayData railwayData, Level world, Map<BlockPos, Map<BlockPos, Rail>> rails) {
        super(railwayData, world, rails);
        this.railwayData = railwayData;
    }

    public void tick() {
        if (this.railwayData.dataCache.platformConnections.size() < 4) {
            return;
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 2L) {
            switch (this.tickStage) {
                case GET_POS: {
                    Random random = new Random();
                    int startIndex = random.nextInt(this.railwayData.dataCache.platformConnections.size());
                    int endIndex = random.nextInt(this.railwayData.dataCache.platformConnections.size());
                    if (startIndex == endIndex) break;
                    int i = 0;
                    for (BlockPos pos : this.railwayData.dataCache.platformConnections.keySet()) {
                        if (i == startIndex) {
                            this.startPos = pos;
                        }
                        if (i == endIndex) {
                            this.endPos = pos;
                        }
                        ++i;
                    }
                    this.globalBlacklist.clear();
                    this.totalTime = Integer.MAX_VALUE;
                    this.tickStage = TickStage.START_FIND_ROUTE;
                    break;
                }
                case START_FIND_ROUTE: {
                    this.tempPositions.clear();
                    this.tempDurations.clear();
                    this.platformPositions.clear();
                    this.platformPositions.addAll(this.railwayData.dataCache.platformConnections.keySet());
                    this.platformPositions.add(this.endPos);
                    this.localBlacklist.clear();
                    this.tickStage = TickStage.FIND_ROUTE;
                    break;
                }
                case FIND_ROUTE: {
                    if (this.startPos == null || this.endPos == null) {
                        this.tickStage = TickStage.GET_POS;
                        break;
                    }
                    if (!this.findRoutePart()) break;
                    this.tickStage = TickStage.END_FIND_ROUTE;
                    break;
                }
                case END_FIND_ROUTE: {
                    int i;
                    if (this.tempPositions.isEmpty()) {
                        for (i = 0; i < this.positions.size() - 1; ++i) {
                            DataCache.put(this.connectionDensity, this.positions.get(i), this.positions.get(i + 1), oldValue -> oldValue == null ? 1 : oldValue + 1);
                        }
                        ++this.count;
                        if (this.count >= this.getMaxCount()) {
                            this.connectionDensityOld = this.connectionDensity;
                            this.connectionDensity = new HashMap<BlockPos, Map<BlockPos, Integer>>();
                            this.count = 0;
                        }
                        this.tickStage = TickStage.GET_POS;
                        break;
                    }
                    int elapsedTime = this.tempDurations.stream().mapToInt(Integer::intValue).sum();
                    if (elapsedTime > 0 && elapsedTime < this.totalTime) {
                        this.totalTime = elapsedTime;
                        this.positions.clear();
                        this.positions.addAll(this.tempPositions);
                    }
                    this.tickStage = TickStage.START_FIND_ROUTE;
                }
            }
        }
    }

    public int getConnectionDensity(BlockPos posStart, BlockPos posEnd) {
        return DataCache.tryGet(this.connectionDensityOld, posStart, posEnd, this.count == 0 ? 0 : DataCache.tryGet(this.connectionDensity, posStart, posEnd, 0) * this.getMaxCount() / this.count);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean findRoutePart() {
        int elapsedTime = this.tempDurations.stream().mapToInt(Integer::intValue).sum();
        BlockPos prevPos = this.tempPositions.isEmpty() ? this.startPos : this.tempPositions.get(this.tempPositions.size() - 1);
        BlockPos bestPosition = null;
        float bestIncrease = -3.4028235E38f;
        int bestDuration = 0;
        for (BlockPos thisPos : this.platformPositions) {
            int duration = DataCache.tryGet(this.railwayData.dataCache.platformConnections, prevPos, thisPos, prevPos.m_123333_((Vec3i)thisPos) * 5);
            if (elapsedTime + duration >= this.totalTime || this.localBlacklist.containsKey(thisPos) && elapsedTime + duration >= this.localBlacklist.get(thisPos) || this.globalBlacklist.containsKey(thisPos) && elapsedTime + duration > this.globalBlacklist.get(thisPos)) continue;
            float increase = (float)(prevPos.m_123333_((Vec3i)this.endPos) - thisPos.m_123333_((Vec3i)this.endPos)) / (float)duration;
            this.globalBlacklist.put(thisPos, elapsedTime + duration);
            if (!(increase > bestIncrease)) continue;
            bestPosition = thisPos;
            bestIncrease = increase;
            bestDuration = duration;
        }
        if (bestPosition == null || bestDuration == 0) {
            if (this.tempPositions.isEmpty() || this.tempDurations.isEmpty()) return true;
            this.tempPositions.remove(this.tempPositions.size() - 1);
            this.tempDurations.remove(this.tempDurations.size() - 1);
            return this.tempPositions.contains(this.endPos);
        } else {
            this.localBlacklist.put(bestPosition, elapsedTime + bestDuration);
            this.tempPositions.add(bestPosition);
            this.tempDurations.add(bestDuration);
        }
        return this.tempPositions.contains(this.endPos);
    }

    private int getMaxCount() {
        return this.railwayData.dataCache.platformConnections.size() * 100;
    }

    private static enum TickStage {
        GET_POS,
        START_FIND_ROUTE,
        FIND_ROUTE,
        END_FIND_ROUTE;

    }
}

