/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mtr.block.BlockLiftButtons;
import mtr.data.RailwayData;
import mtr.entity.EntityLift;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LiftInstructions {
    private final List<LiftInstruction> instructions = new ArrayList<LiftInstruction>();
    private final Consumer<String> callback;

    public LiftInstructions(Consumer<String> callback) {
        this.callback = callback;
    }

    public void getTargetFloor(Consumer<Integer> callback) {
        if (this.hasInstructions()) {
            callback.accept(this.instructions.get((int)0).floor);
        }
    }

    public void arrived() {
        if (this.hasInstructions()) {
            this.instructions.remove(0);
            this.callback.accept(this.toString());
        }
    }

    public boolean hasInstructions() {
        return !this.instructions.isEmpty();
    }

    public void addInstruction(int currentFloor, boolean currentMovingUp, int floor) {
        this.addInstruction(currentFloor, currentMovingUp, floor, false, true, true);
    }

    private int addInstruction(int currentFloor, boolean currentMovingUp, int newFloor, boolean newMovingUp, boolean noDirection, boolean shouldAdd) {
        int lastInstruction;
        if (currentFloor == newFloor) {
            return 0;
        }
        ArrayList<LiftInstruction> tempInstructions = new ArrayList<LiftInstruction>(this.instructions);
        tempInstructions.add(0, new LiftInstruction(currentFloor, currentMovingUp));
        int distance = 0;
        for (int i = 0; i < tempInstructions.size() - 1; ++i) {
            boolean newMovingUpTemp;
            LiftInstruction previousInstruction = (LiftInstruction)tempInstructions.get(i);
            LiftInstruction nextInstruction = (LiftInstruction)tempInstructions.get(i + 1);
            boolean bl = newMovingUpTemp = noDirection ? nextInstruction.movingUp : newMovingUp;
            if (this.instructions.contains(new LiftInstruction(newFloor, newMovingUpTemp))) {
                return -1;
            }
            if (nextInstruction.canInsert(previousInstruction, newFloor, newMovingUpTemp)) {
                if (shouldAdd) {
                    this.instructions.add(i, new LiftInstruction(newFloor, newMovingUpTemp));
                    this.callback.accept(this.toString());
                }
                return distance + Math.abs(newFloor - previousInstruction.floor);
            }
            distance += Math.abs(nextInstruction.floor - previousInstruction.floor);
        }
        int n = lastInstruction = this.hasInstructions() ? this.instructions.get((int)(this.instructions.size() - 1)).floor : currentFloor;
        if (shouldAdd) {
            this.instructions.add(new LiftInstruction(newFloor, noDirection ? newFloor > lastInstruction : newMovingUp));
            this.callback.accept(this.toString());
        }
        return distance + Math.abs(newFloor - lastInstruction);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.instructions.forEach(liftInstruction -> stringBuilder.append("floor_").append(liftInstruction.floor).append("_").append(liftInstruction.movingUp).append(","));
        return stringBuilder.toString();
    }

    public static void addInstruction(Level world, BlockPos pos, boolean topHalfClicked) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof BlockLiftButtons.TileEntityLiftButtons)) {
            return;
        }
        int[] currentWeight = new int[]{Integer.MAX_VALUE};
        LiftInstructions[] liftInstructionsToUse = new LiftInstructions[]{null};
        int[] liftFloorToUse = new int[]{0};
        boolean[] liftMovingUpToUse = new boolean[]{false};
        int[] newLiftFloorToUse = new int[]{0};
        boolean[] hasButtonOverall = new boolean[]{false, false};
        ((BlockLiftButtons.TileEntityLiftButtons)blockEntity).forEachTrackPosition(world, (trackPosition, trackFloorTileEntity) -> {
            EntityLift entityLift = trackFloorTileEntity.getEntityLift();
            if (entityLift != null) {
                int liftFloor = (int)Math.round(entityLift.m_20186_());
                int newLiftFloor = trackPosition.m_123342_();
                boolean[] hasButton = new boolean[]{false, false};
                entityLift.hasButton(newLiftFloor, hasButton);
                boolean newMovingUp = topHalfClicked ? hasButton[0] : !hasButton[1];
                boolean liftMovingUp = entityLift.getLiftDirection() == EntityLift.LiftDirection.UP;
                int weight = entityLift.liftInstructions.addInstruction(liftFloor, liftMovingUp, newLiftFloor, newMovingUp, false, false);
                if (weight >= 0 && (topHalfClicked == newMovingUp && weight < currentWeight[0] || newMovingUp && !hasButtonOverall[0] || !newMovingUp && !hasButtonOverall[1])) {
                    currentWeight[0] = weight;
                    liftInstructionsToUse[0] = entityLift.liftInstructions;
                    liftFloorToUse[0] = liftFloor;
                    liftMovingUpToUse[0] = liftMovingUp;
                    newLiftFloorToUse[0] = newLiftFloor;
                }
                if (hasButton[0]) {
                    hasButtonOverall[0] = true;
                }
                if (hasButton[1]) {
                    hasButtonOverall[1] = true;
                }
            }
        });
        if (liftInstructionsToUse[0] != null) {
            boolean newMovingUp = topHalfClicked ? hasButtonOverall[0] : !hasButtonOverall[1];
            liftInstructionsToUse[0].addInstruction(liftFloorToUse[0], liftMovingUpToUse[0], newLiftFloorToUse[0], newMovingUp, false, true);
        }
    }

    public static String getStringPart(int floor, boolean movingUp) {
        return "floor_" + floor + "_" + movingUp;
    }

    private static class LiftInstruction {
        private final int floor;
        private final boolean movingUp;

        private LiftInstruction(int floor, boolean movingUp) {
            this.floor = floor;
            this.movingUp = movingUp;
        }

        private boolean canInsert(LiftInstruction previousInstruction, int newFloor, boolean newMovingUp) {
            if (RailwayData.isBetween(newFloor, previousInstruction.floor, this.floor) && newMovingUp == this.movingUp) {
                return true;
            }
            return previousInstruction.movingUp != this.movingUp && previousInstruction.movingUp == newFloor > previousInstruction.floor;
        }

        public boolean equals(Object object) {
            return object instanceof LiftInstruction && this.floor == ((LiftInstruction)object).floor && this.movingUp == ((LiftInstruction)object).movingUp;
        }
    }
}

