/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mtr.mappings.Text;

public interface IGui {
    public static final int SQUARE_SIZE = 20;
    public static final int PANEL_WIDTH = 144;
    public static final int TEXT_HEIGHT = 8;
    public static final int TEXT_PADDING = 6;
    public static final int TEXT_FIELD_PADDING = 4;
    public static final int LINE_HEIGHT = 10;
    public static final float SMALL_OFFSET_16 = 0.05f;
    public static final float SMALL_OFFSET = 0.003125f;
    public static final int RGB_WHITE = 0xFFFFFF;
    public static final int ARGB_WHITE = -1;
    public static final int ARGB_BLACK = -16777216;
    public static final int ARGB_WHITE_TRANSLUCENT = Integer.MAX_VALUE;
    public static final int ARGB_BLACK_TRANSLUCENT = 0x7F000000;
    public static final int ARGB_LIGHT_GRAY = -5592406;
    public static final int ARGB_GRAY = -10066330;
    public static final int ARGB_BACKGROUND = -15592942;
    public static final int MAX_LIGHT_INTERIOR = 0xF000B0;
    public static final int MAX_LIGHT_GLOWING = 0xF000F0;

    public static String formatStationName(String name) {
        return name.replace('|', ' ');
    }

    public static String textOrUntitled(String text) {
        return text.isEmpty() ? Text.translatable("gui.mtr.untitled", new Object[0]).getString() : text;
    }

    public static String formatVerticalChinese(String text) {
        StringBuilder textBuilder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            boolean isCjk = IGui.isCjk(text.substring(i, i + 1));
            if (isCjk) {
                textBuilder.append('|');
            }
            textBuilder.append(text, i, i + 1);
            if (!isCjk) continue;
            textBuilder.append('|');
        }
        String newText = textBuilder.toString();
        while (newText.contains("||")) {
            newText = newText.replace("||", "|");
        }
        if (newText.startsWith("|")) {
            newText = newText.substring(1);
        }
        if (newText.endsWith("|")) {
            newText = newText.substring(0, newText.length() - 1);
        }
        return newText;
    }

    public static String insertTranslation(String keyCJK, String key, int expectedArguments, String ... arguments) {
        return IGui.insertTranslation(keyCJK, key, null, expectedArguments, arguments);
    }

    public static String insertTranslation(String keyCJK, String key, String overrideFirst, int expectedArguments, String ... arguments) {
        if (arguments.length < expectedArguments) {
            return "";
        }
        ArrayList<String[]> dataCJK = new ArrayList<String[]>();
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (int i = 0; i < arguments.length; ++i) {
            String[] argumentSplit = arguments[i].split("\\|");
            int indexCJK = 0;
            int index = 0;
            for (String text : argumentSplit) {
                if (IGui.isCjk(text)) {
                    if (indexCJK == dataCJK.size()) {
                        dataCJK.add(new String[expectedArguments]);
                    }
                    ((String[])dataCJK.get((int)indexCJK))[i] = text;
                    ++indexCJK;
                    continue;
                }
                if (index == data.size()) {
                    data.add(new String[expectedArguments]);
                }
                ((String[])data.get((int)index))[i] = text;
                ++index;
            }
        }
        StringBuilder result = new StringBuilder();
        dataCJK.forEach(combinedArguments -> {
            if (Arrays.stream(combinedArguments).allMatch(Objects::nonNull)) {
                result.append("|");
                if (overrideFirst == null) {
                    result.append(Text.translatable(keyCJK, combinedArguments).getString());
                } else {
                    String[] newCombinedArguments = new String[expectedArguments + 1];
                    System.arraycopy(combinedArguments, 0, newCombinedArguments, 1, expectedArguments);
                    newCombinedArguments[0] = overrideFirst;
                    result.append(Text.translatable(keyCJK, newCombinedArguments).getString());
                }
            }
        });
        data.forEach(combinedArguments -> {
            if (Arrays.stream(combinedArguments).allMatch(Objects::nonNull)) {
                result.append("|");
                if (overrideFirst == null) {
                    result.append(Text.translatable(key, combinedArguments).getString());
                } else {
                    String[] newCombinedArguments = new String[expectedArguments + 1];
                    System.arraycopy(combinedArguments, 0, newCombinedArguments, 1, expectedArguments);
                    newCombinedArguments[0] = overrideFirst;
                    result.append(Text.translatable(key, newCombinedArguments).getString());
                }
            }
        });
        if (result.length() > 0) {
            return result.substring(1);
        }
        return "";
    }

    public static String mergeStations(List<String> stations) {
        return IGui.mergeStations(stations, null);
    }

    public static String mergeStations(List<String> stations, String separator) {
        ArrayList<1> combinedCJK = new ArrayList<1>();
        ArrayList<2> combined = new ArrayList<2>();
        for (String station : stations) {
            int index;
            int i;
            String[] stationSplit = station.split("\\|");
            final ArrayList<String> currentStationCJK = new ArrayList<String>();
            final ArrayList<String> currentStation = new ArrayList<String>();
            for (String stationSplitPart : stationSplit) {
                if (IGui.isCjk(stationSplitPart)) {
                    currentStationCJK.add(stationSplitPart);
                    continue;
                }
                currentStation.add(stationSplitPart);
            }
            for (i = 0; i < currentStationCJK.size(); ++i) {
                if (i < combinedCJK.size()) {
                    if (((List)combinedCJK.get(i)).contains(currentStationCJK.get(i))) continue;
                    ((List)combinedCJK.get(i)).add((String)currentStationCJK.get(i));
                    continue;
                }
                index = i;
                combinedCJK.add(new ArrayList<String>(){
                    {
                        this.add((String)currentStationCJK.get(index));
                    }
                });
            }
            for (i = 0; i < currentStation.size(); ++i) {
                if (i < combined.size()) {
                    if (((List)combined.get(i)).contains(currentStation.get(i))) continue;
                    ((List)combined.get(i)).add((String)currentStation.get(i));
                    continue;
                }
                index = i;
                combined.add(new ArrayList<String>(){
                    {
                        this.add((String)currentStation.get(index));
                    }
                });
            }
        }
        List flattened = combinedCJK.stream().map(subList -> subList.stream().reduce((a, b) -> a + (separator == null ? Text.translatable("gui.mtr.separator_cjk", new Object[0]).getString() : separator) + b).orElse("")).collect(Collectors.toList());
        flattened.addAll(combined.stream().map(subList -> subList.stream().reduce((a, b) -> a + (separator == null ? Text.translatable("gui.mtr.separator", new Object[0]).getString() : separator) + b).orElse("")).collect(Collectors.toList()));
        return flattened.stream().reduce((a, b) -> a + "|" + b).orElse("");
    }

    public static boolean isCjk(String text) {
        return text.codePoints().anyMatch(codePoint -> {
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(codePoint);
            return Character.isIdeographic(codePoint) || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.CJK_STROKES || unicodeBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D || unicodeBlock == Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS || unicodeBlock == Character.UnicodeBlock.BOPOMOFO || unicodeBlock == Character.UnicodeBlock.BOPOMOFO_EXTENDED || unicodeBlock == Character.UnicodeBlock.HIRAGANA || unicodeBlock == Character.UnicodeBlock.KATAKANA || unicodeBlock == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS || unicodeBlock == Character.UnicodeBlock.KANA_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.KANBUN || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO_EXTENDED_A || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO_EXTENDED_B || unicodeBlock == Character.UnicodeBlock.HANGUL_SYLLABLES || unicodeBlock == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || unicodeBlock == Character.UnicodeBlock.KANGXI_RADICALS || unicodeBlock == Character.UnicodeBlock.TAI_XUAN_JING_SYMBOLS || unicodeBlock == Character.UnicodeBlock.IDEOGRAPHIC_DESCRIPTION_CHARACTERS;
        });
    }

    public static enum VerticalAlignment {
        TOP,
        CENTER,
        BOTTOM;


        public float getOffset(float y, float height) {
            switch (this) {
                case CENTER: {
                    return y - height / 2.0f;
                }
                case BOTTOM: {
                    return y - height;
                }
            }
            return y;
        }
    }

    public static enum HorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT;


        public float getOffset(float x, float width) {
            switch (this) {
                case CENTER: {
                    return x - width / 2.0f;
                }
                case RIGHT: {
                    return x - width;
                }
            }
            return x;
        }
    }
}

