/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mtr.client.RouteMapGenerator;
import mtr.data.AreaBase;
import mtr.data.DataCache;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.Platform;
import mtr.data.Route;
import mtr.data.SavedRailBase;
import mtr.data.Siding;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.mappings.Utilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class ClientCache
extends DataCache
implements IGui {
    private Font font;
    private Font fontCjk;
    public final Map<Long, Map<Integer, ColorNameTuple>> stationIdToRoutes = new HashMap<Long, Map<Integer, ColorNameTuple>>();
    private final Map<TransportMode, Map<BlockPos, List<Platform>>> posToPlatforms = new HashMap<TransportMode, Map<BlockPos, List<Platform>>>();
    private final Map<TransportMode, Map<BlockPos, List<Siding>>> posToSidings = new HashMap<TransportMode, Map<BlockPos, List<Siding>>>();
    private final Map<Long, Map<Long, Platform>> stationIdToPlatforms = new HashMap<Long, Map<Long, Platform>>();
    private final Map<Long, Map<Long, Siding>> depotIdToSidings = new HashMap<Long, Map<Long, Siding>>();
    private final Map<Long, List<PlatformRouteDetails>> platformIdToRoutes = new HashMap<Long, List<PlatformRouteDetails>>();
    private final List<Long> clearStationIdToPlatforms = new ArrayList<Long>();
    private final List<Long> clearDepotIdToSidings = new ArrayList<Long>();
    private final List<Long> clearPlatformIdToRoutes = new ArrayList<Long>();
    private final Map<String, DynamicResource> dynamicResources = new HashMap<String, DynamicResource>();
    private final Set<String> removedResources = new HashSet<String>();
    private boolean canGenerateResource = true;
    public static final float LINE_HEIGHT_MULTIPLIER = 1.25f;
    private static final ResourceLocation DEFAULT_BLACK_RESOURCE = new ResourceLocation("mtr", "textures/block/black.png");
    private static final ResourceLocation DEFAULT_WHITE_RESOURCE = new ResourceLocation("mtr", "textures/block/white.png");
    private static final ResourceLocation DEFAULT_TRANSPARENT_RESOURCE = new ResourceLocation("mtr", "textures/block/transparent.png");

    public ClientCache(Set<Station> stations, Set<Platform> platforms, Set<Siding> sidings, Set<Route> routes, Set<Depot> depots) {
        super(stations, platforms, sidings, routes, depots);
        for (TransportMode transportMode : TransportMode.values()) {
            this.posToPlatforms.put(transportMode, new HashMap());
            this.posToSidings.put(transportMode, new HashMap());
        }
    }

    @Override
    protected void syncAdditional() {
        for (TransportMode transportMode : TransportMode.values()) {
            ClientCache.mapPosToSavedRails(this.posToPlatforms.get((Object)transportMode), this.platforms, transportMode);
            ClientCache.mapPosToSavedRails(this.posToSidings.get((Object)transportMode), this.sidings, transportMode);
        }
        this.stationIdToRoutes.clear();
        this.routes.forEach(route -> {
            if (!route.isHidden) {
                route.platformIds.forEach(platformId -> {
                    Station station = (Station)this.platformIdToStation.get(platformId);
                    if (station != null) {
                        if (!this.stationIdToRoutes.containsKey(station.id)) {
                            this.stationIdToRoutes.put(station.id, new HashMap());
                        }
                        this.stationIdToRoutes.get(station.id).put(route.color, new ColorNameTuple(route.color, route.name.split("\\|\\|")[0]));
                    }
                });
            }
        });
        this.stationIdToPlatforms.keySet().forEach(id -> {
            if (!this.clearStationIdToPlatforms.contains(id)) {
                this.clearStationIdToPlatforms.add((Long)id);
            }
        });
        this.depotIdToSidings.keySet().forEach(id -> {
            if (!this.clearDepotIdToSidings.contains(id)) {
                this.clearDepotIdToSidings.add((Long)id);
            }
        });
        this.platformIdToRoutes.keySet().forEach(id -> {
            if (!this.clearPlatformIdToRoutes.contains(id)) {
                this.clearPlatformIdToRoutes.add((Long)id);
            }
        });
        this.removedResources.addAll(this.dynamicResources.keySet());
    }

    public Map<Long, Platform> requestStationIdToPlatforms(long stationId) {
        if (!this.stationIdToPlatforms.containsKey(stationId)) {
            Station station = (Station)this.stationIdMap.get(stationId);
            if (station != null) {
                this.stationIdToPlatforms.put(stationId, ClientCache.areaIdToSavedRails(station, this.platforms));
            } else {
                this.stationIdToPlatforms.put(stationId, new HashMap());
            }
        }
        return this.stationIdToPlatforms.get(stationId);
    }

    public Map<Long, Siding> requestDepotIdToSidings(long depotId) {
        if (!this.depotIdToSidings.containsKey(depotId)) {
            Depot depot = (Depot)this.depotIdMap.get(depotId);
            if (depot != null) {
                this.depotIdToSidings.put(depotId, ClientCache.areaIdToSavedRails(depot, this.sidings));
            } else {
                this.depotIdToSidings.put(depotId, new HashMap());
            }
        }
        return this.depotIdToSidings.get(depotId);
    }

    public List<PlatformRouteDetails> requestPlatformIdToRoutes(long platformId) {
        if (!this.platformIdToRoutes.containsKey(platformId)) {
            this.platformIdToRoutes.put(platformId, this.routes.stream().filter(route -> route.platformIds.contains(platformId)).map(route -> {
                List<PlatformRouteDetails.StationDetails> stationDetails = route.platformIds.stream().map(platformId2 -> {
                    Station station = (Station)this.platformIdToStation.get(platformId2);
                    if (station == null || !this.stationIdToRoutes.containsKey(station.id)) {
                        return new PlatformRouteDetails.StationDetails("", new ArrayList<ColorNameTuple>());
                    }
                    return new PlatformRouteDetails.StationDetails(station.name, this.stationIdToRoutes.get(station.id).values().stream().filter(colorNameTuple -> colorNameTuple.color != route.color).collect(Collectors.toList()));
                }).collect(Collectors.toList());
                return new PlatformRouteDetails(route.name.split("\\|\\|")[0], route.color, route.circularState, route.platformIds.indexOf(platformId), stationDetails);
            }).collect(Collectors.toList()));
        }
        return this.platformIdToRoutes.get(platformId);
    }

    public String getFormattedRouteDestination(Route route, int currentStationIndex, String circularMarker) {
        try {
            if (route.circularState == Route.CircularState.NONE) {
                return ((Station)this.platformIdToStation.get((Object)route.platformIds.get((int)(route.platformIds.size() - 1)))).name;
            }
            boolean isVia = false;
            String text = "";
            for (int i = currentStationIndex + 1; i < route.platformIds.size() - 1; ++i) {
                if (this.stationIdToRoutes.get(((Station)this.platformIdToStation.get((Object)route.platformIds.get((int)i))).id).size() <= 1) continue;
                text = ((Station)this.platformIdToStation.get((Object)route.platformIds.get((int)i))).name;
                isVia = true;
                break;
            }
            if (!isVia) {
                text = ((Station)this.platformIdToStation.get((Object)route.platformIds.get((int)(route.platformIds.size() - 1)))).name;
            }
            String translationString = String.format("%s_%s", route.circularState == Route.CircularState.CLOCKWISE ? "clockwise" : "anticlockwise", isVia ? "via" : "to");
            return circularMarker + IGui.insertTranslation("gui.mtr." + translationString + "_cjk", "gui.mtr." + translationString, 1, text);
        }
        catch (Exception ignored) {
            return "";
        }
    }

    public DynamicResource getColorStrip(long platformId) {
        return this.getResource(String.format("color_%s", platformId), () -> RouteMapGenerator.generateColorStrip(platformId), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getStationName(String stationName, float aspectRatio) {
        return this.getResource(String.format("name_%s_%s", stationName, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateStationName(stationName, aspectRatio), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getTallStationName(int textColor, String stationName, int stationColor, float aspectRatio) {
        return this.getResource(String.format("name_%s_%s_%s_%s", textColor, stationName, stationColor, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateTallStationName(textColor, stationName, stationColor, aspectRatio), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getSingleRowStationName(long platformId, float aspectRatio) {
        return this.getResource(String.format("name_%s_%s", platformId, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateSingleRowStationName(platformId, aspectRatio), DefaultRenderingColor.WHITE);
    }

    public DynamicResource getSignText(String text, IGui.HorizontalAlignment horizontalAlignment, float paddingScale, int backgroundColor, int textColor) {
        return this.getResource(String.format("route_%s_%s_%s_%s_%s", new Object[]{text, horizontalAlignment, Float.valueOf(paddingScale), backgroundColor, textColor}), () -> RouteMapGenerator.generateSignText(text, horizontalAlignment, paddingScale, backgroundColor, textColor), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getRouteSquare(int color, String routeName, IGui.HorizontalAlignment horizontalAlignment) {
        return this.getResource(String.format("route_%s_%s_%s", new Object[]{color, routeName, horizontalAlignment}), () -> RouteMapGenerator.generateRouteSquare(color, routeName, horizontalAlignment), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getDirectionArrow(long platformId, boolean hasLeft, boolean hasRight, IGui.HorizontalAlignment horizontalAlignment, boolean showToString, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        return this.getResource(String.format("map_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s", new Object[]{platformId, hasLeft, hasRight, horizontalAlignment, showToString, Float.valueOf(paddingScale), Float.valueOf(aspectRatio), backgroundColor, textColor, transparentColor}), () -> RouteMapGenerator.generateDirectionArrow(platformId, hasLeft, hasRight, horizontalAlignment, showToString, paddingScale, aspectRatio, backgroundColor, textColor, transparentColor), transparentColor == 0 && backgroundColor == -1 ? DefaultRenderingColor.WHITE : DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getRouteMap(long platformId, boolean vertical, boolean flip, float aspectRatio, boolean transparentWhite) {
        return this.getResource(String.format("map_%s_%s_%s_%s_%s", platformId, vertical, flip, Float.valueOf(aspectRatio), transparentWhite), () -> RouteMapGenerator.generateRouteMap(platformId, vertical, flip, aspectRatio, transparentWhite), transparentWhite ? DefaultRenderingColor.TRANSPARENT : DefaultRenderingColor.WHITE);
    }

    public byte[] getTextPixels(String text, int[] dimensions, int fontSizeCjk, int fontSize) {
        return this.getTextPixels(text, dimensions, Integer.MAX_VALUE, (int)((float)Math.max(fontSizeCjk, fontSize) * 1.25f), fontSizeCjk, fontSize, 0, null);
    }

    public byte[] getTextPixels(String text, int[] dimensions, int maxWidth, int maxHeight, int fontSizeCjk, int fontSize, int padding, IGui.HorizontalAlignment horizontalAlignment) {
        if (maxWidth <= 0) {
            dimensions[0] = 0;
            dimensions[1] = 0;
            return new byte[0];
        }
        boolean oneRow = horizontalAlignment == null;
        String[] textSplit = IGui.textOrUntitled(text).split("\\|");
        AttributedString[] attributedStrings = new AttributedString[textSplit.length];
        int[] textWidths = new int[textSplit.length];
        int[] fontSizes = new int[textSplit.length];
        FontRenderContext context = new FontRenderContext(new AffineTransform(), false, false);
        int width = 0;
        int height = 0;
        for (int index = 0; index < textSplit.length; ++index) {
            boolean useCjkFont = textSplit[index].codePoints().anyMatch(character -> !this.font.canDisplay(character));
            boolean isCjk = IGui.isCjk(textSplit[index]);
            Font mainFont = this.font.deriveFont(0, isCjk ? (float)fontSizeCjk : (float)fontSize);
            Font fallbackFont = useCjkFont ? this.fontCjk.deriveFont(0, isCjk ? (float)fontSizeCjk : (float)fontSize) : mainFont;
            attributedStrings[index] = new AttributedString(textSplit[index]);
            if (textSplit[index].length() > 0) {
                attributedStrings[index].addAttribute(TextAttribute.FONT, mainFont, 0, textSplit[index].length());
            }
            fontSizes[index] = isCjk ? fontSizeCjk : fontSize;
            for (int characterIndex = 0; characterIndex < textSplit[index].length(); ++characterIndex) {
                boolean useFallback = !mainFont.canDisplay(textSplit[index].charAt(characterIndex));
                int n = index;
                textWidths[n] = textWidths[n] + (useFallback ? fallbackFont : mainFont).getStringBounds((String)textSplit[index].substring((int)characterIndex, (int)(characterIndex + 1)), (FontRenderContext)context).getBounds().width;
                attributedStrings[index].addAttribute(TextAttribute.FONT, useFallback ? fallbackFont : mainFont, characterIndex, characterIndex + 1);
            }
            if (oneRow) {
                if (index > 0) {
                    width += padding;
                }
                width += textWidths[index];
                height = Math.max(height, (int)((float)fontSizes[index] * 1.25f));
                continue;
            }
            width = Math.max(width, Math.min(maxWidth, textWidths[index]));
            height = (int)((float)height + (float)fontSizes[index] * 1.25f);
        }
        int textOffset = 0;
        int imageHeight = Math.min(height, maxHeight);
        BufferedImage image = new BufferedImage(width + (oneRow ? 0 : padding * 2), imageHeight + (oneRow ? 0 : padding * 2), 10);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        for (int index = 0; index < textSplit.length; ++index) {
            if (oneRow) {
                graphics2D.drawString(attributedStrings[index].getIterator(), (float)textOffset, (float)height / 1.25f);
                textOffset += textWidths[index] + padding;
                continue;
            }
            float scaleY = (float)imageHeight / (float)height;
            float textWidth = Math.min((float)maxWidth, (float)textWidths[index] * scaleY);
            float scaleX = textWidth / (float)textWidths[index];
            AffineTransform stretch = new AffineTransform();
            stretch.concatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
            graphics2D.setTransform(stretch);
            graphics2D.drawString(attributedStrings[index].getIterator(), horizontalAlignment.getOffset(0.0f, textWidth - (float)width) / scaleY + (float)padding / scaleX, (float)(textOffset + fontSizes[index]) + (float)padding / scaleY);
            textOffset = (int)((float)textOffset + (float)fontSizes[index] * 1.25f);
        }
        dimensions[0] = width + (oneRow ? 0 : padding * 2);
        dimensions[1] = imageHeight + (oneRow ? 0 : padding * 2);
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        graphics2D.dispose();
        image.flush();
        return pixels;
    }

    public void clearDataIfNeeded() {
        if (!this.clearStationIdToPlatforms.isEmpty()) {
            this.stationIdToPlatforms.remove(this.clearStationIdToPlatforms.remove(0));
        }
        if (!this.clearDepotIdToSidings.isEmpty()) {
            this.depotIdToSidings.remove(this.clearDepotIdToSidings.remove(0));
        }
        if (!this.clearPlatformIdToRoutes.isEmpty()) {
            this.platformIdToRoutes.remove(this.clearPlatformIdToRoutes.remove(0));
        }
    }

    public Map<BlockPos, List<Platform>> getPosToPlatforms(TransportMode transportMode) {
        return this.posToPlatforms.get((Object)transportMode);
    }

    public Map<BlockPos, List<Siding>> getPosToSidings(TransportMode transportMode) {
        return this.posToSidings.get((Object)transportMode);
    }

    private DynamicResource getResource(String key, Supplier<DynamicTexture> supplier, DefaultRenderingColor defaultRenderingColor) {
        Minecraft minecraftClient = Minecraft.m_91087_();
        if (this.font == null || this.fontCjk == null) {
            ResourceManager resourceManager = minecraftClient.m_91098_();
            try {
                this.font = Font.createFont(0, Utilities.getInputStream(resourceManager.m_142591_(new ResourceLocation("mtr", "font/noto-sans-semibold.ttf"))));
                this.fontCjk = Font.createFont(0, Utilities.getInputStream(resourceManager.m_142591_(new ResourceLocation("mtr", "font/noto-serif-cjk-tc-semibold.ttf"))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        HashSet keysToRemove = new HashSet();
        this.dynamicResources.forEach((checkKey, dynamicResource) -> {
            if (dynamicResource.removeIfOld()) {
                keysToRemove.add(checkKey);
            }
        });
        if (!keysToRemove.isEmpty()) {
            keysToRemove.forEach(this.dynamicResources::remove);
        }
        if (this.dynamicResources.containsKey(key) && !this.removedResources.contains(key)) {
            DynamicResource dynamicResource2 = this.dynamicResources.get(key);
            dynamicResource2.age = 0;
            return dynamicResource2;
        }
        ResourceLocation defaultLocation = defaultRenderingColor.resourceLocation;
        if (this.canGenerateResource) {
            this.canGenerateResource = false;
            RouteMapGenerator.setConstants();
            new Thread(() -> {
                DynamicTexture dynamicTexture = (DynamicTexture)supplier.get();
                minecraftClient.execute(() -> {
                    if (this.removedResources.contains(key) && this.dynamicResources.containsKey(key)) {
                        this.dynamicResources.get(key).remove();
                    }
                    this.dynamicResources.put(key, new DynamicResource(dynamicTexture == null ? defaultLocation : minecraftClient.m_91097_().m_118490_("mtr", dynamicTexture), dynamicTexture));
                    this.removedResources.remove(key);
                    this.canGenerateResource = true;
                });
            }).start();
        }
        if (this.dynamicResources.containsKey(key)) {
            DynamicResource dynamicResource3 = this.dynamicResources.get(key);
            dynamicResource3.age = 0;
            return dynamicResource3;
        }
        return new DynamicResource(defaultLocation, null);
    }

    private static <U extends AreaBase, V extends SavedRailBase> Map<Long, V> areaIdToSavedRails(U area, Set<V> savedRails) {
        HashMap savedRailMap = new HashMap();
        savedRails.forEach(savedRail -> {
            BlockPos pos = savedRail.getMidPos();
            if (area.isTransportMode(savedRail.transportMode) && area.inArea(pos.m_123341_(), pos.m_123343_())) {
                savedRailMap.put(savedRail.id, savedRail);
            }
        });
        return savedRailMap;
    }

    private static <U extends SavedRailBase> void mapPosToSavedRails(Map<BlockPos, List<U>> posToSavedRails, Set<U> savedRails, TransportMode transportMode) {
        posToSavedRails.clear();
        savedRails.forEach(savedRail -> {
            if (savedRail.isTransportMode(transportMode)) {
                BlockPos pos = savedRail.getMidPos(true);
                if (!posToSavedRails.containsKey(pos)) {
                    posToSavedRails.put(pos, new ArrayList());
                }
                ((List)posToSavedRails.get(pos)).add(savedRail);
            }
        });
    }

    private static enum DefaultRenderingColor {
        BLACK(DEFAULT_BLACK_RESOURCE),
        WHITE(DEFAULT_WHITE_RESOURCE),
        TRANSPARENT(DEFAULT_TRANSPARENT_RESOURCE);

        private final ResourceLocation resourceLocation;

        private DefaultRenderingColor(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }
    }

    public static class DynamicResource {
        private int age = 0;
        public final int width;
        public final int height;
        public final ResourceLocation resourceLocation;
        private static final int MAX_AGE = 10000;

        private DynamicResource(ResourceLocation resourceLocation, DynamicTexture dynamicTexture) {
            this.resourceLocation = resourceLocation;
            if (dynamicTexture != null) {
                NativeImage nativeImage = dynamicTexture.m_117991_();
                if (nativeImage != null) {
                    this.width = nativeImage.m_84982_();
                    this.height = nativeImage.m_85084_();
                } else {
                    this.width = 16;
                    this.height = 16;
                }
            } else {
                this.width = 16;
                this.height = 16;
            }
        }

        private void remove() {
            if (!(this.resourceLocation.equals((Object)DEFAULT_BLACK_RESOURCE) || this.resourceLocation.equals((Object)DEFAULT_WHITE_RESOURCE) || this.resourceLocation.equals((Object)DEFAULT_TRANSPARENT_RESOURCE))) {
                TextureManager textureManager = Minecraft.m_91087_().m_91097_();
                textureManager.m_118513_(this.resourceLocation);
                AbstractTexture abstractTexture = textureManager.m_118506_(this.resourceLocation);
                if (abstractTexture != null) {
                    abstractTexture.m_117964_();
                    abstractTexture.close();
                }
            }
        }

        private boolean removeIfOld() {
            ++this.age;
            if (this.age >= 10000) {
                this.remove();
                return true;
            }
            return false;
        }
    }

    public static class PlatformRouteDetails {
        public final String routeName;
        public final int routeColor;
        public final Route.CircularState circularState;
        public final int currentStationIndex;
        public final List<StationDetails> stationDetails;

        public PlatformRouteDetails(String routeName, int routeColor, Route.CircularState circularState, int currentStationIndex, List<StationDetails> stationDetails) {
            this.routeName = routeName;
            this.routeColor = routeColor;
            this.circularState = circularState;
            this.currentStationIndex = currentStationIndex;
            this.stationDetails = stationDetails;
        }

        public static class StationDetails {
            public final String stationName;
            public final List<ColorNameTuple> interchangeRoutes;

            public StationDetails(String stationName, List<ColorNameTuple> interchangeRoutes) {
                this.stationName = stationName;
                this.interchangeRoutes = interchangeRoutes;
            }
        }
    }

    public static class ColorNameTuple {
        public final int color;
        public final String name;

        public ColorNameTuple(int color, String name) {
            this.color = color;
            this.name = name;
        }
    }
}

