/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BlockStationNameTallBase
extends BlockStationNameBase
implements IBlock {
    public static final BooleanProperty METAL = BooleanProperty.m_61465_((String)"metal");

    public BlockStationNameTallBase() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60978_(2.0f).m_60955_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            boolean isWhite = (Integer)IBlock.getStatePropertySafe(state, COLOR) == 0;
            int newColorProperty = isWhite ? 2 : 0;
            boolean newMetalProperty = isWhite == (Boolean)IBlock.getStatePropertySafe(state, METAL);
            BlockStationNameTallBase.updateProperties(world, pos, newMetalProperty, newColorProperty);
            switch ((IBlock.EnumThird)((Object)((Object)IBlock.getStatePropertySafe(state, THIRD)))) {
                case LOWER: {
                    BlockStationNameTallBase.updateProperties(world, pos.m_7494_(), newMetalProperty, newColorProperty);
                    BlockStationNameTallBase.updateProperties(world, pos.m_6630_(2), newMetalProperty, newColorProperty);
                    break;
                }
                case MIDDLE: {
                    BlockStationNameTallBase.updateProperties(world, pos.m_7495_(), newMetalProperty, newColorProperty);
                    BlockStationNameTallBase.updateProperties(world, pos.m_7494_(), newMetalProperty, newColorProperty);
                    break;
                }
                case UPPER: {
                    BlockStationNameTallBase.updateProperties(world, pos.m_7495_(), newMetalProperty, newColorProperty);
                    BlockStationNameTallBase.updateProperties(world, pos.m_6625_(2), newMetalProperty, newColorProperty);
                }
            }
        });
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        if ((direction == Direction.UP && IBlock.getStatePropertySafe(state, THIRD) != IBlock.EnumThird.UPPER || direction == Direction.DOWN && IBlock.getStatePropertySafe(state, THIRD) != IBlock.EnumThird.LOWER) && !newState.m_60713_((Block)this)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        switch ((IBlock.EnumThird)((Object)IBlock.getStatePropertySafe(state, THIRD))) {
            case MIDDLE: {
                IBlock.onBreakCreative(world, player, pos.m_7495_());
                break;
            }
            case UPPER: {
                IBlock.onBreakCreative(world, player, pos.m_6625_(2));
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.f_46443_) {
            Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
            world.m_7731_(pos.m_7494_(), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_((Property)METAL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)THIRD, (Comparable)((Object)IBlock.EnumThird.MIDDLE)), 3);
            world.m_7731_(pos.m_6630_(2), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_((Property)METAL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)THIRD, (Comparable)((Object)IBlock.EnumThird.UPPER)), 3);
            world.m_46672_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)world, pos, 3);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{COLOR, f_54117_, METAL, THIRD});
    }

    protected static Tuple<Integer, Integer> getBounds(BlockState state) {
        int start;
        IBlock.EnumThird third = (IBlock.EnumThird)((Object)IBlock.getStatePropertySafe(state, THIRD));
        return new Tuple((Object)start, (Object)(switch (third) {
            case IBlock.EnumThird.LOWER -> {
                start = 10;
                yield 16;
            }
            case IBlock.EnumThird.UPPER -> {
                start = 0;
                yield 8;
            }
            default -> {
                start = 0;
                yield 16;
            }
        }));
    }

    private static void updateProperties(Level world, BlockPos pos, boolean metalProperty, int colorProperty) {
        world.m_46597_(pos, (BlockState)((BlockState)world.m_8055_(pos).m_61124_((Property)COLOR, (Comparable)Integer.valueOf(colorProperty))).m_61124_((Property)METAL, (Comparable)Boolean.valueOf(metalProperty)));
    }

    public static class TileEntityStationNameTallBase
    extends BlockStationNameBase.TileEntityStationNameBase {
        public TileEntityStationNameTallBase(BlockEntityType<?> type, BlockPos pos, BlockState state, float zOffset, boolean isDoubleSided) {
            super(type, pos, state, 0.21875f, zOffset, isDoubleSided);
        }

        @Override
        public int getColor(BlockState state) {
            switch ((Integer)IBlock.getStatePropertySafe(state, BlockStationNameBase.COLOR)) {
                case 1: {
                    return -5592406;
                }
                case 2: {
                    return -16777216;
                }
            }
            return -1;
        }
    }
}

