/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.BlockEntityTypes;
import mtr.Blocks;
import mtr.Items;
import mtr.block.BlockPSDAPGBase;
import mtr.block.BlockPSDAPGGlassEndBase;
import mtr.block.BlockPSDDoor;
import mtr.block.BlockPSDGlass;
import mtr.block.BlockPSDGlassEnd;
import mtr.block.IBlock;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockPSDTop
extends BlockDirectionalMapper
implements EntityBlockMapper,
IBlock {
    private static final float PERSISTENT_OFFSET = 7.5f;
    public static final float PERSISTENT_OFFSET_SMALL = 0.46875f;
    public static final BooleanProperty AIR_LEFT = BooleanProperty.m_61465_((String)"air_left");
    public static final BooleanProperty AIR_RIGHT = BooleanProperty.m_61465_((String)"air_right");
    public static final IntegerProperty ARROW_DIRECTION = IntegerProperty.m_61631_((String)"propagate_property", (int)0, (int)3);
    public static final EnumProperty<EnumPersistent> PERSISTENT = EnumProperty.m_61587_((String)"persistent", EnumPersistent.class);

    public BlockPSDTop() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76412_).m_60999_().m_60978_(2.0f).m_60955_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return IBlock.checkHoldingItem(world, player, item -> {
            if (item == Items.BRUSH.get()) {
                world.m_46597_(pos, (BlockState)state.m_61122_((Property)ARROW_DIRECTION));
                this.propagate(world, pos, ((Direction)IBlock.getStatePropertySafe(state, f_54117_)).m_122427_(), (Property)ARROW_DIRECTION, 1);
                this.propagate(world, pos, ((Direction)IBlock.getStatePropertySafe(state, f_54117_)).m_122428_(), (Property)ARROW_DIRECTION, 1);
            } else {
                boolean shouldBePersistent = IBlock.getStatePropertySafe(state, PERSISTENT) == EnumPersistent.NONE;
                this.setState(world, pos, shouldBePersistent);
                this.propagate(world, pos, ((Direction)IBlock.getStatePropertySafe(state, f_54117_)).m_122427_(), offsetPos -> this.setState(world, (BlockPos)offsetPos, shouldBePersistent), 1);
                this.propagate(world, pos, ((Direction)IBlock.getStatePropertySafe(state, f_54117_)).m_122428_(), offsetPos -> this.setState(world, (BlockPos)offsetPos, shouldBePersistent), 1);
            }
        }, null, Items.BRUSH.get(), net.minecraft.world.item.Items.f_42574_);
    }

    private void setState(Level world, BlockPos pos, boolean shouldBePersistent) {
        Block blockBelow = world.m_8055_(pos.m_7495_()).m_60734_();
        if (blockBelow instanceof BlockPSDDoor || blockBelow instanceof BlockPSDGlass || blockBelow instanceof BlockPSDGlassEnd) {
            if (shouldBePersistent) {
                world.m_46597_(pos, (BlockState)world.m_8055_(pos).m_61124_(PERSISTENT, (Comparable)((Object)(blockBelow instanceof BlockPSDDoor ? EnumPersistent.ARROW : (blockBelow instanceof BlockPSDGlass ? EnumPersistent.ROUTE : EnumPersistent.BLANK)))));
            } else {
                world.m_46597_(pos, (BlockState)world.m_8055_(pos).m_61124_(PERSISTENT, (Comparable)((Object)EnumPersistent.NONE)));
            }
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return state;
    }

    public Item m_5456_() {
        return Items.PSD_GLASS_1.get();
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)this.m_5456_());
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        Block blockDown = world.m_8055_(pos.m_7495_()).m_60734_();
        if (blockDown instanceof BlockPSDAPGBase) {
            blockDown.m_5707_(world, pos.m_7495_(), world.m_8055_(pos.m_7495_()), player);
            world.m_46597_(pos.m_7495_(), net.minecraft.world.level.block.Blocks.f_50016_.m_49966_());
        }
        super.m_5707_(world, pos, state, player);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        if (direction == Direction.DOWN && IBlock.getStatePropertySafe(state, PERSISTENT) == EnumPersistent.NONE && !(newState.m_60734_() instanceof BlockPSDAPGBase)) {
            return net.minecraft.world.level.block.Blocks.f_50016_.m_49966_();
        }
        return BlockPSDTop.getActualState((BlockGetter)world, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        VoxelShape baseShape = IBlock.getVoxelShapeByDirection(0.0, IBlock.getStatePropertySafe(state, PERSISTENT) == EnumPersistent.NONE ? 0.0 : 7.5, 0.0, 16.0, 16.0, 6.0, (Direction)IBlock.getStatePropertySafe(state, f_54117_));
        boolean airLeft = (Boolean)IBlock.getStatePropertySafe(state, AIR_LEFT);
        boolean airRight = (Boolean)IBlock.getStatePropertySafe(state, AIR_RIGHT);
        if (airLeft || airRight) {
            return BlockPSDAPGGlassEndBase.getEndOutlineShape(baseShape, state, 16, 6, airLeft, airRight);
        }
        return baseShape;
    }

    public PushReaction m_5537_(BlockState blockState) {
        return PushReaction.BLOCK;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, SIDE_EXTENDED, AIR_LEFT, AIR_RIGHT, ARROW_DIRECTION, PERSISTENT});
    }

    @Override
    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityPSDTop(pos, state);
    }

    public static BlockState getActualState(BlockGetter world, BlockPos pos) {
        BlockState oldState;
        Direction facing = null;
        IBlock.EnumSide side = null;
        boolean airLeft = false;
        boolean airRight = false;
        BlockState stateBelow = world.m_8055_(pos.m_7495_());
        Block blockBelow = stateBelow.m_60734_();
        if (blockBelow instanceof BlockPSDGlass || blockBelow instanceof BlockPSDDoor || blockBelow instanceof BlockPSDGlassEnd) {
            side = blockBelow instanceof BlockPSDDoor ? (IBlock.EnumSide)((Object)IBlock.getStatePropertySafe(stateBelow, SIDE)) : (IBlock.EnumSide)((Object)IBlock.getStatePropertySafe(stateBelow, SIDE_EXTENDED));
            if (blockBelow instanceof BlockPSDGlassEnd) {
                if (IBlock.getStatePropertySafe(stateBelow, BlockPSDGlassEnd.TOUCHING_LEFT) == BlockPSDAPGGlassEndBase.EnumPSDAPGGlassEndSide.AIR) {
                    airLeft = true;
                }
                if (IBlock.getStatePropertySafe(stateBelow, BlockPSDGlassEnd.TOUCHING_RIGHT) == BlockPSDAPGGlassEndBase.EnumPSDAPGGlassEndSide.AIR) {
                    airRight = true;
                }
            }
            facing = (Direction)IBlock.getStatePropertySafe(stateBelow, f_54117_);
        }
        BlockState newState = (BlockState)((BlockState)((oldState = world.m_8055_(pos)).m_60734_() instanceof BlockPSDTop ? oldState : Blocks.PSD_TOP.get().m_49966_()).m_61124_((Property)AIR_LEFT, (Comparable)Boolean.valueOf(airLeft))).m_61124_((Property)AIR_RIGHT, (Comparable)Boolean.valueOf(airRight));
        if (facing != null) {
            newState = (BlockState)newState.m_61124_((Property)f_54117_, (Comparable)facing);
        }
        if (side != null) {
            newState = (BlockState)newState.m_61124_((Property)SIDE_EXTENDED, (Comparable)((Object)side));
        }
        return newState;
    }

    public static enum EnumPersistent implements StringRepresentable
    {
        NONE("none"),
        ARROW("arrow"),
        ROUTE("route"),
        BLANK("blank");

        private final String name;

        private EnumPersistent(String nameIn) {
            this.name = nameIn;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static class TileEntityPSDTop
    extends BlockEntityMapper {
        public TileEntityPSDTop(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.PSD_TOP_TILE_ENTITY.get(), pos, state);
        }
    }

    public static enum EnumDoorLight implements StringRepresentable
    {
        ON("on"),
        OFF("off"),
        NONE("none");

        private final String name;

        private EnumDoorLight(String nameIn) {
            this.name = nameIn;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

