/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.BlockPSDAPGBase;
import mtr.block.BlockPSDAPGDoorBase;
import mtr.block.BlockPSDAPGGlassBase;
import mtr.block.IBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BlockPSDAPGGlassEndBase
extends BlockPSDAPGGlassBase {
    public static final EnumProperty<EnumPSDAPGGlassEndSide> TOUCHING_LEFT = EnumProperty.m_61587_((String)"touching_left", EnumPSDAPGGlassEndSide.class);
    public static final EnumProperty<EnumPSDAPGGlassEndSide> TOUCHING_RIGHT = EnumProperty.m_61587_((String)"touching_right", EnumPSDAPGGlassEndSide.class);

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        BlockState superState = super.m_7417_(state, direction, newState, world, pos, posFrom);
        if (superState.m_60734_() == Blocks.f_50016_) {
            return superState;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        EnumPSDAPGGlassEndSide touchingLeft = this.getSideEnd(world, pos, facing.m_122428_());
        EnumPSDAPGGlassEndSide touchingRight = this.getSideEnd(world, pos, facing.m_122427_());
        return (BlockState)((BlockState)superState.m_61124_(TOUCHING_LEFT, (Comparable)((Object)touchingLeft))).m_61124_(TOUCHING_RIGHT, (Comparable)((Object)touchingRight));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape superShape = super.m_5940_(state, world, pos, context);
        int height = this.isAPG() && IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER ? 9 : 16;
        boolean leftAir = IBlock.getStatePropertySafe(state, TOUCHING_LEFT) == EnumPSDAPGGlassEndSide.AIR;
        boolean rightAir = IBlock.getStatePropertySafe(state, TOUCHING_RIGHT) == EnumPSDAPGGlassEndSide.AIR;
        return BlockPSDAPGGlassEndBase.getEndOutlineShape(superShape, state, height, 4, leftAir, rightAir);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, HALF, SIDE_EXTENDED, TOUCHING_LEFT, TOUCHING_RIGHT});
    }

    private EnumPSDAPGGlassEndSide getSideEnd(LevelAccessor world, BlockPos pos, Direction offset) {
        BlockPos checkPos = pos.m_142300_(offset);
        if (world.m_8055_(checkPos).m_60734_() instanceof BlockPSDAPGDoorBase) {
            return EnumPSDAPGGlassEndSide.DOOR;
        }
        if (world.m_8055_(checkPos).m_60734_() instanceof BlockPSDAPGBase) {
            return EnumPSDAPGGlassEndSide.NONE;
        }
        return EnumPSDAPGGlassEndSide.AIR;
    }

    public static VoxelShape getEndOutlineShape(VoxelShape baseShape, BlockState state, int height, int thickness, boolean leftAir, boolean rightAir) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        if (facing == Direction.NORTH && leftAir || facing == Direction.SOUTH && rightAir) {
            baseShape = Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)thickness, (double)height, (double)16.0));
        }
        if (facing == Direction.EAST && leftAir || facing == Direction.WEST && rightAir) {
            baseShape = Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)thickness));
        }
        if (facing == Direction.SOUTH && leftAir || facing == Direction.NORTH && rightAir) {
            baseShape = Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)Block.m_49796_((double)(16 - thickness), (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0));
        }
        if (facing == Direction.WEST && leftAir || facing == Direction.EAST && rightAir) {
            baseShape = Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)(16 - thickness), (double)16.0, (double)height, (double)16.0));
        }
        return baseShape;
    }

    public static enum EnumPSDAPGGlassEndSide implements StringRepresentable
    {
        AIR("air"),
        DOOR("door"),
        NONE("none");

        private final String name;

        private EnumPSDAPGGlassEndSide(String nameIn) {
            this.name = nameIn;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

