/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.IBlock;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BlockPIDSBase
extends BlockDirectionalMapper
implements EntityBlockMapper {
    public BlockPIDSBase() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60978_(2.0f).m_60953_(state -> 5));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            BlockPos otherPos = pos.m_142300_((Direction)IBlock.getStatePropertySafe(state, f_54117_));
            BlockEntity entity1 = world.m_7702_(pos);
            BlockEntity entity2 = world.m_7702_(otherPos);
            if (entity1 instanceof TileEntityBlockPIDSBase && entity2 instanceof TileEntityBlockPIDSBase) {
                ((TileEntityBlockPIDSBase)entity1).syncData();
                ((TileEntityBlockPIDSBase)entity2).syncData();
                PacketTrainDataGuiServer.openPIDSConfigScreenS2C((ServerPlayer)player, pos, otherPos, ((TileEntityBlockPIDSBase)entity1).getMaxArrivals());
            }
        });
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        if (IBlock.getStatePropertySafe(state, f_54117_) == direction && !newState.m_60713_((Block)this)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_().m_122424_();
        return IBlock.isReplaceable(ctx, direction, 2) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        if (facing == Direction.SOUTH || facing == Direction.WEST) {
            IBlock.onBreakCreative(world, player, pos.m_142300_(facing));
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.f_46443_) {
            Direction direction = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
            world.m_7731_(pos.m_142300_(direction), (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction.m_122424_()), 3);
            world.m_46672_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)world, pos, 3);
            BlockEntity entity1 = world.m_7702_(pos);
            BlockEntity entity2 = world.m_7702_(pos.m_142300_(direction));
            if (entity1 instanceof TileEntityBlockPIDSBase && entity2 instanceof TileEntityBlockPIDSBase) {
                System.arraycopy(((TileEntityBlockPIDSBase)entity1).messages, 0, ((TileEntityBlockPIDSBase)entity2).messages, 0, Math.min(((TileEntityBlockPIDSBase)entity1).messages.length, ((TileEntityBlockPIDSBase)entity2).messages.length));
            }
        }
    }

    public PushReaction m_5537_(BlockState blockState) {
        return PushReaction.BLOCK;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public static abstract class TileEntityBlockPIDSBase
    extends BlockEntityClientSerializableMapper {
        private final String[] messages = new String[this.getMaxArrivals()];
        private final boolean[] hideArrival = new boolean[this.getMaxArrivals()];
        private static final String KEY_MESSAGE = "message";
        private static final String KEY_HIDE_ARRIVAL = "hide_arrival";

        public TileEntityBlockPIDSBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            for (int i = 0; i < this.getMaxArrivals(); ++i) {
                this.messages[i] = compoundTag.m_128461_(KEY_MESSAGE + i);
                this.hideArrival[i] = compoundTag.m_128471_(KEY_HIDE_ARRIVAL + i);
            }
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            for (int i = 0; i < this.getMaxArrivals(); ++i) {
                compoundTag.m_128359_(KEY_MESSAGE + i, this.messages[i] == null ? "" : this.messages[i]);
                compoundTag.m_128379_(KEY_HIDE_ARRIVAL + i, this.hideArrival[i]);
            }
        }

        public AABB getRenderBoundingBox() {
            return new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }

        public void setData(String[] messages, boolean[] hideArrival) {
            System.arraycopy(messages, 0, this.messages, 0, Math.min(messages.length, this.messages.length));
            System.arraycopy(hideArrival, 0, this.hideArrival, 0, Math.min(hideArrival.length, this.hideArrival.length));
            this.m_6596_();
            this.syncData();
        }

        public String getMessage(int index) {
            if (index >= 0 && index < this.getMaxArrivals()) {
                if (this.messages[index] == null) {
                    this.messages[index] = "";
                }
                return this.messages[index];
            }
            return "";
        }

        public boolean getHideArrival(int index) {
            if (index >= 0 && index < this.getMaxArrivals()) {
                return this.hideArrival[index];
            }
            return false;
        }

        protected abstract int getMaxArrivals();
    }
}

