/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import mtr.data.Platform;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardScreen;
import mtr.screen.SavedRailScreenBase;
import mtr.screen.WidgetShorterSlider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class PlatformScreen
extends SavedRailScreenBase<Platform> {
    private final WidgetShorterSlider sliderDwellTimeSec;
    private final WidgetShorterSlider sliderDwellTimeMin;
    private static final Component DWELL_TIME_TEXT = Text.translatable("gui.mtr.dwell_time", new Object[0]);
    private static final int SECONDS_PER_MINUTE = 60;

    public PlatformScreen(Platform savedRailBase, TransportMode transportMode, DashboardScreen dashboardScreen) {
        super(savedRailBase, transportMode, dashboardScreen, DWELL_TIME_TEXT);
        int textWidth = Math.max(this.f_96547_.m_92852_((FormattedText)Text.translatable("gui.mtr.arrival_min", "88")), this.f_96547_.m_92852_((FormattedText)Text.translatable("gui.mtr.arrival_sec", "88.8")));
        this.sliderDwellTimeMin = new WidgetShorterSlider(0, 240 - textWidth - 6, (int)Math.floor(10.0), value -> Text.translatable("gui.mtr.arrival_min", value).getString(), null);
        this.sliderDwellTimeSec = new WidgetShorterSlider(0, 240 - textWidth - 6, 119, 10, 2, value -> Text.translatable("gui.mtr.arrival_sec", Float.valueOf((float)value.intValue() / 2.0f)).getString(), null);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.sliderDwellTimeMin.f_93620_ = this.startX + this.textWidth;
        this.sliderDwellTimeMin.f_93621_ = this.f_96544_ / 2 + 2;
        this.sliderDwellTimeMin.setHeight(10);
        this.sliderDwellTimeMin.setValue((int)Math.floor((float)((Platform)this.savedRailBase).getDwellTime() / 2.0f / 60.0f));
        this.sliderDwellTimeSec.f_93620_ = this.startX + this.textWidth;
        this.sliderDwellTimeSec.f_93621_ = this.f_96544_ / 2 + 2 + 10;
        this.sliderDwellTimeSec.setHeight(10);
        this.sliderDwellTimeSec.setValue(((Platform)this.savedRailBase).getDwellTime() % 120);
        if (this.showScheduleControls) {
            this.addDrawableChild(this.sliderDwellTimeMin);
            this.addDrawableChild(this.sliderDwellTimeSec);
        }
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6305_(matrices, mouseX, mouseY, delta);
        if (this.showScheduleControls) {
            this.f_96547_.m_92889_(matrices, DWELL_TIME_TEXT, (float)this.startX, (float)this.f_96544_ / 2.0f + 2.0f + 6.0f, -1);
        }
    }

    @Override
    public void m_96624_() {
        int maxMin = (int)Math.floor(10.0);
        if (this.sliderDwellTimeMin.getIntValue() == 0 && this.sliderDwellTimeSec.getIntValue() == 0) {
            this.sliderDwellTimeSec.setValue(1);
        }
        if (this.sliderDwellTimeMin.getIntValue() == maxMin && this.sliderDwellTimeSec.getIntValue() > 0) {
            this.sliderDwellTimeSec.setValue(0);
        }
    }

    @Override
    public void m_7379_() {
        int minutes = this.sliderDwellTimeMin.getIntValue();
        float second = (float)this.sliderDwellTimeSec.getIntValue() / 2.0f;
        ((Platform)this.savedRailBase).setDwellTime((int)((second + (float)(minutes * 60)) * 2.0f), packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_PLATFORM, packet));
        super.m_7379_();
    }

    @Override
    protected String getNumberStringKey() {
        return "gui.mtr.platform_number";
    }

    @Override
    protected ResourceLocation getPacketIdentifier() {
        return PACKET_UPDATE_PLATFORM;
    }
}

