/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import mtr.block.BlockPIDSBase;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PIDSConfigScreen
extends ScreenMapper
implements IGui,
IPacket {
    private final BlockPos pos1;
    private final BlockPos pos2;
    private final String[] messages;
    private final boolean[] hideArrival;
    private final WidgetBetterTextField[] textFieldMessages;
    private final WidgetBetterCheckbox[] buttonsHideArrival;
    private final Component messageText = Text.translatable("gui.mtr.pids_message", new Object[0]);
    private final Component hideArrivalText = Text.translatable("gui.mtr.hide_arrival", new Object[0]);
    private static final int MAX_MESSAGE_LENGTH = 2048;

    public PIDSConfigScreen(BlockPos pos1, BlockPos pos2, int maxArrivals) {
        super((Component)Text.literal(""));
        BlockEntity entity;
        int i;
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.messages = new String[maxArrivals];
        for (i = 0; i < maxArrivals; ++i) {
            this.messages[i] = "";
        }
        this.hideArrival = new boolean[maxArrivals];
        this.textFieldMessages = new WidgetBetterTextField[maxArrivals];
        for (i = 0; i < maxArrivals; ++i) {
            this.textFieldMessages[i] = new WidgetBetterTextField("", 2048);
        }
        this.buttonsHideArrival = new WidgetBetterCheckbox[maxArrivals];
        for (i = 0; i < maxArrivals; ++i) {
            this.buttonsHideArrival[i] = new WidgetBetterCheckbox(0, 0, 0, 20, this.hideArrivalText, checked -> {});
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null && (entity = world.m_7702_(pos1)) instanceof BlockPIDSBase.TileEntityBlockPIDSBase) {
            for (int i2 = 0; i2 < maxArrivals; ++i2) {
                this.messages[i2] = ((BlockPIDSBase.TileEntityBlockPIDSBase)entity).getMessage(i2);
                this.hideArrival[i2] = ((BlockPIDSBase.TileEntityBlockPIDSBase)entity).getHideArrival(i2);
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int textWidth = this.f_96547_.m_92852_((FormattedText)this.hideArrivalText) + 20 + 12;
        for (int i = 0; i < this.textFieldMessages.length; ++i) {
            WidgetBetterTextField textFieldMessage = this.textFieldMessages[i];
            IDrawing.setPositionAndWidth((AbstractWidget)textFieldMessage, 22, 42 + 24 * i, this.f_96543_ - 40 - 4 - textWidth);
            textFieldMessage.m_94144_(this.messages[i]);
            this.addDrawableChild(textFieldMessage);
            WidgetBetterCheckbox buttonHideArrival = this.buttonsHideArrival[i];
            IDrawing.setPositionAndWidth((AbstractWidget)buttonHideArrival, this.f_96543_ - 20 - textWidth + 6, 42 + 24 * i, textWidth);
            buttonHideArrival.setChecked(this.hideArrival[i]);
            this.addDrawableChild(buttonHideArrival);
        }
    }

    public void m_96624_() {
        for (WidgetBetterTextField textFieldMessage : this.textFieldMessages) {
            textFieldMessage.m_94120_();
        }
    }

    public void m_7379_() {
        for (int i = 0; i < this.textFieldMessages.length; ++i) {
            this.messages[i] = this.textFieldMessages[i].m_94155_();
            this.hideArrival[i] = this.buttonsHideArrival[i].m_93840_();
        }
        PacketTrainDataGuiClient.sendPIDSConfigC2S(this.pos1, this.pos2, this.messages, this.hideArrival);
        super.m_7379_();
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.m_7333_(matrices);
            this.f_96547_.m_92889_(matrices, this.messageText, 26.0f, 26.0f, -1);
            super.m_6305_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

