/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mtr.data.DataConverter;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.entity.EntityLift;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardList;
import net.minecraft.network.chat.Component;

public class LiftSelectionScreen
extends ScreenMapper
implements IGui {
    private final DashboardList selectionList;
    private final List<Integer> floorLevels;
    private final List<String> floorDescriptions = new ArrayList<String>();
    private final EntityLift entityLift;

    public LiftSelectionScreen(EntityLift entityLift) {
        super((Component)Text.literal(""));
        this.entityLift = entityLift;
        Map<Object, Object> floors = entityLift == null ? new HashMap() : entityLift.floors;
        this.floorLevels = new ArrayList<Object>(floors.keySet());
        this.floorLevels.sort((a, b) -> b - a);
        this.floorLevels.forEach(floorLevel -> this.floorDescriptions.add(IGui.formatStationName(floors.getOrDefault(floorLevel, ""))));
        this.selectionList = new DashboardList(this::onPress, null, null, null, null, null, null, () -> "", text -> {});
    }

    protected void m_7856_() {
        super.m_7856_();
        this.selectionList.x = this.f_96543_ / 2 - 144;
        this.selectionList.y = 20;
        this.selectionList.width = 288;
        this.selectionList.height = this.f_96544_ - 40;
        this.selectionList.init(this::addDrawableChild);
    }

    public void m_96624_() {
        this.selectionList.tick();
        ArrayList<DataConverter> list = new ArrayList<DataConverter>();
        for (int i = 0; i < this.floorLevels.size(); ++i) {
            list.add(new DataConverter(this.floorDescriptions.get(i), this.hasStoppingFloor(this.floorLevels.get(i)) ? -65536 : -16777216));
        }
        this.selectionList.setData(list, true, false, false, false, false, false);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.m_7333_(matrices);
            this.selectionList.render(matrices, this.f_96547_);
            super.m_6305_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.selectionList.mouseMoved(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.selectionList.mouseScrolled(mouseX, mouseY, amount);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7043_() {
        return false;
    }

    private void onPress(NameColorDataBase data, int index) {
        if (this.entityLift != null) {
            PacketTrainDataGuiClient.sendPressLiftButtonC2S(this.entityLift.m_142081_(), this.floorLevels.get(index));
        }
    }

    private boolean hasStoppingFloor(int floor) {
        if (this.entityLift != null) {
            return this.entityLift.hasStoppingFloorsClient(floor, true) || this.entityLift.hasStoppingFloorsClient(floor, false);
        }
        return false;
    }
}

