/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.Route;
import mtr.data.RouteType;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardScreen;
import mtr.screen.EditNameColorScreenBase;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class EditRouteScreen
extends EditNameColorScreenBase<Route>
implements IGui,
IPacket {
    private RouteType routeType;
    private final Component lightRailRouteNumberText = Text.translatable("gui.mtr.light_rail_route_number", new Object[0]);
    private final WidgetBetterTextField textFieldLightRailRouteNumber = new WidgetBetterTextField("");
    private final Button buttonRouteType = new Button(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.add_value", new Object[0]), button -> this.setRouteTypeText(((Route)this.data).transportMode, this.routeType.next()));
    private final WidgetBetterCheckbox buttonIsLightRailRoute = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.is_light_rail_route", new Object[0]), this::setIsLightRailRoute);
    private final WidgetBetterCheckbox buttonIsRouteHidden = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.is_route_hidden", new Object[0]), this::setIsRouteHidden);
    private final WidgetBetterCheckbox buttonIsClockwiseRoute = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.is_clockwise_route", new Object[0]), this::setIsClockwise);
    private final WidgetBetterCheckbox buttonIsAntiClockwiseRoute = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.is_anticlockwise_route", new Object[0]), this::setIsAntiClockwise);
    private final boolean isCircular;
    private static final int CHECKBOX_WIDTH = 160;

    public EditRouteScreen(Route route, DashboardScreen dashboardScreen) {
        super(route, dashboardScreen, "gui.mtr.route_name", "gui.mtr.route_color");
        if (route.platformIds.size() > 0) {
            Station firstStation = (Station)ClientData.DATA_CACHE.platformIdToStation.get(route.platformIds.get(0));
            Station lastStation = (Station)ClientData.DATA_CACHE.platformIdToStation.get(route.platformIds.get(route.platformIds.size() - 1));
            this.isCircular = firstStation != null && lastStation != null && firstStation.id == lastStation.id;
        } else {
            this.isCircular = false;
        }
    }

    protected void m_7856_() {
        this.setPositionsAndInit(20, this.f_96543_ / 4 * 3 - 20, this.f_96543_ - 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonRouteType, 20, 60, 160);
        this.setRouteTypeText(((Route)this.data).transportMode, ((Route)this.data).routeType);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonIsRouteHidden, 20, 80, 160);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonIsLightRailRoute, 20, 100, 160);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldLightRailRouteNumber, 22, 142, 156);
        this.textFieldLightRailRouteNumber.m_94144_(((Route)this.data).lightRailRouteNumber);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonIsClockwiseRoute, 20, 164, 160);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonIsAntiClockwiseRoute, 20, 184, 160);
        if (!((Route)this.data).transportMode.continuousMovement) {
            this.addDrawableChild(this.buttonRouteType);
        }
        this.addDrawableChild(this.textFieldLightRailRouteNumber);
        this.addDrawableChild(this.buttonIsLightRailRoute);
        this.addDrawableChild(this.buttonIsRouteHidden);
        if (this.isCircular) {
            this.addDrawableChild(this.buttonIsClockwiseRoute);
            this.addDrawableChild(this.buttonIsAntiClockwiseRoute);
        }
        this.setIsLightRailRoute(((Route)this.data).isLightRailRoute);
        this.setIsRouteHidden(((Route)this.data).isHidden);
        this.setIsClockwise(((Route)this.data).circularState == Route.CircularState.CLOCKWISE);
        this.setIsAntiClockwise(((Route)this.data).circularState == Route.CircularState.ANTICLOCKWISE);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.m_7333_(matrices);
            this.renderTextFields(matrices);
            if (this.textFieldLightRailRouteNumber.f_93624_) {
                EditRouteScreen.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.lightRailRouteNumberText, (int)20, (int)126, (int)-1);
            }
            super.m_6305_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void saveData() {
        super.saveData();
        ((Route)this.data).routeType = this.routeType;
        ((Route)this.data).isLightRailRoute = this.buttonIsLightRailRoute.m_93840_();
        ((Route)this.data).lightRailRouteNumber = this.textFieldLightRailRouteNumber.m_94155_();
        ((Route)this.data).isHidden = this.buttonIsRouteHidden.m_93840_();
        ((Route)this.data).circularState = this.isCircular ? (this.buttonIsClockwiseRoute.m_93840_() ? Route.CircularState.CLOCKWISE : (this.buttonIsAntiClockwiseRoute.m_93840_() ? Route.CircularState.ANTICLOCKWISE : Route.CircularState.NONE)) : Route.CircularState.NONE;
        ((Route)this.data).setExtraData(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_ROUTE, packet));
    }

    private void setRouteTypeText(TransportMode transportMode, RouteType newRouteType) {
        this.routeType = newRouteType;
        this.buttonRouteType.m_93666_((Component)Text.translatable(String.format("gui.mtr.route_type_%s_%s", new Object[]{transportMode, this.routeType}).toLowerCase(), new Object[0]));
    }

    private void setIsLightRailRoute(boolean isLightRailRoute) {
        this.buttonIsLightRailRoute.setChecked(isLightRailRoute);
        this.textFieldLightRailRouteNumber.f_93624_ = isLightRailRoute;
    }

    private void setIsRouteHidden(boolean isRouteHidden) {
        this.buttonIsRouteHidden.setChecked(isRouteHidden);
    }

    private void setIsClockwise(boolean isClockwise) {
        this.buttonIsClockwiseRoute.setChecked(isClockwise);
        if (isClockwise) {
            this.buttonIsAntiClockwiseRoute.setChecked(false);
        }
    }

    private void setIsAntiClockwise(boolean isAntiClockwise) {
        this.buttonIsAntiClockwiseRoute.setChecked(isAntiClockwise);
        if (isAntiClockwise) {
            this.buttonIsClockwiseRoute.setChecked(false);
        }
    }
}

