/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.Siding;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardListSelectorScreen;
import mtr.screen.DashboardScreen;
import mtr.screen.EditNameColorScreenBase;
import mtr.screen.WidgetShorterSlider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

public class EditDepotScreen
extends EditNameColorScreenBase<Depot> {
    private final int sliderX;
    private final int sliderWidthWithText;
    private final int rightPanelsX;
    private final boolean showScheduleControls;
    private final Map<Long, Siding> sidingsInDepot;
    private final WidgetShorterSlider[] sliders = new WidgetShorterSlider[24];
    private final Button buttonEditInstructions;
    private final Button buttonGenerateRoute;
    private final Button buttonClearTrains;
    private static final int PANELS_START = 44;
    private static final int SLIDER_WIDTH = 64;
    private static final int MAX_TRAINS_PER_HOUR = 5;
    private static final int SECONDS_PER_MC_HOUR = 50;

    public EditDepotScreen(Depot depot, TransportMode transportMode, DashboardScreen dashboardScreen) {
        super(depot, dashboardScreen, "gui.mtr.depot_name", "gui.mtr.depot_color");
        this.sidingsInDepot = ClientData.DATA_CACHE.requestDepotIdToSidings(depot.id);
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.sliderX = this.f_96547_.m_92895_(EditDepotScreen.getTimeString(0)) + 12;
        this.sliderWidthWithText = 70 + this.f_96547_.m_92895_(EditDepotScreen.getSliderString(0));
        this.rightPanelsX = this.sliderX + 64 + 12 + this.f_96547_.m_92895_(EditDepotScreen.getSliderString(1));
        this.showScheduleControls = !transportMode.continuousMovement;
        int i = 0;
        while (i < 24) {
            int currentIndex = i++;
            this.sliders[currentIndex] = new WidgetShorterSlider(this.sliderX, 64, 10, EditDepotScreen::getSliderString, value -> {
                for (int j = 0; j < 24; ++j) {
                    if (j == currentIndex) continue;
                    this.sliders[j].setValue((int)value);
                }
            });
        }
        this.buttonEditInstructions = new Button(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.edit_instructions", new Object[0]), button -> {
            if (this.f_96541_ != null) {
                this.saveData();
                ArrayList<NameColorDataBase> routes = new ArrayList<NameColorDataBase>(ClientData.getFilteredDataSet(transportMode, ClientData.ROUTES));
                Collections.sort(routes);
                UtilitiesClient.setScreen(this.f_96541_, new DashboardListSelectorScreen(this, routes, ((Depot)this.data).routeIds, false, true));
            }
        });
        this.buttonGenerateRoute = new Button(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.refresh_path", new Object[0]), button -> {
            this.saveData();
            depot.clientPathGenerationSuccessfulSegments = -1;
            PacketTrainDataGuiClient.generatePathC2S(depot.id);
        });
        this.buttonClearTrains = new Button(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.clear_vehicles", new Object[0]), button -> {
            this.sidingsInDepot.values().forEach(Siding::clearTrains);
            PacketTrainDataGuiClient.clearTrainsC2S(depot.id, this.sidingsInDepot.values());
        });
    }

    protected void m_7856_() {
        this.setPositionsAndInit(this.rightPanelsX, this.f_96543_ / 4 * 3, this.f_96543_);
        int buttonWidth = (this.f_96543_ - this.rightPanelsX) / 2;
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonEditInstructions, this.rightPanelsX, 44, buttonWidth * 2);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonGenerateRoute, this.rightPanelsX, 64, buttonWidth * (this.showScheduleControls ? 1 : 2));
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonClearTrains, this.rightPanelsX + buttonWidth, 64, buttonWidth);
        if (this.showScheduleControls) {
            for (WidgetShorterSlider slider : this.sliders) {
                this.addDrawableChild(slider);
            }
        }
        for (int i = 0; i < 24; ++i) {
            this.sliders[i].setValue(((Depot)this.data).getFrequency(i));
        }
        this.addDrawableChild(this.buttonEditInstructions);
        this.addDrawableChild(this.buttonGenerateRoute);
        if (this.showScheduleControls) {
            this.addDrawableChild(this.buttonClearTrains);
        }
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        this.buttonGenerateRoute.f_93623_ = ((Depot)this.data).clientPathGenerationSuccessfulSegments >= 0;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.m_7333_(matrices);
            this.m_93222_(matrices, this.rightPanelsX - 1, -1, this.f_96544_, Integer.MAX_VALUE);
            this.renderTextFields(matrices);
            int lineHeight = Math.min(20, (this.f_96544_ - 20) / 24);
            for (int i = 0; i < 24; ++i) {
                if (this.showScheduleControls) {
                    EditDepotScreen.m_93236_((PoseStack)matrices, (Font)this.f_96547_, (String)EditDepotScreen.getTimeString(i), (int)6, (int)(20 + lineHeight * i + (int)((float)(lineHeight - 8) / 2.0f)), (int)-1);
                }
                this.sliders[i].f_93621_ = 20 + lineHeight * i;
                this.sliders[i].setHeight(lineHeight);
            }
            super.m_6305_(matrices, mouseX, mouseY, delta);
            this.f_96547_.m_92889_(matrices, (Component)Text.translatable("gui.mtr.sidings_in_depot", this.sidingsInDepot.size()), (float)(this.rightPanelsX + 6), 90.0f, -1);
            String[] stringSplit = this.getSuccessfulSegmentsText().getString().split("\\|");
            for (int i = 0; i < stringSplit.length; ++i) {
                this.f_96547_.m_92883_(matrices, stringSplit[i], (float)(this.rightPanelsX + 6), (float)(110 + 14 * i), -1);
            }
            if (this.showScheduleControls) {
                EditDepotScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.game_time", new Object[0]), (int)(this.sliderX / 2), (int)6, (int)-5592406);
                EditDepotScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.vehicles_per_hour", new Object[0]), (int)(this.sliderX + this.sliderWidthWithText / 2), (int)6, (int)-5592406);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void saveData() {
        super.saveData();
        for (int i = 0; i < 24; ++i) {
            ((Depot)this.data).setFrequency(this.sliders[i].getIntValue(), i);
        }
        ((Depot)this.data).setData(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_DEPOT, packet));
    }

    private Component getSuccessfulSegmentsText() {
        int successfulSegments = ((Depot)this.data).clientPathGenerationSuccessfulSegments;
        if (successfulSegments < 0) {
            return Text.translatable("gui.mtr.generating_path", new Object[0]);
        }
        if (successfulSegments == 0) {
            return Text.translatable("gui.mtr.path_not_generated", new Object[0]);
        }
        ArrayList<String> stationNames = new ArrayList<String>();
        ArrayList<String> routeNames = new ArrayList<String>();
        String depotName = IGui.textOrUntitled(IGui.formatStationName(((Depot)this.data).name));
        if (successfulSegments == 1) {
            RailwayData.useRoutesAndStationsFromIndex(0, ((Depot)this.data).routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
                stationNames.add(IGui.textOrUntitled(thisStation == null ? "" : IGui.formatStationName(thisStation.name)));
                routeNames.add(IGui.textOrUntitled(thisRoute == null ? "" : IGui.formatStationName(thisRoute.name)));
            });
            stationNames.add("-");
            routeNames.add("-");
            return Text.translatable("gui.mtr.path_not_found_between", routeNames.get(0), depotName, stationNames.get(0));
        }
        int sum = 0;
        for (int i = 0; i < ((Depot)this.data).routeIds.size(); ++i) {
            Route nextRoute2;
            Route thisRoute2 = (Route)ClientData.DATA_CACHE.routeIdMap.get(((Depot)this.data).routeIds.get(i));
            Route route = nextRoute2 = i < ((Depot)this.data).routeIds.size() - 1 ? (Route)ClientData.DATA_CACHE.routeIdMap.get(((Depot)this.data).routeIds.get(i + 1)) : null;
            if (thisRoute2 == null) continue;
            sum += thisRoute2.platformIds.size();
            if (thisRoute2.platformIds.isEmpty() || nextRoute2 == null || nextRoute2.platformIds.isEmpty() || !thisRoute2.platformIds.get(thisRoute2.platformIds.size() - 1).equals(nextRoute2.platformIds.get(0))) continue;
            --sum;
        }
        if (successfulSegments >= sum + 2) {
            return Text.translatable("gui.mtr.path_found", new Object[0]);
        }
        RailwayData.useRoutesAndStationsFromIndex(successfulSegments - 2, ((Depot)this.data).routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
            stationNames.add(IGui.textOrUntitled(thisStation == null ? "" : IGui.formatStationName(thisStation.name)));
            if (nextStation == null) {
                RailwayData.useRoutesAndStationsFromIndex(successfulSegments - 1, ((Depot)this.data).routeIds, ClientData.DATA_CACHE, (currentStationIndex1, thisRoute1, nextRoute1, thisStation1, nextStation1, lastStation1) -> stationNames.add(IGui.textOrUntitled(thisStation1 == null ? "" : IGui.formatStationName(thisStation1.name))));
            } else {
                stationNames.add(IGui.textOrUntitled(IGui.formatStationName(nextStation.name)));
            }
            routeNames.add(IGui.textOrUntitled(IGui.formatStationName(thisRoute.name)));
        });
        stationNames.add("-");
        stationNames.add("-");
        routeNames.add("-");
        if (successfulSegments < sum + 1) {
            return Text.translatable("gui.mtr.path_not_found_between", routeNames.get(0), stationNames.get(0), stationNames.get(1));
        }
        return Text.translatable("gui.mtr.path_not_found_between", routeNames.get(0), stationNames.get(0), depotName);
    }

    private static String getSliderString(int value) {
        Object headwayText = value == 0 ? "" : " (" + RailwayData.round(200.0f / (float)value, 1) + Text.translatable("gui.mtr.s", new Object[0]).getString() + ")";
        return (float)value / 4.0f + Text.translatable("gui.mtr.tph", new Object[0]).getString() + (String)headwayText;
    }

    private static String getTimeString(int hour) {
        String hourString = StringUtils.leftPad((String)String.valueOf(hour), (int)2, (String)"0");
        return String.format("%s:00-%s:59", hourString, hourString);
    }
}

