/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.DashboardList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class DashboardListSelectorScreen
extends ScreenMapper
implements IGui {
    private final DashboardList availableList;
    private final DashboardList selectedList;
    private final Button buttonDone;
    private final ScreenMapper previousScreen;
    private final Runnable onClose;
    private final List<NameColorDataBase> allData;
    private final Collection<Long> selectedIds;
    private final boolean isSingleSelect;
    private final boolean canRepeat;

    public DashboardListSelectorScreen(Runnable onClose, List<NameColorDataBase> allData, Collection<Long> selectedIds, boolean isSingleSelect, boolean canRepeat) {
        this(null, onClose, allData, selectedIds, isSingleSelect, canRepeat);
    }

    public DashboardListSelectorScreen(ScreenMapper previousScreen, List<NameColorDataBase> allData, Collection<Long> selectedIds, boolean isSingleSelect, boolean canRepeat) {
        this(previousScreen, null, allData, selectedIds, isSingleSelect, canRepeat);
    }

    private DashboardListSelectorScreen(ScreenMapper previousScreen, Runnable onClose, List<NameColorDataBase> allData, Collection<Long> selectedIds, boolean isSingleSelect, boolean canRepeat) {
        super((Component)Text.literal(""));
        this.previousScreen = previousScreen;
        this.onClose = onClose;
        this.allData = allData;
        this.selectedIds = selectedIds;
        this.isSingleSelect = isSingleSelect;
        this.canRepeat = canRepeat;
        this.availableList = new DashboardList(null, null, null, null, this::onAdd, null, null, () -> ClientData.ROUTES_PLATFORMS_SEARCH, text -> {
            ClientData.ROUTES_PLATFORMS_SEARCH = text;
        });
        this.selectedList = new DashboardList(null, null, null, this::updateList, null, this::onDelete, () -> selectedIds instanceof ArrayList ? (List)selectedIds : new ArrayList(), () -> ClientData.ROUTES_PLATFORMS_SELECTED_SEARCH, text -> {
            ClientData.ROUTES_PLATFORMS_SELECTED_SEARCH = text;
        });
        this.buttonDone = new Button(0, 0, 0, 20, (Component)Text.translatable("gui.done", new Object[0]), button -> this.m_7379_());
    }

    protected void m_7856_() {
        super.m_7856_();
        this.availableList.x = this.f_96543_ / 2 - 144 - 20;
        this.selectedList.x = this.f_96543_ / 2 + 20;
        this.selectedList.y = 40;
        this.availableList.y = 40;
        this.availableList.height = this.selectedList.height = this.f_96544_ - 100;
        this.selectedList.width = 144;
        this.availableList.width = 144;
        this.availableList.init(this::addDrawableChild);
        this.selectedList.init(this::addDrawableChild);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonDone, (this.f_96543_ - 144) / 2, this.f_96544_ - 40, 144);
        this.addDrawableChild(this.buttonDone);
        this.updateList();
    }

    public void m_96624_() {
        this.availableList.tick();
        this.selectedList.tick();
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.m_7333_(matrices);
            this.availableList.render(matrices, this.f_96547_);
            this.selectedList.render(matrices, this.f_96547_);
            super.m_6305_(matrices, mouseX, mouseY, delta);
            DashboardListSelectorScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.available", new Object[0]), (int)(this.f_96543_ / 2 - 72 - 20), (int)26, (int)-1);
            DashboardListSelectorScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.selected", new Object[0]), (int)(this.f_96543_ / 2 + 72 + 20), (int)26, (int)-1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.availableList.mouseMoved(mouseX, mouseY);
        this.selectedList.mouseMoved(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.availableList.mouseScrolled(mouseX, mouseY, amount);
        this.selectedList.mouseScrolled(mouseX, mouseY, amount);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.onClose != null) {
            this.onClose.run();
        }
        if (this.f_96541_ != null && this.previousScreen != null) {
            UtilitiesClient.setScreen(this.f_96541_, this.previousScreen);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private void updateList() {
        ArrayList<NameColorDataBase> availableData = new ArrayList<NameColorDataBase>();
        for (NameColorDataBase data2 : this.allData) {
            if (!this.canRepeat && this.selectedIds.contains(data2.id)) continue;
            availableData.add(data2);
        }
        ArrayList selectedData = new ArrayList();
        for (long selectedId : this.selectedIds) {
            this.allData.stream().filter(data -> data.id == selectedId).findFirst().ifPresent(selectedData::add);
        }
        this.availableList.setData(availableData, false, false, false, false, true, false);
        this.selectedList.setData(selectedData, false, false, false, this.canRepeat, false, true);
    }

    private void onAdd(NameColorDataBase data, int index) {
        if (this.isSingleSelect) {
            this.selectedIds.clear();
        }
        this.selectedIds.add(data.id);
        this.updateList();
    }

    private void onDelete(NameColorDataBase data, int index) {
        if (this.canRepeat && this.selectedIds instanceof ArrayList) {
            ((ArrayList)this.selectedIds).remove(index);
        } else {
            this.selectedIds.remove(data.id);
        }
        this.updateList();
    }
}

