/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mtr.block.BlockStationNameBase;
import mtr.block.BlockStationNameEntrance;
import mtr.block.BlockStationNameWallBase;
import mtr.block.IBlock;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderStationNameBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class RenderStationNameTiled<T extends BlockStationNameBase.TileEntityStationNameBase>
extends RenderStationNameBase<T> {
    private final boolean showLogo;

    public RenderStationNameTiled(BlockEntityRenderDispatcher dispatcher, boolean showLogo) {
        super(dispatcher);
        this.showLogo = showLogo;
    }

    @Override
    protected void drawStationName(BlockStationNameBase.TileEntityStationNameBase entity, PoseStack matrices, MultiBufferSource vertexConsumers, MultiBufferSource.BufferSource immediate, String stationName, int color, int light) {
        Level world = entity.m_58904_();
        BlockPos pos = entity.m_58899_();
        if (world == null) {
            return;
        }
        int length = this.getLength((BlockGetter)world, pos);
        if (this.showLogo) {
            Direction facing = (Direction)IBlock.getStatePropertySafe((BlockGetter)world, pos, BlockStationNameBase.f_54117_);
            int propagateProperty = (Integer)IBlock.getStatePropertySafe((BlockGetter)world, pos, BlockStationNameEntrance.STYLE);
            float logoSize = propagateProperty % 2 == 0 ? 0.5f : 1.0f;
            IDrawing.drawStringWithFont(matrices, Minecraft.m_91087_().f_91062_, immediate, IGui.insertTranslation("gui.mtr.station_cjk", "gui.mtr.station", 1, stationName), IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, IGui.HorizontalAlignment.CENTER, ((float)length + logoSize) / 2.0f - 0.5f, 0.0f, (float)length - logoSize, logoSize - 0.125f, 40.0f / logoSize, propagateProperty < 2 || propagateProperty >= 4 ? -1 : -16777216, false, 0xF000F0, (x1, y1, x2, y2) -> {
                VertexConsumer vertexConsumer = vertexConsumers.m_6299_(MoreRenderLayers.getInterior(new ResourceLocation("mtr:textures/sign/logo.png")));
                IDrawing.drawTexture(matrices, vertexConsumer, x1 - logoSize, -logoSize / 2.0f, logoSize, logoSize, facing, 0xF000F0);
            });
        } else if (entity instanceof BlockStationNameWallBase.TileEntityStationNameWallBase) {
            IDrawing.drawStringWithFont(matrices, Minecraft.m_91087_().f_91062_, immediate, stationName, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, IGui.HorizontalAlignment.CENTER, (float)length / 2.0f - 0.5f, 0.0f, length, 0.875f, 60.0f, ((BlockStationNameWallBase.TileEntityStationNameWallBase)entity).color, false, light, null);
        }
    }

    private int getLength(BlockGetter world, BlockPos pos) {
        Block checkBlock;
        if (world == null) {
            return 1;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe(world, pos, BlockStationNameBase.f_54117_);
        Block thisBlock = world.m_8055_(pos).m_60734_();
        int length = 1;
        while ((checkBlock = world.m_8055_(pos.m_5484_(facing.m_122427_(), length)).m_60734_()) instanceof BlockStationNameBase && checkBlock == thisBlock) {
            ++length;
        }
        return length;
    }
}

