/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Vector3f;
import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Text;
import mtr.render.RenderTrains;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class RenderStationNameBase<T extends BlockStationNameBase.TileEntityStationNameBase>
extends BlockEntityRendererMapper<T>
implements IGui,
IDrawing {
    public RenderStationNameBase(BlockEntityRenderDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (!((BlockStationNameBase.TileEntityStationNameBase)((Object)entity)).shouldRender()) {
            return;
        }
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        BlockState state = world.m_8055_(pos);
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, BlockStationNameBase.f_54117_);
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, ((BlockStationNameBase.TileEntityStationNameBase)((Object)entity)).isDoubleSided ? null : facing)) {
            return;
        }
        int color = switch ((Integer)IBlock.getStatePropertySafe(state, BlockStationNameBase.COLOR)) {
            case 1 -> -5592406;
            case 2 -> -16777216;
            default -> -1;
        };
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.5 + (double)((BlockStationNameBase.TileEntityStationNameBase)((Object)entity)).yOffset, 0.5);
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(-facing.m_122435_()));
        matrices.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
        MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        for (int i = 0; i < (((BlockStationNameBase.TileEntityStationNameBase)((Object)entity)).isDoubleSided ? 2 : 1); ++i) {
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 0.5 - (double)((BlockStationNameBase.TileEntityStationNameBase)((Object)entity)).zOffset - (double)0.003125f);
            this.drawStationName((BlockStationNameBase.TileEntityStationNameBase)((Object)entity), matrices, vertexConsumers, immediate, station == null ? Text.translatable("gui.mtr.untitled", new Object[0]).getString() : station.name, color, light);
            matrices.m_85849_();
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        }
        immediate.m_109911_();
        matrices.m_85849_();
    }

    protected abstract void drawStationName(BlockStationNameBase.TileEntityStationNameBase var1, PoseStack var2, MultiBufferSource var3, MultiBufferSource.BufferSource var4, String var5, int var6, int var7);
}

