/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import mtr.block.BlockLiftButtons;
import mtr.block.IBlock;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.entity.EntityLift;
import mtr.item.ItemLiftButtonsLinkModifier;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Utilities;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderLift;
import mtr.render.RenderTrains;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RenderLiftButtons
extends BlockEntityRendererMapper<BlockLiftButtons.TileEntityLiftButtons>
implements IGui,
IBlock {
    private static final int HOVER_COLOR = -21846;
    private static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("mtr:textures/block/lift_button.png");

    public RenderLiftButtons(BlockEntityRenderDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(BlockLiftButtons.TileEntityLiftButtons entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        VertexConsumer vertexConsumer;
        boolean lookingAtBottomHalf;
        boolean lookingAtTopHalf;
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, null)) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, HorizontalDirectionalBlock.f_54117_);
        boolean holdingLinker = Utilities.isHolding((Player)player, item -> item instanceof ItemLiftButtonsLinkModifier || Block.m_49814_((Item)item) instanceof BlockLiftButtons);
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.0, 0.5);
        boolean[] buttonStates = new boolean[]{false, false, false, false};
        HashMap liftDisplays = new HashMap();
        ArrayList<BlockPos> liftPositions = new ArrayList<BlockPos>();
        entity.forEachTrackPosition(world, (trackPosition, trackFloorTileEntity) -> {
            EntityLift entityLift;
            if (holdingLinker) {
                Direction trackFacing = (Direction)IBlock.getStatePropertySafe((BlockGetter)world, trackPosition, HorizontalDirectionalBlock.f_54117_);
                IDrawing.drawLine(matrices, vertexConsumers, (float)(trackPosition.m_123341_() - pos.m_123341_()) + (float)trackFacing.m_122429_() / 2.0f, (float)(trackPosition.m_123342_() - pos.m_123342_()) + 0.5f, (float)(trackPosition.m_123343_() - pos.m_123343_()) + (float)trackFacing.m_122431_() / 2.0f, (float)facing.m_122429_() / 2.0f, 0.25f, (float)facing.m_122431_() / 2.0f, 255, 255, 255);
            }
            if ((entityLift = trackFloorTileEntity.getEntityLift()) != null) {
                entityLift.hasButton(trackPosition.m_123342_(), buttonStates);
                if (entityLift.hasStoppingFloorsClient(trackPosition.m_123342_(), true)) {
                    buttonStates[2] = true;
                }
                if (entityLift.hasStoppingFloorsClient(trackPosition.m_123342_(), false)) {
                    buttonStates[3] = true;
                }
                BlockPos liftPos = new BlockPos(entityLift.m_20185_(), 0.0, entityLift.m_20189_());
                liftPositions.add(liftPos);
                liftDisplays.put(liftPos, new Tuple((Object)entityLift.getCurrentFloorDisplay(), (Object)entityLift.getLiftDirectionClient()));
            }
        });
        liftPositions.sort(Comparator.comparingInt(checkPos -> facing.m_122429_() * (checkPos.m_123343_() - pos.m_123343_()) - facing.m_122431_() * (checkPos.m_123341_() - pos.m_123341_())));
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult == null) {
            lookingAtTopHalf = false;
            lookingAtBottomHalf = false;
        } else {
            Vec3 hitLocation = hitResult.m_82450_();
            double hitX = hitLocation.f_82479_ - Math.floor(hitLocation.f_82479_);
            double hitY = hitLocation.f_82480_ - Math.floor(hitLocation.f_82480_);
            double hitZ = hitLocation.f_82481_ - Math.floor(hitLocation.f_82481_);
            boolean inBlock = hitX > 0.0 && hitY > 0.0 && hitZ > 0.0 && new BlockPos(hitLocation).equals((Object)pos);
            lookingAtTopHalf = inBlock && (!buttonStates[1] || hitY > 0.25 && hitY < 0.5);
            lookingAtBottomHalf = inBlock && (!buttonStates[0] || hitY < 0.25);
        }
        matrices.m_85845_(Vector3f.f_122224_.m_122240_(facing.m_122435_()));
        matrices.m_85837_(0.0, 0.0, 0.43437499995343387);
        if (buttonStates[0]) {
            vertexConsumer = vertexConsumers.m_6299_(buttonStates[2] || lookingAtTopHalf ? MoreRenderLayers.getLight(BUTTON_TEXTURE, true) : MoreRenderLayers.getExterior(BUTTON_TEXTURE));
            IDrawing.drawTexture(matrices, vertexConsumer, -0.09375f, (buttonStates[1] ? 4.5f : 2.5f) / 16.0f, 0.1875f, 0.1875f, 0.0f, 1.0f, 1.0f, 0.0f, facing, buttonStates[2] ? -65536 : (lookingAtTopHalf ? -21846 : -10066330), light);
        }
        if (buttonStates[1]) {
            vertexConsumer = vertexConsumers.m_6299_(buttonStates[3] || lookingAtBottomHalf ? MoreRenderLayers.getLight(BUTTON_TEXTURE, true) : MoreRenderLayers.getExterior(BUTTON_TEXTURE));
            IDrawing.drawTexture(matrices, vertexConsumer, -0.09375f, (buttonStates[0] ? 0.5f : 2.5f) / 16.0f, 0.1875f, 0.1875f, 0.0f, 0.0f, 1.0f, 1.0f, facing, buttonStates[3] ? -65536 : (lookingAtBottomHalf ? -21846 : -10066330), light);
        }
        float maxWidth = Math.min(0.25f, 0.375f / (float)liftPositions.size());
        matrices.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrices.m_85837_((double)maxWidth * (0.5 - (double)((float)liftPositions.size() / 2.0f)), 0.0, 0.0);
        IDrawing.drawTexture(matrices, vertexConsumers.m_6299_(MoreRenderLayers.getExterior(new ResourceLocation("mtr:textures/block/black.png"))), -maxWidth / 2.0f, -0.9375f, maxWidth * (float)liftPositions.size(), 0.40625f, Direction.UP, light);
        matrices.m_85837_(0.0, -0.875, (double)-0.003125f);
        liftPositions.forEach(liftPosition -> {
            Tuple liftDisplay = (Tuple)liftDisplays.get(liftPosition);
            if (liftDisplay != null) {
                RenderLift.renderLiftDisplay(matrices, vertexConsumers, pos, ((String[])liftDisplay.m_14418_())[0], (EntityLift.LiftDirection)((Object)((Object)liftDisplay.m_14419_())), maxWidth, 0.3125f);
            }
            matrices.m_85837_((double)maxWidth, 0.0, 0.0);
        });
        matrices.m_85849_();
    }
}

