/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import java.io.IOException;
import java.util.Set;
import javax.imageio.ImageIO;
import mtr.data.AreaBase;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.packet.IUpdateWebMap;
import net.minecraft.world.level.Level;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.Registry;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.SquaremapProvider;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;

public class UpdateSquaremap
implements IGui,
IUpdateWebMap {
    public static void updateSquaremap(Level world, RailwayData railwayData) {
        try {
            UpdateSquaremap.updateSquaremap(world, railwayData.stations, "mtr_stations", "Stations", "mtr_station_areas", "Station Areas", "mtr_station");
            UpdateSquaremap.updateSquaremap(world, railwayData.depots, "mtr_depots", "Depots", "mtr_depot_areas", "Depot Areas", "mtr_depot");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <T extends AreaBase> void updateSquaremap(Level world, Set<T> areas, String areasId, String areasTitle, String areaAreasId, String areaAreasTitle, String iconKey) {
        SimpleLayerProvider providerAreaAreas;
        SimpleLayerProvider providerAreas;
        MapWorld mapWorld = SquaremapProvider.get().getWorldIfEnabled(WorldIdentifier.parse((String)world.m_46472_().m_135782_().toString())).orElse(null);
        if (mapWorld == null) {
            return;
        }
        Registry layerRegistry = mapWorld.layerRegistry();
        if (layerRegistry.hasEntry(Key.of((String)areasId))) {
            providerAreas = (SimpleLayerProvider)layerRegistry.get(Key.of((String)areasId));
            providerAreas.clearMarkers();
        } else {
            providerAreas = SimpleLayerProvider.builder((String)areasTitle).showControls(true).build();
            layerRegistry.register(Key.of((String)areasId), (Object)providerAreas);
        }
        if (layerRegistry.hasEntry(Key.of((String)areaAreasId))) {
            providerAreaAreas = (SimpleLayerProvider)layerRegistry.get(Key.of((String)areaAreasId));
            providerAreaAreas.clearMarkers();
        } else {
            providerAreaAreas = SimpleLayerProvider.builder((String)areaAreasTitle).showControls(true).defaultHidden(true).build();
            layerRegistry.register(Key.of((String)areaAreasId), (Object)providerAreaAreas);
        }
        IUpdateWebMap.iterateAreas(areas, (id, name, color, areaCorner1X, areaCorner1Z, areaCorner2X, areaCorner2Z, areaX, areaZ) -> {
            MarkerOptions markerOptions = MarkerOptions.builder().hoverTooltip(name).fillColor(color).strokeColor(color.darker()).build();
            providerAreas.addMarker(Key.of((String)id), Marker.icon((Point)Point.of((double)areaX, (double)areaZ), (Key)Key.of((String)iconKey), (int)24).markerOptions(markerOptions));
            providerAreaAreas.addMarker(Key.of((String)id), Marker.rectangle((Point)Point.of((double)areaCorner1X, (double)areaCorner1Z), (Point)Point.of((double)areaCorner2X, (double)areaCorner2Z)).markerOptions(markerOptions));
        });
    }

    static {
        try {
            Registry iconRegistry = SquaremapProvider.get().iconRegistry();
            IUpdateWebMap.readResource("/assets/mtr/textures/sign/logo.png", inputStream -> {
                try {
                    iconRegistry.register(Key.of((String)"mtr_station"), (Object)ImageIO.read(inputStream));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            IUpdateWebMap.readResource("/assets/mtr/textures/sign/logo_grayscale.png", inputStream -> {
                try {
                    iconRegistry.register(Key.of((String)"mtr_depot"), (Object)ImageIO.read(inputStream));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

