/*
 * Decompiled with CFR 0.152.
 */
package mtr.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mtr.EntityTypes;
import mtr.mappings.ModelDataWrapper;
import mtr.mappings.ModelMapper;
import mtr.model.ModelTrainBase;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.texture.OverlayTexture;

public class ModelLift1
extends ModelTrainBase {
    private final ModelMapper main;
    private final ModelMapper main_edge;
    private final ModelMapper main_corner;
    private final ModelMapper handrail_bottom_r1;
    private final ModelMapper main_exterior;
    private final ModelMapper main_exterior_edge;
    private final ModelMapper main_exterior_corner;
    private final ModelMapper main_light;
    private final ModelMapper door;
    private final ModelMapper door_left;
    private final ModelMapper door_right;
    private final ModelMapper door_exterior;
    private final ModelMapper door_left_exterior;
    private final ModelMapper door_right_exterior;
    private final ModelMapper wall_patch;
    private final ModelMapper handrail_bottom_r2;
    private final ModelMapper handrail_bottom_r3;
    private final int width;
    private final int depth;
    private final boolean isDoubleSided;

    public ModelLift1(EntityTypes.LiftType liftType) {
        this.width = liftType.width;
        this.depth = liftType.depth;
        this.isDoubleSided = liftType.isDoubleSided;
        int textureWidth = 128;
        int textureHeight = 128;
        ModelDataWrapper modelDataWrapper = new ModelDataWrapper((Model)this, 128, 128);
        this.main = new ModelMapper(modelDataWrapper);
        this.main.setPos(0.0f, 24.0f, 0.0f);
        this.main.texOffs(0, 34).addBox(-8.0f, 0.0f, -8.0f, 16, 0, 16, 0.0f, false);
        this.main.texOffs(32, 17).addBox(-8.0f, -32.0f, -8.0f, 16, 0, 16, 0.0f, false);
        this.main_edge = new ModelMapper(modelDataWrapper);
        this.main_edge.setPos(0.0f, 24.0f, 0.0f);
        this.main_edge.texOffs(18, 44).addBox(-4.0f, 0.0f, -8.0f, 8, 0, 6, 0.0f, false);
        this.main_edge.texOffs(54, 17).addBox(-4.0f, -32.0f, -8.0f, 8, 0, 6, 0.0f, false);
        this.main_edge.texOffs(76, 33).addBox(-4.0f, -32.0f, -3.0f, 8, 32, 1, 0.0f, false);
        this.main_edge.texOffs(28, 52).addBox(-4.0f, -13.0f, -4.0f, 8, 1, 1, 0.0f, false);
        this.main_edge.texOffs(26, 50).addBox(-4.0f, -2.0f, -4.0f, 8, 1, 1, 0.0f, false);
        this.main_corner = new ModelMapper(modelDataWrapper);
        this.main_corner.setPos(0.0f, 24.0f, 0.0f);
        this.main_corner.texOffs(20, 44).addBox(2.0f, 0.0f, -8.0f, 6, 0, 6, 0.0f, false);
        this.main_corner.texOffs(52, 17).addBox(2.0f, -32.0f, -8.0f, 6, 0, 6, 0.0f, false);
        this.main_corner.texOffs(95, 33).addBox(3.0f, -32.0f, -3.0f, 5, 32, 1, 0.0f, false);
        this.main_corner.texOffs(29, 52).addBox(5.0f, -13.0f, -4.0f, 3, 1, 1, 0.0f, false);
        this.main_corner.texOffs(27, 50).addBox(5.0f, -2.0f, -4.0f, 3, 1, 1, 0.0f, false);
        this.main_corner.texOffs(104, 68).addBox(2.0f, -32.0f, -3.0f, 1, 32, 1, 0.0f, false);
        this.handrail_bottom_r1 = new ModelMapper(modelDataWrapper);
        this.handrail_bottom_r1.setPos(0.0f, 0.0f, 0.0f);
        this.main_corner.addChild(this.handrail_bottom_r1);
        ModelLift1.setRotationAngle(this.handrail_bottom_r1, 0.0f, -1.5708f, 0.0f);
        this.handrail_bottom_r1.texOffs(36, 50).addBox(-8.0f, -2.0f, -4.0f, 3, 1, 1, 0.0f, false);
        this.handrail_bottom_r1.texOffs(38, 52).addBox(-8.0f, -13.0f, -4.0f, 3, 1, 1, 0.0f, false);
        this.handrail_bottom_r1.texOffs(95, 33).addBox(-8.0f, -32.0f, -3.0f, 5, 32, 1, 0.0f, false);
        this.main_exterior = new ModelMapper(modelDataWrapper);
        this.main_exterior.setPos(0.0f, 24.0f, 0.0f);
        this.main_exterior.texOffs(0, 17).addBox(-8.0f, 0.0f, -8.0f, 16, 1, 16, 0.0f, false);
        this.main_exterior.texOffs(0, 0).addBox(-8.0f, -33.0f, -8.0f, 16, 1, 16, 0.0f, false);
        this.main_exterior_edge = new ModelMapper(modelDataWrapper);
        this.main_exterior_edge.setPos(0.0f, 24.0f, 0.0f);
        this.main_exterior_edge.texOffs(18, 27).addBox(-4.0f, 0.0f, -8.0f, 8, 1, 6, 0.0f, false);
        this.main_exterior_edge.texOffs(18, 10).addBox(-4.0f, -33.0f, -8.0f, 8, 1, 6, 0.0f, false);
        this.main_exterior_corner = new ModelMapper(modelDataWrapper);
        this.main_exterior_corner.setPos(0.0f, 24.0f, 0.0f);
        this.main_exterior_corner.texOffs(20, 27).addBox(2.0f, 0.0f, -8.0f, 6, 1, 6, 0.0f, false);
        this.main_exterior_corner.texOffs(20, 10).addBox(2.0f, -33.0f, -8.0f, 6, 1, 6, 0.0f, false);
        this.main_exterior_corner.texOffs(108, 68).addBox(2.0f, -32.0f, -3.0f, 1, 32, 1, 0.0f, false);
        this.main_light = new ModelMapper(modelDataWrapper);
        this.main_light.setPos(0.0f, 24.0f, 0.0f);
        this.main_light.texOffs(32, 0).addBox(-8.0f, -32.5f, -8.0f, 16, 0, 16, 0.0f, false);
        this.door = new ModelMapper(modelDataWrapper);
        this.door.setPos(0.0f, 24.0f, 0.0f);
        this.door.texOffs(90, 66).addBox(-16.0f, -32.0f, 4.0f, 4, 32, 3, 0.0f, false);
        this.door.texOffs(14, 84).addBox(12.0f, -32.0f, 4.0f, 4, 32, 3, 0.0f, false);
        this.door.texOffs(20, 101).addBox(-16.0f, 0.0f, 0.0f, 32, 0, 8, 0.0f, false);
        this.door.texOffs(20, 101).addBox(-16.0f, -32.0f, 0.0f, 32, 0, 8, 0.0f, false);
        this.door_left = new ModelMapper(modelDataWrapper);
        this.door_left.setPos(0.0f, 0.0f, 0.0f);
        this.door.addChild(this.door_left);
        this.door_left.texOffs(52, 68).addBox(-12.0f, -32.0f, 6.0f, 12, 32, 0, 0.0f, false);
        this.door_right = new ModelMapper(modelDataWrapper);
        this.door_right.setPos(0.0f, 0.0f, 0.0f);
        this.door.addChild(this.door_right);
        this.door_right.texOffs(28, 68).addBox(0.0f, -32.0f, 6.0f, 12, 32, 0, 0.0f, false);
        this.door_exterior = new ModelMapper(modelDataWrapper);
        this.door_exterior.setPos(0.0f, 24.0f, 0.0f);
        this.door_exterior.texOffs(0, 84).addBox(-16.0f, -32.0f, 4.0f, 4, 32, 3, 0.0f, false);
        this.door_exterior.texOffs(76, 66).addBox(12.0f, -32.0f, 4.0f, 4, 32, 3, 0.0f, false);
        this.door_exterior.texOffs(28, 109).addBox(-16.0f, 0.0f, 0.0f, 32, 1, 8, 0.0f, false);
        this.door_exterior.texOffs(0, 119).addBox(-16.0f, -33.0f, 0.0f, 32, 1, 8, 0.0f, false);
        this.door_left_exterior = new ModelMapper(modelDataWrapper);
        this.door_left_exterior.setPos(0.0f, 0.0f, 0.0f);
        this.door_exterior.addChild(this.door_left_exterior);
        this.door_left_exterior.texOffs(0, 50).addBox(-12.0f, -32.0f, 6.0f, 12, 32, 2, 0.0f, false);
        this.door_right_exterior = new ModelMapper(modelDataWrapper);
        this.door_right_exterior.setPos(0.0f, 0.0f, 0.0f);
        this.door_exterior.addChild(this.door_right_exterior);
        this.door_right_exterior.texOffs(48, 34).addBox(0.0f, -32.0f, 6.0f, 12, 32, 2, 0.0f, false);
        this.wall_patch = new ModelMapper(modelDataWrapper);
        this.wall_patch.setPos(0.0f, 24.0f, 0.0f);
        this.handrail_bottom_r2 = new ModelMapper(modelDataWrapper);
        this.handrail_bottom_r2.setPos(0.0f, 0.0f, 0.0f);
        this.wall_patch.addChild(this.handrail_bottom_r2);
        ModelLift1.setRotationAngle(this.handrail_bottom_r2, 0.0f, 1.5708f, 0.0f);
        this.handrail_bottom_r2.texOffs(30, 50).addBox(-4.0f, -2.0f, 12.0f, 4, 1, 1, 0.0f, false);
        this.handrail_bottom_r2.texOffs(32, 52).addBox(-4.0f, -13.0f, 12.0f, 4, 1, 1, 0.0f, false);
        this.handrail_bottom_r2.texOffs(107, 33).addBox(-4.0f, -32.0f, 13.0f, 4, 32, 1, 0.0f, false);
        this.handrail_bottom_r3 = new ModelMapper(modelDataWrapper);
        this.handrail_bottom_r3.setPos(0.0f, 0.0f, 0.0f);
        this.wall_patch.addChild(this.handrail_bottom_r3);
        ModelLift1.setRotationAngle(this.handrail_bottom_r3, 0.0f, -1.5708f, 0.0f);
        this.handrail_bottom_r3.texOffs(30, 50).addBox(0.0f, -2.0f, 12.0f, 4, 1, 1, 0.0f, false);
        this.handrail_bottom_r3.texOffs(32, 52).addBox(0.0f, -13.0f, 12.0f, 4, 1, 1, 0.0f, false);
        this.handrail_bottom_r3.texOffs(107, 33).addBox(0.0f, -32.0f, 13.0f, 4, 32, 1, 0.0f, false);
        modelDataWrapper.setModelPart(128, 128);
        this.main.setModelPart();
        this.main_edge.setModelPart();
        this.main_corner.setModelPart();
        this.main_exterior.setModelPart();
        this.main_exterior_edge.setModelPart();
        this.main_exterior_corner.setModelPart();
        this.main_light.setModelPart();
        this.door.setModelPart();
        this.door_left.setModelPart(this.door.name);
        this.door_right.setModelPart(this.door.name);
        this.door_exterior.setModelPart();
        this.door_left_exterior.setModelPart(this.door_exterior.name);
        this.door_right_exterior.setModelPart(this.door_exterior.name);
        this.wall_patch.setModelPart();
    }

    @Override
    protected void render(PoseStack matrices, VertexConsumer vertices, ModelTrainBase.RenderStage renderStage, int light, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, int currentCar, int trainCars, boolean head1IsFront, boolean renderDetails) {
        for (int i = 0; i <= this.width; ++i) {
            block5: for (int j = 0; j <= this.depth; ++j) {
                float x = ((float)i - (float)this.width / 2.0f) * 16.0f;
                float z = ((float)j - (float)this.depth / 2.0f) * 16.0f;
                boolean edge1X = i == 0;
                boolean edge2X = i == this.width;
                boolean edge1Z = j == 0;
                boolean edge2Z = j == this.depth;
                switch (renderStage) {
                    case LIGHTS: {
                        if (edge1X || edge2X || edge1Z || edge2Z) continue block5;
                        ModelTrainBase.renderOnce(this.main_light, matrices, vertices, light, x, z);
                        continue block5;
                    }
                    case INTERIOR: 
                    case EXTERIOR: {
                        ModelMapper mainCornerPiece;
                        ModelMapper mainPiece = renderStage == ModelTrainBase.RenderStage.INTERIOR ? this.main : this.main_exterior;
                        ModelMapper mainEdgePiece = renderStage == ModelTrainBase.RenderStage.INTERIOR ? this.main_edge : this.main_exterior_edge;
                        ModelMapper modelMapper = mainCornerPiece = renderStage == ModelTrainBase.RenderStage.INTERIOR ? this.main_corner : this.main_exterior_corner;
                        if (!(edge1X || edge2X || edge1Z || edge2Z)) {
                            ModelTrainBase.renderOnce(mainPiece, matrices, vertices, light, x, z);
                        }
                        if (edge1X && !edge2X && !edge1Z && !edge2Z) {
                            mainEdgePiece.render(matrices, vertices, x, z - 4.0f, -1.5707964f, light, OverlayTexture.f_118083_);
                            mainEdgePiece.render(matrices, vertices, x, z + 4.0f, -1.5707964f, light, OverlayTexture.f_118083_);
                        }
                        if (!edge1X && edge2X && !edge1Z && !edge2Z) {
                            mainEdgePiece.render(matrices, vertices, x, z - 4.0f, 1.5707964f, light, OverlayTexture.f_118083_);
                            mainEdgePiece.render(matrices, vertices, x, z + 4.0f, 1.5707964f, light, OverlayTexture.f_118083_);
                        }
                        if (!(edge1X || edge2X || edge1Z || !edge2Z || this.isDoubleSided)) {
                            ModelTrainBase.renderOnce(mainEdgePiece, matrices, vertices, light, x - 4.0f, z);
                            ModelTrainBase.renderOnce(mainEdgePiece, matrices, vertices, light, x + 4.0f, z);
                        }
                        if (!(!edge1X || edge2X || edge1Z || !edge2Z || this.width <= 2 && this.isDoubleSided)) {
                            mainCornerPiece.render(matrices, vertices, x, z, 0.0f, light, OverlayTexture.f_118083_);
                        }
                        if (!(edge1X || !edge2X || edge1Z || !edge2Z || this.width <= 2 && this.isDoubleSided)) {
                            mainCornerPiece.render(matrices, vertices, x, z, 1.5707964f, light, OverlayTexture.f_118083_);
                        }
                        if (edge1X && !edge2X && edge1Z && !edge2Z && this.width > 2) {
                            mainCornerPiece.render(matrices, vertices, x, z, -1.5707964f, light, OverlayTexture.f_118083_);
                        }
                        if (edge1X || !edge2X || !edge1Z || edge2Z || this.width <= 2) continue block5;
                        mainCornerPiece.render(matrices, vertices, x, z, (float)Math.PI, light, OverlayTexture.f_118083_);
                    }
                }
            }
        }
        if (renderStage == ModelTrainBase.RenderStage.INTERIOR || renderStage == ModelTrainBase.RenderStage.EXTERIOR) {
            ModelMapper doorLeftPiece = renderStage == ModelTrainBase.RenderStage.INTERIOR ? this.door_left : this.door_left_exterior;
            ModelMapper doorRightPiece = renderStage == ModelTrainBase.RenderStage.INTERIOR ? this.door_right : this.door_right_exterior;
            ModelMapper doorPiece = renderStage == ModelTrainBase.RenderStage.INTERIOR ? this.door : this.door_exterior;
            ModelMapper mainEdgePiece = renderStage == ModelTrainBase.RenderStage.INTERIOR ? this.main_edge : this.main_exterior_edge;
            doorLeftPiece.setOffset(-doorLeftZ, 0, 0.0f);
            doorRightPiece.setOffset(doorLeftZ, 0, 0.0f);
            ModelTrainBase.renderOnceFlipped(doorPiece, matrices, vertices, light, 8 - this.depth * 8);
            if (this.isDoubleSided) {
                doorLeftPiece.setOffset(-doorRightZ, 0, 0.0f);
                doorRightPiece.setOffset(doorRightZ, 0, 0.0f);
                ModelTrainBase.renderOnce(doorPiece, matrices, vertices, light, -8 + this.depth * 8);
            }
            if (renderStage == ModelTrainBase.RenderStage.INTERIOR && this.width == 2) {
                ModelTrainBase.renderOnceFlipped(this.wall_patch, matrices, vertices, light, 8 - this.depth * 8);
                if (this.isDoubleSided) {
                    ModelTrainBase.renderOnce(this.wall_patch, matrices, vertices, light, -8 + this.depth * 8);
                }
            }
            for (int i = 1; i < this.width - 2; ++i) {
                ModelTrainBase.renderOnceFlipped(mainEdgePiece, matrices, vertices, light, i * 8 - this.width * 8 + 4, -this.depth * 8);
                ModelTrainBase.renderOnceFlipped(mainEdgePiece, matrices, vertices, light, -i * 8 + this.width * 8 - 4, -this.depth * 8);
                if (!this.isDoubleSided) continue;
                ModelTrainBase.renderOnce(mainEdgePiece, matrices, vertices, light, i * 8 - this.width * 8 + 4, this.depth * 8);
                ModelTrainBase.renderOnce(mainEdgePiece, matrices, vertices, light, -i * 8 + this.width * 8 - 4, this.depth * 8);
            }
        }
    }

    @Override
    protected int[] getBogiePositions() {
        return new int[0];
    }

    @Override
    protected float getDoorAnimationX(float value, boolean opening) {
        return 0.0f;
    }

    @Override
    protected float getDoorAnimationZ(float value, boolean opening) {
        return value / 2.0f;
    }
}

