/*
 * Decompiled with CFR 0.152.
 */
package mtr.mappings;

import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.registry.CreativeTabRegistry;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.Utilities;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public interface RegistryUtilities {
    public static <T extends BlockEntityMapper> BlockEntityType<T> getBlockEntityType(Utilities.TileEntitySupplier<T> supplier, Block block) {
        return new BlockEntityType(supplier::supplier, Collections.singleton(block), null);
    }

    public static <T extends CommandRegistrationEvent> void registerCommand(T listener) {
        CommandRegistrationEvent.EVENT.register(listener);
    }

    public static void registerPlayerJoinEvent(Consumer<ServerPlayer> consumer) {
        PlayerEvent.PLAYER_JOIN.register(consumer::accept);
    }

    public static void registerPlayerQuitEvent(Consumer<ServerPlayer> consumer) {
        PlayerEvent.PLAYER_QUIT.register(consumer::accept);
    }

    public static void registerPlayerChangeDimensionEvent(Consumer<ServerPlayer> consumer) {
        PlayerEvent.CHANGE_DIMENSION.register((player, oldWorld, newWorld) -> consumer.accept(player));
    }

    public static void registerServerStartingEvent(Consumer<MinecraftServer> consumer) {
        LifecycleEvent.SERVER_STARTING.register(consumer::accept);
    }

    public static void registerServerStoppingEvent(Consumer<MinecraftServer> consumer) {
        LifecycleEvent.SERVER_STOPPING.register(consumer::accept);
    }

    public static void registerTickEvent(Consumer<MinecraftServer> consumer) {
        TickEvent.SERVER_PRE.register(consumer::accept);
    }

    public static CreativeModeTab createCreativeTab(ResourceLocation name, Supplier<ItemStack> icon) {
        return CreativeTabRegistry.create((ResourceLocation)name, icon);
    }
}

