/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import java.util.List;
import mtr.block.BlockNode;
import mtr.data.Rail;
import mtr.data.RailAngle;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import mtr.item.ItemNodeModifierBase;
import mtr.mappings.Text;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ItemRailModifier
extends ItemNodeModifierBase {
    private final boolean isOneWay;
    private final RailType railType;

    public ItemRailModifier() {
        super(true, true, false);
        this.isOneWay = false;
        this.railType = null;
    }

    public ItemRailModifier(boolean forNonContinuousMovementNode, boolean forContinuousMovementNode, boolean isOneWay, RailType railType) {
        super(forNonContinuousMovementNode, forContinuousMovementNode, true);
        this.isOneWay = isOneWay;
        this.railType = railType;
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (this.isConnector && this.railType != null && this.railType.canAccelerate) {
            tooltip.add((Component)Text.translatable("tooltip.mtr.rail_speed_limit", this.railType.speedLimit).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        }
        super.m_7373_(itemStack, level, tooltip, tooltipFlag);
    }

    @Override
    protected void onConnect(Level world, ItemStack stack, TransportMode transportMode, BlockState stateStart, BlockState stateEnd, BlockPos posStart, BlockPos posEnd, RailAngle facingStart, RailAngle facingEnd, Player player, RailwayData railwayData) {
        if (this.railType.hasSavedRail && (railwayData.hasSavedRail(posStart) || railwayData.hasSavedRail(posEnd))) {
            if (player != null) {
                player.m_5661_((Component)Text.translatable("gui.mtr.platform_or_siding_exists", new Object[0]), true);
            }
        } else {
            boolean isValid;
            RailType newRailType;
            boolean isValidContinuousMovement;
            if (transportMode.continuousMovement) {
                Block blockStart = stateStart.m_60734_();
                Block blockEnd = stateEnd.m_60734_();
                if (blockStart instanceof BlockNode.BlockContinuousMovementNode && blockEnd instanceof BlockNode.BlockContinuousMovementNode) {
                    if (((BlockNode.BlockContinuousMovementNode)blockStart).isStation && ((BlockNode.BlockContinuousMovementNode)blockEnd).isStation) {
                        isValidContinuousMovement = true;
                        newRailType = this.railType.hasSavedRail ? this.railType : RailType.CABLE_CAR_STATION;
                    } else {
                        int differenceX = posEnd.m_123341_() - posStart.m_123341_();
                        int differenceZ = posEnd.m_123343_() - posStart.m_123343_();
                        isValidContinuousMovement = !this.railType.hasSavedRail && facingStart.isParallel(facingEnd) && ((facingStart == RailAngle.N || facingStart == RailAngle.S) && differenceX == 0 || (facingStart == RailAngle.E || facingStart == RailAngle.W) && differenceZ == 0 || (facingStart == RailAngle.NE || facingStart == RailAngle.SW) && differenceX == -differenceZ || (facingStart == RailAngle.SE || facingStart == RailAngle.NW) && differenceX == differenceZ);
                        newRailType = RailType.CABLE_CAR;
                    }
                } else {
                    isValidContinuousMovement = false;
                    newRailType = this.railType;
                }
            } else {
                isValidContinuousMovement = true;
                newRailType = this.railType;
            }
            Rail rail1 = new Rail(posStart, facingStart, posEnd, facingEnd, this.isOneWay ? RailType.NONE : newRailType, transportMode);
            Rail rail2 = new Rail(posEnd, facingEnd, posStart, facingStart, newRailType, transportMode);
            boolean goodRadius = rail1.goodRadius() && rail2.goodRadius();
            boolean bl = isValid = rail1.isValid() && rail2.isValid();
            if (goodRadius && isValid && isValidContinuousMovement) {
                railwayData.addRail(transportMode, posStart, posEnd, rail1, false);
                long newId = railwayData.addRail(transportMode, posEnd, posStart, rail2, true);
                world.m_46597_(posStart, (BlockState)stateStart.m_61124_((Property)BlockNode.IS_CONNECTED, (Comparable)Boolean.valueOf(true)));
                world.m_46597_(posEnd, (BlockState)stateEnd.m_61124_((Property)BlockNode.IS_CONNECTED, (Comparable)Boolean.valueOf(true)));
                PacketTrainDataGuiServer.createRailS2C(world, transportMode, posStart, posEnd, rail1, rail2, newId);
            } else if (player != null) {
                player.m_5661_((Component)Text.translatable(isValidContinuousMovement ? (goodRadius ? "gui.mtr.invalid_orientation" : "gui.mtr.radius_too_small") : "gui.mtr.cable_car_invalid_orientation", new Object[0]), true);
            }
        }
    }

    @Override
    protected void onRemove(Level world, BlockPos posStart, BlockPos posEnd, RailwayData railwayData) {
        railwayData.removeRailConnection(posStart, posEnd);
        PacketTrainDataGuiServer.removeRailConnectionS2C(world, posStart, posEnd);
    }
}

