/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import mtr.Registry;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.RailwayDataModuleBase;
import mtr.data.Route;
import mtr.entity.EntitySeat;
import mtr.mappings.Utilities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RailwayDataCoolDownModule
extends RailwayDataModuleBase {
    private final Map<Player, Integer> playerRidingCoolDown = new HashMap<Player, Integer>();
    private final Map<Player, Long> playerRidingRoute = new HashMap<Player, Long>();
    private final Map<Player, EntitySeat> playerSeats = new HashMap<Player, EntitySeat>();
    private final Map<Player, Integer> playerSeatCoolDowns = new HashMap<Player, Integer>();

    public RailwayDataCoolDownModule(RailwayData railwayData, Level world, Map<BlockPos, Map<BlockPos, Rail>> rails) {
        super(railwayData, world, rails);
    }

    public void tick() {
        this.world.m_6907_().forEach(player -> {
            EntitySeat seat;
            Integer seatCoolDownOld = this.playerSeatCoolDowns.get(player);
            EntitySeat seatOld = this.playerSeats.get(player);
            if (seatCoolDownOld == null || seatCoolDownOld <= 0 || Utilities.entityRemoved(seatOld)) {
                seat = new EntitySeat(this.world, player.m_20185_(), player.m_20186_(), player.m_20189_());
                this.world.m_7967_((Entity)seat);
                seat.initialize((Player)player);
                this.playerSeats.put((Player)player, seat);
                this.playerSeatCoolDowns.put((Player)player, 3);
            } else {
                seat = this.playerSeats.get(player);
                this.playerSeatCoolDowns.put((Player)player, this.playerSeatCoolDowns.get(player) - 1);
            }
            seat.updateSeatByRailwayData((Player)player);
        });
        HashSet playersToRemove = new HashSet();
        this.playerRidingCoolDown.forEach((player, coolDown) -> {
            if (coolDown <= 0) {
                this.updatePlayerRiding((Player)player, 0L);
                playersToRemove.add(player);
                player.m_8127_();
            }
            this.playerRidingCoolDown.put((Player)player, coolDown - 1);
        });
        playersToRemove.forEach(player -> {
            this.playerRidingCoolDown.remove(player);
            this.playerRidingRoute.remove(player);
        });
    }

    public void onPlayerJoin(ServerPlayer serverPlayer) {
        this.playerRidingCoolDown.put((Player)serverPlayer, 2);
    }

    public void onPlayerDisconnect(Player player) {
        this.playerSeats.remove(player);
        this.playerSeatCoolDowns.remove(player);
    }

    public void updatePlayerRiding(Player player, long routeId) {
        boolean isRiding = routeId != 0L;
        player.f_19789_ = 0.0f;
        player.m_20242_(isRiding);
        player.f_19794_ = isRiding;
        if (isRiding) {
            Utilities.getAbilities((Player)player).f_35936_ = true;
            this.playerRidingCoolDown.put(player, 2);
            this.playerRidingRoute.put(player, routeId);
        } else {
            ((ServerPlayer)player).f_8941_.m_9290_().m_46398_(Utilities.getAbilities(player));
        }
        Registry.setInTeleportationState(player, isRiding);
    }

    public void updatePlayerSeatCoolDown(Player player) {
        this.playerSeatCoolDowns.put(player, 3);
    }

    public boolean canRide(Player player) {
        return !this.playerRidingCoolDown.containsKey(player);
    }

    public Route getRidingRoute(Player player) {
        if (this.playerRidingRoute.containsKey(player)) {
            return this.railwayData.dataCache.routeIdMap.get(this.playerRidingRoute.get(player));
        }
        return null;
    }

    public void moveSeat(Player player, double x, double y, double z) {
        EntitySeat entitySeat = this.playerSeats.get(player);
        if (entitySeat != null) {
            player.m_20329_((Entity)entitySeat);
            entitySeat.m_6034_(x, y, z);
        }
    }
}

