/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import mtr.data.MessagePackHelper;
import mtr.data.SavedRailBase;
import mtr.data.TransportMode;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public final class Platform
extends SavedRailBase {
    private int dwellTime;
    public static final int MAX_DWELL_TIME = 1200;
    private static final int DEFAULT_DWELL_TIME = 20;
    private static final String KEY_DWELL_TIME = "dwell_time";

    public Platform(long id, TransportMode transportMode, BlockPos pos1, BlockPos pos2) {
        super(id, transportMode, pos1, pos2);
        this.dwellTime = transportMode.continuousMovement ? 1 : 20;
    }

    public Platform(TransportMode transportMode, BlockPos pos1, BlockPos pos2) {
        super(transportMode, pos1, pos2);
        this.dwellTime = transportMode.continuousMovement ? 1 : 20;
    }

    public Platform(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.dwellTime = this.transportMode.continuousMovement ? 1 : messagePackHelper.getInt(KEY_DWELL_TIME);
    }

    @Deprecated
    public Platform(CompoundTag compoundTag) {
        super(compoundTag);
        this.dwellTime = this.transportMode.continuousMovement ? 1 : compoundTag.m_128451_(KEY_DWELL_TIME);
    }

    public Platform(FriendlyByteBuf packet) {
        super(packet);
        this.dwellTime = packet.readInt();
        this.dwellTime = this.transportMode.continuousMovement ? 1 : this.dwellTime;
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_DWELL_TIME).packInt(this.dwellTime);
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 1;
    }

    @Override
    public void writePacket(FriendlyByteBuf packet) {
        super.writePacket(packet);
        packet.writeInt(this.dwellTime);
    }

    @Override
    public void update(String key, FriendlyByteBuf packet) {
        if (KEY_DWELL_TIME.equals(key)) {
            this.name = packet.m_130136_(Short.MAX_VALUE);
            this.color = packet.readInt();
            this.dwellTime = packet.readInt();
            this.dwellTime = this.transportMode.continuousMovement ? 1 : this.dwellTime;
        } else {
            super.update(key, packet);
        }
    }

    public int getDwellTime() {
        if (this.dwellTime <= 0 || this.dwellTime > 1200) {
            this.dwellTime = 20;
        }
        return this.transportMode.continuousMovement ? 1 : this.dwellTime;
    }

    public void setDwellTime(int newDwellTime, Consumer<FriendlyByteBuf> sendPacket) {
        this.dwellTime = this.transportMode.continuousMovement ? 1 : (newDwellTime <= 0 || newDwellTime > 1200 ? 20 : newDwellTime);
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.m_130070_(this.transportMode.toString());
        packet.m_130070_(KEY_DWELL_TIME);
        packet.m_130070_(this.name);
        packet.writeInt(this.color);
        packet.writeInt(this.dwellTime);
        sendPacket.accept(packet);
    }
}

