/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mtr.data.AreaBase;
import mtr.data.DataCache;
import mtr.data.IReducedSaveData;
import mtr.data.MessagePackHelper;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.SavedRailBase;
import mtr.data.Siding;
import mtr.data.TrainServer;
import mtr.data.TransportMode;
import mtr.packet.PacketTrainDataGuiServer;
import mtr.path.PathData;
import mtr.path.PathFinder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;

public class Depot
extends AreaBase
implements IReducedSaveData {
    public int clientPathGenerationSuccessfulSegments;
    public long lastDeployedMillis;
    private int deployIndex;
    private int departureOffset;
    public final List<Long> routeIds = new ArrayList<Long>();
    public final Map<Long, Map<Long, Float>> platformTimes = new HashMap<Long, Map<Long, Float>>();
    private final int[] frequencies = new int[24];
    private final Map<Long, TrainServer> deployableSidings = new HashMap<Long, TrainServer>();
    public static final int HOURS_IN_DAY = 24;
    public static final int TRAIN_FREQUENCY_MULTIPLIER = 4;
    public static final int TICKS_PER_HOUR = 1000;
    public static final int MILLIS_PER_TICK = 50;
    private static final int TICKS_PER_DAY = 24000;
    private static final int MAX_DEPLOYED_MILLIS = 3600000;
    private static final int CONTINUOUS_MOVEMENT_FREQUENCY = 8000;
    private static final String KEY_ROUTE_IDS = "route_ids";
    private static final String KEY_FREQUENCIES = "frequencies";
    private static final String KEY_LAST_DEPLOYED = "last_deployed";
    private static final String KEY_DEPLOY_INDEX = "deploy_index";

    public Depot(TransportMode transportMode) {
        super(transportMode);
    }

    public Depot(long id, TransportMode transportMode) {
        super(id, transportMode);
    }

    public Depot(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        messagePackHelper.iterateArrayValue(KEY_ROUTE_IDS, routeId -> this.routeIds.add(routeId.asIntegerValue().asLong()));
        try {
            ArrayValue frequenciesArray = map.get(KEY_FREQUENCIES).asArrayValue();
            for (int i = 0; i < 24; ++i) {
                this.frequencies[i] = frequenciesArray.get(i).asIntegerValue().asInt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.deployIndex = messagePackHelper.getInt(KEY_DEPLOY_INDEX);
        this.lastDeployedMillis = System.currentTimeMillis() - messagePackHelper.getLong(KEY_LAST_DEPLOYED);
    }

    @Deprecated
    public Depot(CompoundTag compoundTag) {
        super(compoundTag);
        long[] routeIdsArray;
        for (long routeId : routeIdsArray = compoundTag.m_128467_(KEY_ROUTE_IDS)) {
            this.routeIds.add(routeId);
        }
        for (int i = 0; i < 24; ++i) {
            this.frequencies[i] = compoundTag.m_128451_(KEY_FREQUENCIES + i);
        }
        this.lastDeployedMillis = System.currentTimeMillis() - compoundTag.m_128454_(KEY_LAST_DEPLOYED);
        this.deployIndex = compoundTag.m_128451_(KEY_DEPLOY_INDEX);
    }

    public Depot(FriendlyByteBuf packet) {
        super(packet);
        int i;
        int routeIdCount = packet.readInt();
        for (i = 0; i < routeIdCount; ++i) {
            this.routeIds.add(packet.readLong());
        }
        for (i = 0; i < 24; ++i) {
            this.frequencies[i] = packet.readInt();
        }
        this.lastDeployedMillis = packet.readLong();
        this.deployIndex = packet.readInt();
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        this.toReducedMessagePack(messagePacker);
        messagePacker.packString(KEY_DEPLOY_INDEX).packInt(this.deployIndex);
        messagePacker.packString(KEY_LAST_DEPLOYED).packLong(System.currentTimeMillis() - this.lastDeployedMillis);
    }

    @Override
    public void toReducedMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_ROUTE_IDS).packArrayHeader(this.routeIds.size());
        for (Long routeId : this.routeIds) {
            messagePacker.packLong(routeId);
        }
        messagePacker.packString(KEY_FREQUENCIES).packArrayHeader(24);
        for (int i = 0; i < 24; ++i) {
            messagePacker.packInt(this.frequencies[i]);
        }
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 4;
    }

    @Override
    public int reducedMessagePackLength() {
        return this.messagePackLength() - 1;
    }

    @Override
    public void writePacket(FriendlyByteBuf packet) {
        super.writePacket(packet);
        packet.writeInt(this.routeIds.size());
        this.routeIds.forEach(arg_0 -> ((FriendlyByteBuf)packet).writeLong(arg_0));
        for (int frequency : this.frequencies) {
            packet.writeInt(frequency);
        }
        packet.writeLong(this.lastDeployedMillis);
        packet.writeInt(this.deployIndex);
    }

    @Override
    protected boolean hasTransportMode() {
        return true;
    }

    @Override
    public void update(String key, FriendlyByteBuf packet) {
        if (KEY_FREQUENCIES.equals(key)) {
            this.name = packet.m_130136_(Short.MAX_VALUE);
            this.color = packet.readInt();
            for (int i = 0; i < 24; ++i) {
                this.frequencies[i] = packet.readInt();
            }
            this.routeIds.clear();
            int routeIdCount = packet.readInt();
            for (int i = 0; i < routeIdCount; ++i) {
                this.routeIds.add(packet.readLong());
            }
        } else {
            super.update(key, packet);
        }
    }

    public int getFrequency(int index) {
        if (index >= 0 && index < this.frequencies.length) {
            return this.frequencies[index];
        }
        return 0;
    }

    public void setFrequency(int newFrequency, int index) {
        if (index >= 0 && index < this.frequencies.length) {
            this.frequencies[index] = newFrequency;
        }
    }

    public void setData(Consumer<FriendlyByteBuf> sendPacket) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.m_130070_(this.transportMode.toString());
        packet.m_130070_(KEY_FREQUENCIES);
        packet.m_130070_(this.name);
        packet.writeInt(this.color);
        for (int frequency : this.frequencies) {
            packet.writeInt(frequency);
        }
        packet.writeInt(this.routeIds.size());
        this.routeIds.forEach(arg_0 -> ((FriendlyByteBuf)packet).writeLong(arg_0));
        sendPacket.accept(packet);
    }

    public void generateMainRoute(MinecraftServer minecraftServer, Level world, DataCache dataCache, Map<BlockPos, Map<BlockPos, Rail>> rails, Set<Siding> sidings, Consumer<Thread> callback) {
        ArrayList platformsInRoute = new ArrayList();
        this.routeIds.forEach(routeId -> {
            Route route = dataCache.routeIdMap.get(routeId);
            if (route != null) {
                route.platformIds.forEach(platformId -> {
                    Platform platform = dataCache.platformIdMap.get(platformId);
                    if (platform != null && (platformsInRoute.isEmpty() || platform.id != ((SavedRailBase)platformsInRoute.get((int)(platformsInRoute.size() - 1))).id)) {
                        platformsInRoute.add(platform);
                    }
                });
            }
        });
        Thread thread = new Thread(() -> {
            try {
                ArrayList<PathData> tempPath = new ArrayList<PathData>();
                int successfulSegmentsMain = PathFinder.findPath(tempPath, rails, platformsInRoute, 1);
                int[] successfulSegments = new int[]{Integer.MAX_VALUE};
                sidings.forEach(siding -> {
                    SavedRailBase lastPlatform;
                    SavedRailBase firstPlatform;
                    int result;
                    BlockPos sidingMidPos = siding.getMidPos();
                    if (siding.isTransportMode(this.transportMode) && this.inArea(sidingMidPos.m_123341_(), sidingMidPos.m_123343_()) && (result = siding.generateRoute(minecraftServer, tempPath, successfulSegmentsMain, rails, firstPlatform = platformsInRoute.isEmpty() ? null : (SavedRailBase)platformsInRoute.get(0), lastPlatform = platformsInRoute.isEmpty() ? null : (SavedRailBase)platformsInRoute.get(platformsInRoute.size() - 1))) < successfulSegments[0]) {
                        successfulSegments[0] = result;
                    }
                });
                PacketTrainDataGuiServer.generatePathS2C(world, this.id, successfulSegments[0]);
                System.out.println("Finished path generation" + (String)(this.name.isEmpty() ? "" : " for " + this.name));
            }
            catch (Exception e) {
                e.printStackTrace();
                PacketTrainDataGuiServer.generatePathS2C(world, this.id, 0);
                System.out.println("Failed to generate path" + (String)(this.name.isEmpty() ? "" : " for " + this.name));
            }
        });
        callback.accept(thread);
        thread.start();
    }

    public void requestDeploy(long sidingId, TrainServer train) {
        this.deployableSidings.put(sidingId, train);
    }

    public void deployTrain(RailwayData railwayData, int hour) {
        if (!this.deployableSidings.isEmpty() && this.getMillisUntilDeploy(hour, 1) == 0) {
            List sidingsInDepot = railwayData.sidings.stream().filter(siding -> {
                BlockPos sidingPos = siding.getMidPos();
                return siding.isTransportMode(this.transportMode) && this.inArea(sidingPos.m_123341_(), sidingPos.m_123343_());
            }).sorted().collect(Collectors.toList());
            int sidingsInDepotSize = sidingsInDepot.size();
            for (int i = this.deployIndex; i < this.deployIndex + sidingsInDepotSize; ++i) {
                TrainServer train = this.deployableSidings.get(((Siding)sidingsInDepot.get((int)(i % sidingsInDepotSize))).id);
                if (train == null) continue;
                this.lastDeployedMillis = System.currentTimeMillis();
                ++this.deployIndex;
                if (this.deployIndex >= sidingsInDepotSize) {
                    this.deployIndex = 0;
                }
                train.deployTrain();
                break;
            }
        }
        this.departureOffset = 0;
        this.deployableSidings.clear();
    }

    public int getNextDepartureTicks(int hour) {
        ++this.departureOffset;
        int millisUntilDeploy = this.getMillisUntilDeploy(hour, this.departureOffset);
        return millisUntilDeploy >= 0 ? millisUntilDeploy / 50 : -1;
    }

    private int getMillisUntilDeploy(int hour, int offset) {
        for (int i = hour; i < hour + 24; ++i) {
            int frequency;
            int n = this.transportMode.continuousMovement ? 8000 : (frequency = this.frequencies[i % 24] > 0 ? 200000 / this.frequencies[i % 24] : 0);
            if (frequency <= 0) continue;
            return Math.max(frequency * offset - (int)Math.min(System.currentTimeMillis() - this.lastDeployedMillis, 3600000L), 0) + (i - hour) * 1000 * 50;
        }
        return -1;
    }

    public static int getHour(Level world) {
        return (int)Depot.wrapTime(world.m_46468_()) / 1000;
    }

    private static float wrapTime(float time) {
        return (time + 6000.0f + 24000.0f) % 24000.0f;
    }
}

