/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import mtr.MTRClient;
import mtr.data.TrainType;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import mtr.model.ModelATrain;
import mtr.model.ModelATrainMini;
import mtr.model.ModelATrainSmall;
import mtr.model.ModelCMStock;
import mtr.model.ModelCMStockMini;
import mtr.model.ModelCMStockSmall;
import mtr.model.ModelCTrain;
import mtr.model.ModelCTrainMini;
import mtr.model.ModelCTrainSmall;
import mtr.model.ModelClass802;
import mtr.model.ModelClass802Mini;
import mtr.model.ModelDRL;
import mtr.model.ModelE44;
import mtr.model.ModelE44Mini;
import mtr.model.ModelKTrain;
import mtr.model.ModelKTrainMini;
import mtr.model.ModelKTrainSmall;
import mtr.model.ModelLightRail;
import mtr.model.ModelLondonUnderground1995;
import mtr.model.ModelLondonUndergroundD78;
import mtr.model.ModelLondonUndergroundD78Mini;
import mtr.model.ModelMLR;
import mtr.model.ModelMLRMini;
import mtr.model.ModelMLRSmall;
import mtr.model.ModelMTrain;
import mtr.model.ModelMTrainMini;
import mtr.model.ModelMTrainSmall;
import mtr.model.ModelNgongPing360;
import mtr.model.ModelR179;
import mtr.model.ModelR179Mini;
import mtr.model.ModelR211;
import mtr.model.ModelR211Mini;
import mtr.model.ModelRTrain;
import mtr.model.ModelRTrainMini;
import mtr.model.ModelRTrainSmall;
import mtr.model.ModelSP1900;
import mtr.model.ModelSP1900Mini;
import mtr.model.ModelSP1900Small;
import mtr.model.ModelSTrain;
import mtr.model.ModelSTrainMini;
import mtr.model.ModelSTrainSmall;
import mtr.model.ModelTrainBase;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public class TrainClientRegistry {
    private static final Map<String, TrainProperties> REGISTRY = new HashMap<String, TrainProperties>();
    private static final Map<TransportMode, List<String>> KEY_ORDERS = new HashMap<TransportMode, List<String>>();
    private static final String SOUND_ACCELERATION = "_acceleration_";
    private static final String SOUND_DECELERATION = "_deceleration_";
    private static final String SOUND_DOOR_OPEN = "_door_open";
    private static final String SOUND_DOOR_CLOSE = "_door_close";
    private static final String SOUND_RANDOM = "_random";
    private static final int RANDOM_SOUND_CHANCE = 300;

    private static void register(TrainType defaultTrainType, ModelTrainBase model, String textureId, String speedSoundBaseId, String doorSoundBaseId, int color, String gangwayConnectionId, String trainBarrierId, float riderOffset, int speedSoundCount, float doorCloseSoundTime, boolean useAccelerationSoundsWhenCoasting) {
        TrainClientRegistry.register(defaultTrainType.toString(), defaultTrainType.baseTrainType, model, textureId, speedSoundBaseId, doorSoundBaseId, null, color, gangwayConnectionId, trainBarrierId, riderOffset, speedSoundCount, doorCloseSoundTime, useAccelerationSoundsWhenCoasting);
    }

    public static void register(String key, String baseTrainType, ModelTrainBase model, String textureId, String speedSoundBaseId, String doorSoundBaseId, String name, int color, String gangwayConnectionId, String trainBarrierId, float riderOffset, int speedSoundCount, float doorCloseSoundTime, boolean useAccelerationSoundsWhenCoasting) {
        String keyLower = key.toLowerCase();
        TransportMode transportMode = TrainType.getTransportMode(baseTrainType);
        if (!KEY_ORDERS.containsKey((Object)transportMode)) {
            KEY_ORDERS.put(transportMode, new ArrayList());
        }
        if (!KEY_ORDERS.get((Object)transportMode).contains(keyLower)) {
            KEY_ORDERS.get((Object)transportMode).add(keyLower);
        }
        REGISTRY.put(keyLower, new TrainProperties(baseTrainType, model, textureId, speedSoundBaseId, doorSoundBaseId, (Component)Text.translatable((String)(name == null ? "train.mtr." + keyLower : name), new Object[0]), color, gangwayConnectionId, trainBarrierId, riderOffset, speedSoundCount, doorCloseSoundTime, useAccelerationSoundsWhenCoasting));
    }

    public static void reset() {
        REGISTRY.clear();
        KEY_ORDERS.clear();
        TrainClientRegistry.register(TrainType.SP1900, new ModelSP1900(false), "mtr:textures/entity/sp1900", "sp1900", "sp1900", 13209, "mtr:textures/entity/sp1900", "", 0.0f, 120, 0.5f, false);
        TrainClientRegistry.register(TrainType.SP1900_SMALL, new ModelSP1900Small(false), "mtr:textures/entity/sp1900", "sp1900", "sp1900", 13209, "mtr:textures/entity/sp1900", "", 0.0f, 120, 0.5f, false);
        TrainClientRegistry.register(TrainType.SP1900_MINI, new ModelSP1900Mini(false), "mtr:textures/entity/sp1900", "sp1900", "sp1900", 13209, "mtr:textures/entity/sp1900", "", 0.0f, 120, 0.5f, false);
        TrainClientRegistry.register(TrainType.C1141A, new ModelSP1900(true), "mtr:textures/entity/c1141a", "c1141a", "sp1900", 11805257, "mtr:textures/entity/sp1900", "", 0.0f, 96, 0.5f, false);
        TrainClientRegistry.register(TrainType.C1141A_SMALL, new ModelSP1900Small(true), "mtr:textures/entity/c1141a", "c1141a", "sp1900", 11805257, "mtr:textures/entity/sp1900", "", 0.0f, 96, 0.5f, false);
        TrainClientRegistry.register(TrainType.C1141A_MINI, new ModelSP1900Mini(true), "mtr:textures/entity/c1141a", "c1141a", "sp1900", 11805257, "mtr:textures/entity/sp1900", "", 0.0f, 96, 0.5f, false);
        TrainClientRegistry.register(TrainType.M_TRAIN, new ModelMTrain(), "mtr:textures/entity/m_train", "m_train", "m_train", 0x999999, "mtr:textures/entity/m_train", "", 0.0f, 90, 0.5f, false);
        TrainClientRegistry.register(TrainType.M_TRAIN_SMALL, new ModelMTrainSmall(), "mtr:textures/entity/m_train", "m_train", "m_train", 0x999999, "mtr:textures/entity/m_train", "", 0.0f, 90, 0.5f, false);
        TrainClientRegistry.register(TrainType.M_TRAIN_MINI, new ModelMTrainMini(), "mtr:textures/entity/m_train", "m_train", "m_train", 0x999999, "mtr:textures/entity/m_train", "", 0.0f, 90, 0.5f, false);
        TrainClientRegistry.register(TrainType.CM_STOCK, new ModelCMStock(), "mtr:textures/entity/cm_stock", "m_train", "m_train", 0x999999, "mtr:textures/entity/m_train", "", 0.0f, 90, 0.5f, false);
        TrainClientRegistry.register(TrainType.CM_STOCK_SMALL, new ModelCMStockSmall(), "mtr:textures/entity/cm_stock", "m_train", "m_train", 0x999999, "mtr:textures/entity/m_train", "", 0.0f, 90, 0.5f, false);
        TrainClientRegistry.register(TrainType.CM_STOCK_MINI, new ModelCMStockMini(), "mtr:textures/entity/cm_stock", "m_train", "m_train", 0x999999, "mtr:textures/entity/m_train", "", 0.0f, 90, 0.5f, false);
        TrainClientRegistry.register(TrainType.MLR, new ModelMLR(), "mtr:textures/entity/mlr", "mlr", "mlr", 7124450, "mtr:textures/entity/m_train", "mtr:textures/entity/mlr", 0.0f, 93, 0.5f, true);
        TrainClientRegistry.register(TrainType.MLR_SMALL, new ModelMLRSmall(), "mtr:textures/entity/mlr", "mlr", "mlr", 7124450, "mtr:textures/entity/m_train", "mtr:textures/entity/mlr", 0.0f, 93, 0.5f, true);
        TrainClientRegistry.register(TrainType.MLR_MINI, new ModelMLRMini(), "mtr:textures/entity/mlr", "mlr", "mlr", 7124450, "mtr:textures/entity/m_train", "mtr:textures/entity/mlr", 0.0f, 93, 0.5f, true);
        TrainClientRegistry.register(TrainType.E44, new ModelE44(), "mtr:textures/entity/e44", "mlr", "m_train", 15183653, "mtr:textures/entity/m_train", "", 0.0f, 93, 0.5f, true);
        TrainClientRegistry.register(TrainType.E44_MINI, new ModelE44Mini(), "mtr:textures/entity/e44", "mlr", "m_train", 15183653, "mtr:textures/entity/m_train", "", 0.0f, 93, 0.5f, true);
        TrainClientRegistry.register(TrainType.R_TRAIN, new ModelRTrain(), "mtr:textures/entity/r_train", "c1141a", "sp1900", 7124450, "mtr:textures/entity/sp1900", "mtr:textures/entity/mlr", 0.0f, 96, 0.5f, false);
        TrainClientRegistry.register(TrainType.R_TRAIN_SMALL, new ModelRTrainSmall(), "mtr:textures/entity/r_train", "c1141a", "sp1900", 7124450, "mtr:textures/entity/sp1900", "mtr:textures/entity/mlr", 0.0f, 96, 0.5f, false);
        TrainClientRegistry.register(TrainType.R_TRAIN_MINI, new ModelRTrainMini(), "mtr:textures/entity/r_train", "c1141a", "sp1900", 7124450, "mtr:textures/entity/sp1900", "mtr:textures/entity/mlr", 0.0f, 96, 0.5f, false);
        TrainClientRegistry.register(TrainType.DRL, new ModelDRL(), "mtr:textures/entity/drl", "m_train", null, 15894455, "mtr:textures/entity/m_train", "", 0.0f, 90, 0.5f, false);
        TrainClientRegistry.register(TrainType.K_TRAIN, new ModelKTrain(false), "mtr:textures/entity/k_train", "k_train", "k_train", 961362, "mtr:textures/entity/k_train", "", 0.0f, 66, 1.0f, false);
        TrainClientRegistry.register(TrainType.K_TRAIN_SMALL, new ModelKTrainSmall(false), "mtr:textures/entity/k_train", "k_train", "k_train", 961362, "mtr:textures/entity/k_train", "", 0.0f, 66, 1.0f, false);
        TrainClientRegistry.register(TrainType.K_TRAIN_MINI, new ModelKTrainMini(false), "mtr:textures/entity/k_train", "k_train", "k_train", 961362, "mtr:textures/entity/k_train", "", 0.0f, 66, 1.0f, false);
        TrainClientRegistry.register(TrainType.K_TRAIN_TCL, new ModelKTrain(true), "mtr:textures/entity/k_train_tcl", "k_train", "k_train", 961362, "mtr:textures/entity/k_train", "", 0.0f, 66, 1.0f, false);
        TrainClientRegistry.register(TrainType.K_TRAIN_TCL_SMALL, new ModelKTrainSmall(true), "mtr:textures/entity/k_train_tcl", "k_train", "k_train", 961362, "mtr:textures/entity/k_train", "", 0.0f, 66, 1.0f, false);
        TrainClientRegistry.register(TrainType.K_TRAIN_TCL_MINI, new ModelKTrainMini(true), "mtr:textures/entity/k_train_tcl", "k_train", "k_train", 961362, "mtr:textures/entity/k_train", "", 0.0f, 66, 1.0f, false);
        TrainClientRegistry.register(TrainType.K_TRAIN_AEL, new ModelKTrain(true), "mtr:textures/entity/k_train_ael", "k_train", "k_train", 961362, "mtr:textures/entity/k_train", "", 0.0f, 66, 1.0f, false);
        TrainClientRegistry.register(TrainType.K_TRAIN_AEL_SMALL, new ModelKTrainSmall(true), "mtr:textures/entity/k_train_ael", "k_train", "k_train", 961362, "mtr:textures/entity/k_train", "", 0.0f, 66, 1.0f, false);
        TrainClientRegistry.register(TrainType.K_TRAIN_AEL_MINI, new ModelKTrainMini(true), "mtr:textures/entity/k_train_ael", "k_train", "k_train", 961362, "mtr:textures/entity/k_train", "", 0.0f, 66, 1.0f, false);
        TrainClientRegistry.register(TrainType.C_TRAIN, new ModelCTrain(), "mtr:textures/entity/c_train", "c_train", "sp1900", 16636160, "mtr:textures/entity/s_train", "", 0.0f, 69, 0.5f, false);
        TrainClientRegistry.register(TrainType.C_TRAIN_SMALL, new ModelCTrainSmall(), "mtr:textures/entity/c_train", "c_train", "sp1900", 16636160, "mtr:textures/entity/s_train", "", 0.0f, 69, 0.5f, false);
        TrainClientRegistry.register(TrainType.C_TRAIN_MINI, new ModelCTrainMini(), "mtr:textures/entity/c_train", "c_train", "sp1900", 16636160, "mtr:textures/entity/s_train", "", 0.0f, 69, 0.5f, false);
        TrainClientRegistry.register(TrainType.S_TRAIN, new ModelSTrain(), "mtr:textures/entity/s_train", "s_train", "sp1900", 12700963, "mtr:textures/entity/s_train", "", 0.0f, 42, 0.5f, false);
        TrainClientRegistry.register(TrainType.S_TRAIN_SMALL, new ModelSTrainSmall(), "mtr:textures/entity/s_train", "s_train", "sp1900", 12700963, "mtr:textures/entity/s_train", "", 0.0f, 42, 0.5f, false);
        TrainClientRegistry.register(TrainType.S_TRAIN_MINI, new ModelSTrainMini(), "mtr:textures/entity/s_train", "s_train", "sp1900", 12700963, "mtr:textures/entity/s_train", "", 0.0f, 42, 0.5f, false);
        TrainClientRegistry.register(TrainType.A_TRAIN_TCL, new ModelATrain(false), "mtr:textures/entity/a_train_tcl", "a_train", "a_train", 16159815, "mtr:textures/entity/a_train", "", 0.0f, 78, 0.5f, false);
        TrainClientRegistry.register(TrainType.A_TRAIN_TCL_SMALL, new ModelATrainSmall(false), "mtr:textures/entity/a_train_tcl", "a_train", "a_train", 16159815, "mtr:textures/entity/a_train", "", 0.0f, 78, 0.5f, false);
        TrainClientRegistry.register(TrainType.A_TRAIN_TCL_MINI, new ModelATrainMini(false), "mtr:textures/entity/a_train_tcl", "a_train", "a_train", 16159815, "mtr:textures/entity/a_train", "", 0.0f, 78, 0.5f, false);
        TrainClientRegistry.register(TrainType.A_TRAIN_AEL, new ModelATrain(true), "mtr:textures/entity/a_train_ael", "a_train", "a_train", 36237, "mtr:textures/entity/a_train", "", 0.0f, 78, 0.5f, false);
        TrainClientRegistry.register(TrainType.A_TRAIN_AEL_MINI, new ModelATrainMini(true), "mtr:textures/entity/a_train_ael", "a_train", "a_train", 36237, "mtr:textures/entity/a_train", "", 0.0f, 78, 0.5f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_1, new ModelLightRail(1, false), "mtr:textures/entity/light_rail_1", "light_rail_aeg", "light_rail_1", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_1_RHT, new ModelLightRail(1, true), "mtr:textures/entity/light_rail_1", "light_rail_aeg", "light_rail_1", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_1R, new ModelLightRail(4, false), "mtr:textures/entity/light_rail_1r", "light_rail_aeg", "light_rail_1", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_1R_RHT, new ModelLightRail(4, true), "mtr:textures/entity/light_rail_1r", "light_rail_aeg", "light_rail_1", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_2, new ModelLightRail(2, false), "mtr:textures/entity/light_rail_2", "light_rail_aeg", "light_rail_3", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_2_RHT, new ModelLightRail(2, true), "mtr:textures/entity/light_rail_2", "light_rail_aeg", "light_rail_3", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_3, new ModelLightRail(3, false), "mtr:textures/entity/light_rail_3", "light_rail_mitsubishi", "light_rail_3", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_3_RHT, new ModelLightRail(3, true), "mtr:textures/entity/light_rail_3", "light_rail_mitsubishi", "light_rail_3", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_4, new ModelLightRail(4, false), "mtr:textures/entity/light_rail_4", "light_rail_mitsubishi", "light_rail_4", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_4_RHT, new ModelLightRail(4, true), "mtr:textures/entity/light_rail_4", "light_rail_mitsubishi", "light_rail_4", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_5, new ModelLightRail(5, false), "mtr:textures/entity/light_rail_5", "light_rail_mitsubishi", "light_rail_4", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_5_RHT, new ModelLightRail(5, true), "mtr:textures/entity/light_rail_5", "light_rail_mitsubishi", "light_rail_4", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_1R_OLD, new ModelLightRail(4, false), "mtr:textures/entity/light_rail_1r_old", "light_rail_aeg", "light_rail_1", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_1R_OLD_RHT, new ModelLightRail(4, true), "mtr:textures/entity/light_rail_1r_old", "light_rail_aeg", "light_rail_1", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_4_OLD, new ModelLightRail(4, false), "mtr:textures/entity/light_rail_4_old", "light_rail_mitsubishi", "light_rail_4", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_4_OLD_RHT, new ModelLightRail(4, true), "mtr:textures/entity/light_rail_4_old", "light_rail_mitsubishi", "light_rail_4", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_5_OLD, new ModelLightRail(5, false), "mtr:textures/entity/light_rail_5_old", "light_rail_mitsubishi", "light_rail_4", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_5_OLD_RHT, new ModelLightRail(5, true), "mtr:textures/entity/light_rail_5_old", "light_rail_mitsubishi", "light_rail_4", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_1_ORANGE, new ModelLightRail(1, false), "mtr:textures/entity/light_rail_1_orange", "light_rail_aeg", "light_rail_1", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_1_ORANGE_RHT, new ModelLightRail(1, true), "mtr:textures/entity/light_rail_1_orange", "light_rail_aeg", "light_rail_1", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_1R_ORANGE, new ModelLightRail(4, false), "mtr:textures/entity/light_rail_1r_orange", "light_rail_aeg", "light_rail_1", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_1R_ORANGE_RHT, new ModelLightRail(4, true), "mtr:textures/entity/light_rail_1r_orange", "light_rail_aeg", "light_rail_1", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_2_ORANGE, new ModelLightRail(2, false), "mtr:textures/entity/light_rail_2_orange", "light_rail_aeg", "light_rail_3", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_2_ORANGE_RHT, new ModelLightRail(2, true), "mtr:textures/entity/light_rail_2_orange", "light_rail_aeg", "light_rail_3", 13805605, "", "", 0.0f, 48, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_3_ORANGE, new ModelLightRail(3, false), "mtr:textures/entity/light_rail_3_orange", "light_rail_mitsubishi", "light_rail_3", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_3_ORANGE_RHT, new ModelLightRail(3, true), "mtr:textures/entity/light_rail_3_orange", "light_rail_mitsubishi", "light_rail_3", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_4_ORANGE, new ModelLightRail(4, false), "mtr:textures/entity/light_rail_4_orange", "light_rail_mitsubishi", "light_rail_4", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_4_ORANGE_RHT, new ModelLightRail(4, true), "mtr:textures/entity/light_rail_4_orange", "light_rail_mitsubishi", "light_rail_4", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_5_ORANGE, new ModelLightRail(5, false), "mtr:textures/entity/light_rail_5_orange", "light_rail_mitsubishi", "light_rail_4", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LIGHT_RAIL_5_ORANGE_RHT, new ModelLightRail(5, true), "mtr:textures/entity/light_rail_5_orange", "light_rail_mitsubishi", "light_rail_4", 13805605, "", "", 0.0f, 45, 1.0f, false);
        TrainClientRegistry.register(TrainType.LONDON_UNDERGROUND_D78, new ModelLondonUndergroundD78(), "mtr:textures/entity/london_underground_d78", "mlr", "london_underground_d78", 29225, "", "mtr:textures/entity/london_underground_d78", 0.0f, 93, 1.0f, true);
        TrainClientRegistry.register(TrainType.LONDON_UNDERGROUND_D78_MINI, new ModelLondonUndergroundD78Mini(), "mtr:textures/entity/london_underground_d78", "mlr", "london_underground_d78", 29225, "", "mtr:textures/entity/london_underground_d78", 0.0f, 93, 1.0f, true);
        TrainClientRegistry.register(TrainType.LONDON_UNDERGROUND_1995, new ModelLondonUnderground1995(), "mtr:textures/entity/london_underground_1995", "london_underground_1995", "london_underground_1995", 0x333333, "", "", 0.0f, 72, 0.5f, false);
        TrainClientRegistry.register(TrainType.LONDON_UNDERGROUND_1996, new ModelLondonUnderground1995(), "mtr:textures/entity/london_underground_1996", "london_underground_1996", "london_underground_1995", 10593703, "", "", 0.0f, 93, 0.5f, false);
        TrainClientRegistry.register(TrainType.R179, new ModelR179(), "mtr:textures/entity/r179", "r179", "r179", 0xD5D5D5, "", "mtr:textures/entity/r179", 0.0f, 66, 1.0f, false);
        TrainClientRegistry.register(TrainType.R179_MINI, new ModelR179Mini(), "mtr:textures/entity/r179", "r179", "r179", 0xD5D5D5, "", "mtr:textures/entity/r179", 0.0f, 66, 1.0f, false);
        TrainClientRegistry.register(TrainType.R211, new ModelR211(false), "mtr:textures/entity/r211", "s_train", "r179", 0xD5D5D5, "", "mtr:textures/entity/r179", 0.0f, 42, 1.0f, false);
        TrainClientRegistry.register(TrainType.R211_MINI, new ModelR211Mini(false), "mtr:textures/entity/r211", "s_train", "r179", 0xD5D5D5, "", "mtr:textures/entity/r179", 0.0f, 42, 1.0f, false);
        TrainClientRegistry.register(TrainType.R211T, new ModelR211(true), "mtr:textures/entity/r211", "s_train", "r179", 0xD5D5D5, "mtr:textures/entity/r211", "mtr:textures/entity/r179", 0.0f, 42, 1.0f, false);
        TrainClientRegistry.register(TrainType.R211T_MINI, new ModelR211Mini(true), "mtr:textures/entity/r211", "s_train", "r179", 0xD5D5D5, "mtr:textures/entity/r211", "mtr:textures/entity/r179", 0.0f, 42, 1.0f, false);
        TrainClientRegistry.register(TrainType.CLASS_802_GWR, new ModelClass802(), "mtr:textures/entity/class_802_gwr", "class_802", "class_802", 138773, "mtr:textures/entity/sp1900", "", 0.0f, 120, 1.0f, false);
        TrainClientRegistry.register(TrainType.CLASS_802_GWR_MINI, new ModelClass802Mini(), "mtr:textures/entity/class_802_gwr", "class_802", "class_802", 138773, "mtr:textures/entity/sp1900", "", 0.0f, 120, 1.0f, false);
        TrainClientRegistry.register(TrainType.CLASS_802_TPE, new ModelClass802(), "mtr:textures/entity/class_802_tpe", "class_802", "class_802", 42726, "mtr:textures/entity/sp1900", "", 0.0f, 120, 1.0f, false);
        TrainClientRegistry.register(TrainType.CLASS_802_TPE_MINI, new ModelClass802Mini(), "mtr:textures/entity/class_802_tpe", "class_802", "class_802", 42726, "mtr:textures/entity/sp1900", "", 0.0f, 120, 1.0f, false);
        TrainClientRegistry.register(TrainType.MINECART, null, "textures/entity/minecart", null, null, 0x666666, "", "", -0.5f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.OAK_BOAT, null, "textures/entity/boat/oak", null, null, 9402184, "", "", -0.5f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.SPRUCE_BOAT, null, "textures/entity/boat/spruce", null, null, 9402184, "", "", -0.5f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.BIRCH_BOAT, null, "textures/entity/boat/birch", null, null, 9402184, "", "", -0.5f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.JUNGLE_BOAT, null, "textures/entity/boat/jungle", null, null, 9402184, "", "", -0.5f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.ACACIA_BOAT, null, "textures/entity/boat/acacia", null, null, 9402184, "", "", -0.5f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.DARK_OAK_BOAT, null, "textures/entity/boat/dark_oak", null, null, 9402184, "", "", -0.5f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.NGONG_PING_360_CRYSTAL, new ModelNgongPing360(false), "mtr:textures/entity/ngong_ping_360_crystal", null, null, 402752, "", "", 0.0f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.NGONG_PING_360_CRYSTAL_RHT, new ModelNgongPing360(true), "mtr:textures/entity/ngong_ping_360_crystal", null, null, 402752, "", "", 0.0f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.NGONG_PING_360_NORMAL_RED, new ModelNgongPing360(false), "mtr:textures/entity/ngong_ping_360_normal_red", null, null, 402752, "", "", 0.0f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.NGONG_PING_360_NORMAL_RED_RHT, new ModelNgongPing360(true), "mtr:textures/entity/ngong_ping_360_normal_red", null, null, 402752, "", "", 0.0f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.NGONG_PING_360_NORMAL_ORANGE, new ModelNgongPing360(false), "mtr:textures/entity/ngong_ping_360_normal_orange", null, null, 402752, "", "", 0.0f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.NGONG_PING_360_NORMAL_ORANGE_RHT, new ModelNgongPing360(true), "mtr:textures/entity/ngong_ping_360_normal_orange", null, null, 402752, "", "", 0.0f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.NGONG_PING_360_NORMAL_LIGHT_BLUE, new ModelNgongPing360(false), "mtr:textures/entity/ngong_ping_360_normal_light_blue", null, null, 402752, "", "", 0.0f, 0, 0.5f, false);
        TrainClientRegistry.register(TrainType.NGONG_PING_360_NORMAL_LIGHT_BLUE_RHT, new ModelNgongPing360(true), "mtr:textures/entity/ngong_ping_360_normal_light_blue", null, null, 402752, "", "", 0.0f, 0, 0.5f, false);
    }

    public static TrainProperties getTrainProperties(String key) {
        String keyLower = key.toLowerCase();
        return REGISTRY.containsKey(keyLower) ? REGISTRY.get(keyLower) : TrainClientRegistry.getBlankProperties();
    }

    public static TrainProperties getTrainProperties(TransportMode transportMode, int index) {
        return index >= 0 && index < KEY_ORDERS.get((Object)transportMode).size() ? REGISTRY.get(KEY_ORDERS.get((Object)transportMode).get(index)) : TrainClientRegistry.getBlankProperties();
    }

    public static String getTrainId(TransportMode transportMode, int index) {
        return KEY_ORDERS.get((Object)transportMode).get(index >= 0 && index < KEY_ORDERS.get((Object)transportMode).size() ? index : 0);
    }

    public static void forEach(TransportMode transportMode, BiConsumer<String, TrainProperties> biConsumer) {
        KEY_ORDERS.get((Object)transportMode).forEach(key -> biConsumer.accept((String)key, REGISTRY.get(key)));
    }

    private static TrainProperties getBlankProperties() {
        return new TrainProperties("", null, null, null, null, (Component)Text.translatable("", new Object[0]), 0, "", "", 0.0f, 0, 0.5f, false);
    }

    public static class TrainProperties {
        public final String baseTrainType;
        public final ModelTrainBase model;
        public final String textureId;
        public final String speedSoundBaseId;
        public final String doorSoundBaseId;
        public final Component name;
        public final int color;
        public final String gangwayConnectionId;
        public final String trainBarrierId;
        public final float riderOffset;
        public final int speedSoundCount;
        public final float doorCloseSoundTime;
        private final boolean useAccelerationSoundsWhenCoasting;
        private final char[] SOUND_GROUP_LETTERS = new char[]{'a', 'b', 'c'};
        private final int SOUND_GROUP_SIZE = this.SOUND_GROUP_LETTERS.length;

        private TrainProperties(String baseTrainType, ModelTrainBase model, String textureId, String speedSoundBaseId, String doorSoundBaseId, Component name, int color, String gangwayConnectionId, String trainBarrierId, float riderOffset, int speedSoundCount, float doorCloseSoundTime, boolean useAccelerationSoundsWhenCoasting) {
            this.baseTrainType = baseTrainType;
            this.model = model;
            this.textureId = TrainProperties.resolvePath(textureId);
            this.speedSoundBaseId = TrainProperties.resolvePath(speedSoundBaseId);
            this.doorSoundBaseId = TrainProperties.resolvePath(doorSoundBaseId);
            this.name = name;
            this.color = color;
            this.gangwayConnectionId = gangwayConnectionId;
            this.trainBarrierId = trainBarrierId;
            this.riderOffset = riderOffset;
            this.speedSoundCount = speedSoundCount;
            this.doorCloseSoundTime = doorCloseSoundTime;
            this.useAccelerationSoundsWhenCoasting = useAccelerationSoundsWhenCoasting;
        }

        public void playSpeedSoundEffect(Level world, BlockPos pos, float oldSpeed, float speed) {
            int floorSpeed;
            if (world instanceof ClientLevel && MTRClient.canPlaySound() && this.speedSoundCount > 0 && this.speedSoundBaseId != null && (floorSpeed = (int)Math.floor(speed / 0.01f / 4.0f)) > 0) {
                Random random = new Random();
                if (floorSpeed >= 30 && random.nextInt(300) == 0) {
                    ((ClientLevel)world).m_104677_(pos, new SoundEvent(new ResourceLocation("mtr", this.speedSoundBaseId + TrainClientRegistry.SOUND_RANDOM)), SoundSource.BLOCKS, 10.0f, 1.0f, true);
                }
                int index = Math.min(floorSpeed, this.speedSoundCount) - 1;
                boolean isAccelerating = speed == oldSpeed ? this.useAccelerationSoundsWhenCoasting || random.nextBoolean() : speed > oldSpeed;
                String soundId = this.speedSoundBaseId + (isAccelerating ? TrainClientRegistry.SOUND_ACCELERATION : TrainClientRegistry.SOUND_DECELERATION) + index / this.SOUND_GROUP_SIZE + this.SOUND_GROUP_LETTERS[index % this.SOUND_GROUP_SIZE];
                ((ClientLevel)world).m_104677_(pos, new SoundEvent(new ResourceLocation("mtr", soundId)), SoundSource.BLOCKS, 1.0f, 1.0f, true);
            }
        }

        public void playDoorSoundEffect(Level world, BlockPos pos, float oldDoorValue, float doorValue) {
            String soundId;
            if (world instanceof ClientLevel && this.doorSoundBaseId != null && (soundId = oldDoorValue <= 0.0f && doorValue > 0.0f ? this.doorSoundBaseId + TrainClientRegistry.SOUND_DOOR_OPEN : (oldDoorValue >= this.doorCloseSoundTime && doorValue < this.doorCloseSoundTime ? this.doorSoundBaseId + TrainClientRegistry.SOUND_DOOR_CLOSE : null)) != null) {
                ((ClientLevel)world).m_104677_(pos, new SoundEvent(new ResourceLocation("mtr", soundId)), SoundSource.BLOCKS, 1.0f, 1.0f, true);
            }
        }

        private static String resolvePath(String path) {
            return path == null ? null : path.toLowerCase().split("\\.png")[0];
        }
    }
}

