/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import mtr.client.IResourcePackCreatorProperties;
import mtr.client.ResourcePackCreatorProperties;
import mtr.data.EnumHelper;
import mtr.mappings.ModelDataWrapper;
import mtr.mappings.ModelMapper;
import mtr.model.ModelTrainBase;
import net.minecraft.client.model.Model;

public class DynamicTrainModel
extends ModelTrainBase
implements IResourcePackCreatorProperties {
    private final Map<String, ModelMapper> parts = new HashMap<String, ModelMapper>();
    private final JsonObject properties;
    private final int doorMax;
    private final Map<String, Boolean> whitelistBlacklistCache = new HashMap<String, Boolean>();

    public DynamicTrainModel(JsonObject model, JsonObject properties) {
        try {
            JsonObject resolution = model.getAsJsonObject("resolution");
            int textureWidth = resolution.get("width").getAsInt();
            int textureHeight = resolution.get("height").getAsInt();
            ModelDataWrapper modelDataWrapper = new ModelDataWrapper((Model)this, textureWidth, textureHeight);
            HashMap elementsByKey = new HashMap();
            model.getAsJsonArray("elements").forEach(element -> elementsByKey.put(element.getAsJsonObject().get("uuid").getAsString(), new ModelMapper(modelDataWrapper)));
            model.getAsJsonArray("outliner").forEach(element -> {
                JsonObject elementObject = element.getAsJsonObject();
                this.parts.put(elementObject.get("name").getAsString(), this.addChildren(elementObject, elementsByKey, modelDataWrapper));
            });
            model.getAsJsonArray("elements").forEach(element -> {
                JsonObject elementObject = element.getAsJsonObject();
                ModelMapper child = (ModelMapper)elementsByKey.get(elementObject.get("uuid").getAsString());
                Double[] origin = new Double[]{0.0, 0.0, 0.0};
                DynamicTrainModel.getArrayFromValue(origin, elementObject, "origin", JsonElement::getAsDouble);
                child.setPos(-origin[0].floatValue(), -origin[1].floatValue(), origin[2].floatValue());
                Double[] rotation = new Double[]{0.0, 0.0, 0.0};
                DynamicTrainModel.getArrayFromValue(rotation, elementObject, "rotation", JsonElement::getAsDouble);
                DynamicTrainModel.setRotationAngle(child, -((float)Math.toRadians(rotation[0])), -((float)Math.toRadians(rotation[1])), (float)Math.toRadians(rotation[2]));
                Integer[] uvOffset = new Integer[]{0, 0};
                DynamicTrainModel.getArrayFromValue(uvOffset, elementObject, "uv_offset", JsonElement::getAsInt);
                Double[] posFrom = new Double[]{0.0, 0.0, 0.0};
                DynamicTrainModel.getArrayFromValue(posFrom, elementObject, "from", JsonElement::getAsDouble);
                Double[] posTo = new Double[]{0.0, 0.0, 0.0};
                DynamicTrainModel.getArrayFromValue(posTo, elementObject, "to", JsonElement::getAsDouble);
                double inflate = elementObject.has("inflate") ? elementObject.get("inflate").getAsDouble() : 0.0;
                boolean mirror = elementObject.has("shade") && !elementObject.get("shade").getAsBoolean();
                child.texOffs(uvOffset[0], uvOffset[1]).addBox(origin[0].floatValue() - posTo[0].floatValue(), origin[1].floatValue() - posTo[1].floatValue(), posFrom[2].floatValue() - origin[2].floatValue(), Math.round(posTo[0].floatValue() - posFrom[0].floatValue()), Math.round(posTo[1].floatValue() - posFrom[1].floatValue()), Math.round(posTo[2].floatValue() - posFrom[2].floatValue()), (float)inflate, mirror);
            });
            modelDataWrapper.setModelPart(textureWidth, textureHeight);
            this.parts.values().forEach(part -> {
                part.setPos(0.0f, 0.0f, 0.0f);
                part.texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0, 0, 0, 0.0f, false);
                part.setModelPart();
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IResourcePackCreatorProperties.checkSchema(properties);
        this.properties = properties;
        this.doorMax = properties.get("door_max").getAsInt();
    }

    @Override
    protected void render(PoseStack matrices, VertexConsumer vertices, ModelTrainBase.RenderStage renderStage, int light, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, int currentCar, int trainCars, boolean head1IsFront, boolean renderDetails) {
        this.properties.getAsJsonArray("parts").forEach(partElement -> {
            boolean skip;
            JsonObject partObject = partElement.getAsJsonObject();
            if (!renderDetails && partObject.get("skip_rendering_if_too_far").getAsBoolean() || !renderStage.toString().equals(partObject.get("stage").getAsString().toUpperCase())) {
                return;
            }
            String whitelistedCars = partObject.get("whitelisted_cars").getAsString();
            String blacklistedCars = partObject.get("blacklisted_cars").getAsString();
            String key = String.format("%s|%s|%s|%s", trainCars, currentCar, whitelistedCars, blacklistedCars);
            if (this.whitelistBlacklistCache.containsKey(key)) {
                skip = this.whitelistBlacklistCache.get(key);
            } else {
                String[] whitelistedCarsFilters = whitelistedCars.split(",");
                String[] blacklistedCarsFilters = blacklistedCars.split(",");
                skip = this.matchesFilter(blacklistedCarsFilters, currentCar, trainCars) > this.matchesFilter(whitelistedCarsFilters, currentCar, trainCars);
                this.whitelistBlacklistCache.put(key, skip);
            }
            if (skip) {
                return;
            }
            if (switch (EnumHelper.valueOf(ResourcePackCreatorProperties.RenderCondition.ALL, partObject.get("render_condition").getAsString())) {
                case ResourcePackCreatorProperties.RenderCondition.DOORS_OPEN -> doorLeftZ == 0.0f && doorRightZ == 0.0f;
                case ResourcePackCreatorProperties.RenderCondition.DOORS_CLOSED -> doorLeftZ > 0.0f || doorRightZ > 0.0f;
                case ResourcePackCreatorProperties.RenderCondition.DOOR_LEFT_OPEN -> doorLeftZ == 0.0f;
                case ResourcePackCreatorProperties.RenderCondition.DOOR_RIGHT_OPEN -> doorRightZ == 0.0f;
                case ResourcePackCreatorProperties.RenderCondition.DOOR_LEFT_CLOSED -> doorLeftZ > 0.0f;
                case ResourcePackCreatorProperties.RenderCondition.DOOR_RIGHT_CLOSED -> doorRightZ > 0.0f;
                case ResourcePackCreatorProperties.RenderCondition.MOVING_FORWARDS -> !head1IsFront;
                case ResourcePackCreatorProperties.RenderCondition.MOVING_BACKWARDS -> head1IsFront;
                default -> false;
            }) {
                return;
            }
            ModelMapper part = this.parts.get(partObject.get("name").getAsString());
            if (part != null) {
                float zOffset = switch (EnumHelper.valueOf(ResourcePackCreatorProperties.DoorOffset.NONE, partObject.get("door_offset").getAsString())) {
                    case ResourcePackCreatorProperties.DoorOffset.LEFT_POSITIVE -> doorLeftZ;
                    case ResourcePackCreatorProperties.DoorOffset.RIGHT_POSITIVE -> doorRightZ;
                    case ResourcePackCreatorProperties.DoorOffset.LEFT_NEGATIVE -> -doorLeftZ;
                    case ResourcePackCreatorProperties.DoorOffset.RIGHT_NEGATIVE -> -doorRightZ;
                    default -> 0.0f;
                };
                boolean mirror = partObject.get("mirror").getAsBoolean();
                partObject.getAsJsonArray("positions").forEach(positionElement -> {
                    float x = positionElement.getAsJsonArray().get(0).getAsFloat();
                    float z = positionElement.getAsJsonArray().get(1).getAsFloat();
                    if (mirror) {
                        DynamicTrainModel.renderOnceFlipped(part, matrices, vertices, light, x, z - zOffset);
                    } else {
                        DynamicTrainModel.renderOnce(part, matrices, vertices, light, x, z + zOffset);
                    }
                });
            }
        });
    }

    @Override
    protected int[] getBogiePositions() {
        return new int[0];
    }

    @Override
    protected float getDoorAnimationX(float value, boolean opening) {
        return 0.0f;
    }

    @Override
    protected float getDoorAnimationZ(float value, boolean opening) {
        return DynamicTrainModel.smoothEnds(0.0f, this.doorMax, 0.0f, 0.5f, value);
    }

    private ModelMapper addChildren(JsonObject jsonObject, Map<String, ModelMapper> children, ModelDataWrapper modelDataWrapper) {
        ModelMapper part = new ModelMapper(modelDataWrapper);
        jsonObject.getAsJsonArray("children").forEach(child -> part.addChild(child.isJsonObject() ? this.addChildren(child.getAsJsonObject(), children, modelDataWrapper) : (ModelMapper)children.get(child.getAsString())));
        return part;
    }

    private int matchesFilter(String[] filters, int currentCar, int trainCars) {
        int strength = filters.length == 0 ? 1 : 0;
        for (String filter : filters) {
            if (filter.isEmpty()) continue;
            if (filter.contains("%")) {
                try {
                    int additional;
                    String[] filterSplit = filter.split("\\+");
                    int multiple = Integer.parseInt(filterSplit[0].replace("%", ""));
                    int n = additional = filterSplit.length == 1 ? 0 : Integer.parseInt(filterSplit[1]);
                    if ((currentCar + 1 + additional) % multiple != 0) continue;
                    strength = 2;
                }
                catch (Exception filterSplit) {}
                continue;
            }
            try {
                int car = Integer.parseInt(filter);
                if (car != currentCar + 1 && car != currentCar - trainCars) continue;
                return 3;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return strength;
    }

    private static <T> void getArrayFromValue(T[] array, JsonObject jsonObject, String key, Function<JsonElement, T> function) {
        if (jsonObject.has(key)) {
            JsonArray jsonArray = jsonObject.getAsJsonArray(key);
            for (int i = 0; i < array.length; ++i) {
                array[i] = function.apply(jsonArray.get(i));
            }
        }
    }
}

