/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import mtr.KeyMappings;
import mtr.client.ClientCache;
import mtr.data.DataConverter;
import mtr.data.Depot;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.ScheduleEntry;
import mtr.data.SerializedDataBase;
import mtr.data.Siding;
import mtr.data.SignalBlocks;
import mtr.data.Station;
import mtr.data.Train;
import mtr.data.TrainClient;
import mtr.data.TransportMode;
import mtr.entity.EntityLift;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.LiftSelectionScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public final class ClientData {
    public static String DASHBOARD_SEARCH = "";
    public static String ROUTES_PLATFORMS_SEARCH = "";
    public static String ROUTES_PLATFORMS_SELECTED_SEARCH = "";
    public static String TRAINS_SEARCH = "";
    public static String EXIT_PARENTS_SEARCH = "";
    public static String EXIT_DESTINATIONS_SEARCH = "";
    public static final Set<Station> STATIONS = new HashSet<Station>();
    public static final Set<Platform> PLATFORMS = new HashSet<Platform>();
    public static final Set<Siding> SIDINGS = new HashSet<Siding>();
    public static final Set<Route> ROUTES = new HashSet<Route>();
    public static final Set<Depot> DEPOTS = new HashSet<Depot>();
    public static final SignalBlocks SIGNAL_BLOCKS = new SignalBlocks();
    public static final Map<BlockPos, Map<BlockPos, Rail>> RAILS = new HashMap<BlockPos, Map<BlockPos, Rail>>();
    public static final Set<TrainClient> TRAINS = new HashSet<TrainClient>();
    public static final List<DataConverter> RAIL_ACTIONS = new ArrayList<DataConverter>();
    public static final Map<Long, Set<ScheduleEntry>> SCHEDULES_FOR_PLATFORM = new HashMap<Long, Set<ScheduleEntry>>();
    public static final ClientCache DATA_CACHE = new ClientCache(STATIONS, PLATFORMS, SIDINGS, ROUTES, DEPOTS);
    private static final Map<UUID, Integer> PLAYER_RIDING_COOL_DOWN = new HashMap<UUID, Integer>();

    public static void tick() {
        Entity vehicle;
        HashSet playersToRemove = new HashSet();
        PLAYER_RIDING_COOL_DOWN.forEach((uuid, coolDown) -> {
            if (coolDown <= 0) {
                playersToRemove.add(uuid);
            }
            PLAYER_RIDING_COOL_DOWN.put((UUID)uuid, coolDown - 1);
        });
        playersToRemove.forEach(PLAYER_RIDING_COOL_DOWN::remove);
        Minecraft minecraftClient = Minecraft.m_91087_();
        LocalPlayer player = minecraftClient.f_91074_;
        if (player != null && (vehicle = player.m_20202_()) instanceof EntityLift) {
            if (KeyMappings.LIFT_MENU.m_90857_() && !(minecraftClient.f_91080_ instanceof LiftSelectionScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new LiftSelectionScreen((EntityLift)vehicle));
            }
            player.m_5661_((Component)Text.translatable("gui.mtr.press_to_select_floor", KeyMappings.LIFT_MENU.m_90863_()), true);
        }
    }

    public static void writeRails(Minecraft client, FriendlyByteBuf packet) {
        HashMap railsTemp = new HashMap();
        int railsCount = packet.readInt();
        for (int i = 0; i < railsCount; ++i) {
            BlockPos startPos = packet.m_130135_();
            HashMap<BlockPos, Rail> railMap = new HashMap<BlockPos, Rail>();
            int railCount = packet.readInt();
            for (int j = 0; j < railCount; ++j) {
                railMap.put(packet.m_130135_(), new Rail(packet));
            }
            railsTemp.put(startPos, railMap);
        }
        client.execute(() -> ClientData.clearAndAddAll(RAILS, railsTemp));
    }

    public static void updateTrains(Minecraft client, FriendlyByteBuf packet) {
        HashSet<TrainClient> trainsToUpdate = new HashSet<TrainClient>();
        while (packet.isReadable()) {
            trainsToUpdate.add(new TrainClient(packet));
        }
        client.execute(() -> trainsToUpdate.forEach(newTrain -> {
            TrainClient existingTrain = ClientData.getTrainById(newTrain.id);
            if (existingTrain == null) {
                TRAINS.add((TrainClient)newTrain);
            } else {
                existingTrain.copyFromTrain((Train)newTrain);
            }
        }));
    }

    public static void deleteTrains(Minecraft client, FriendlyByteBuf packet) {
        HashSet<Long> trainIdsToKeep = new HashSet<Long>();
        int trainsCount = packet.readInt();
        for (int i = 0; i < trainsCount; ++i) {
            trainIdsToKeep.add(packet.readLong());
        }
        client.execute(() -> TRAINS.removeIf(train -> !trainIdsToKeep.contains(train.id)));
    }

    public static void updateTrainPassengers(Minecraft client, FriendlyByteBuf packet) {
        TrainClient train = ClientData.getTrainById(packet.readLong());
        float percentageX = packet.readFloat();
        float percentageZ = packet.readFloat();
        UUID uuid = packet.m_130259_();
        if (train != null) {
            client.execute(() -> train.startRidingClient(uuid, percentageX, percentageZ));
        }
    }

    public static void updateTrainPassengerPosition(Minecraft client, FriendlyByteBuf packet) {
        TrainClient train = ClientData.getTrainById(packet.readLong());
        float percentageX = packet.readFloat();
        float percentageZ = packet.readFloat();
        UUID uuid = packet.m_130259_();
        if (train != null) {
            client.execute(() -> train.updateRiderPercentages(uuid, percentageX, percentageZ));
        }
    }

    public static void updateRailActions(Minecraft client, FriendlyByteBuf packet) {
        ArrayList<DataConverter> railActions = new ArrayList<DataConverter>();
        int actionCount = packet.readInt();
        for (int i = 0; i < actionCount; ++i) {
            long id = packet.readLong();
            String player = packet.m_130277_();
            float length = packet.readFloat();
            String block = Text.translatable(packet.m_130277_(), new Object[0]).getString();
            String name = Text.translatable("gui.mtr." + packet.m_130277_(), player, Float.valueOf(length), block).getString();
            int color = packet.readInt();
            railActions.add(new DataConverter(id, name, color));
        }
        client.execute(() -> {
            RAIL_ACTIONS.clear();
            RAIL_ACTIONS.addAll(railActions);
        });
    }

    public static void updateSchedule(Minecraft client, FriendlyByteBuf packet) {
        HashMap tempSchedulesForPlatform = new HashMap();
        int platformCount = packet.readInt();
        for (int i = 0; i < platformCount; ++i) {
            long platformId = packet.readLong();
            int scheduleCount = packet.readInt();
            for (int j = 0; j < scheduleCount; ++j) {
                if (!tempSchedulesForPlatform.containsKey(platformId)) {
                    tempSchedulesForPlatform.put(platformId, new HashSet());
                }
                ((Set)tempSchedulesForPlatform.get(platformId)).add(new ScheduleEntry(packet));
            }
        }
        HashMap<Long, Boolean> signalBlockStatus = new HashMap<Long, Boolean>();
        int signalBlockCount = packet.readInt();
        for (int i = 0; i < signalBlockCount; ++i) {
            signalBlockStatus.put(packet.readLong(), packet.readBoolean());
        }
        client.execute(() -> {
            ClientData.clearAndAddAll(SCHEDULES_FOR_PLATFORM, tempSchedulesForPlatform);
            SIGNAL_BLOCKS.writeSignalBlockStatus(signalBlockStatus);
        });
    }

    public static void receivePacket(FriendlyByteBuf packet) {
        FriendlyByteBuf packetCopy = new FriendlyByteBuf(packet.copy());
        ClientData.clearAndAddAll(STATIONS, ClientData.deserializeData(packetCopy, Station::new));
        ClientData.clearAndAddAll(PLATFORMS, ClientData.deserializeData(packetCopy, Platform::new));
        ClientData.clearAndAddAll(SIDINGS, ClientData.deserializeData(packetCopy, Siding::new));
        ClientData.clearAndAddAll(ROUTES, ClientData.deserializeData(packetCopy, Route::new));
        ClientData.clearAndAddAll(DEPOTS, ClientData.deserializeData(packetCopy, Depot::new));
        ClientData.clearAndAddAll(ClientData.SIGNAL_BLOCKS.signalBlocks, ClientData.deserializeData(packetCopy, SignalBlocks.SignalBlock::new));
        TRAINS.clear();
        DATA_CACHE.sync();
        SIGNAL_BLOCKS.writeCache();
    }

    public static <T extends NameColorDataBase> Set<T> getFilteredDataSet(TransportMode transportMode, Set<T> dataSet) {
        HashSet returnData = new HashSet();
        dataSet.forEach(data -> {
            if (data.isTransportMode(transportMode)) {
                returnData.add(data);
            }
        });
        return returnData;
    }

    public static void updatePlayerRidingOffset(UUID uuid) {
        PLAYER_RIDING_COOL_DOWN.put(uuid, 2);
    }

    public static boolean isRiding(UUID uuid) {
        return PLAYER_RIDING_COOL_DOWN.containsKey(uuid);
    }

    public static boolean hasPermission() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        ClientPacketListener clientPacketListener = Minecraft.m_91087_().m_91403_();
        if (clientPacketListener == null) {
            return false;
        }
        PlayerInfo playerInfo = clientPacketListener.m_104949_(player.m_142081_());
        if (playerInfo == null) {
            return false;
        }
        return RailwayData.hasPermission(playerInfo.m_105325_());
    }

    private static <T extends SerializedDataBase> Set<T> deserializeData(FriendlyByteBuf packet, Function<FriendlyByteBuf, T> supplier) {
        HashSet<SerializedDataBase> objects = new HashSet<SerializedDataBase>();
        int dataCount = packet.readInt();
        for (int i = 0; i < dataCount; ++i) {
            objects.add((SerializedDataBase)supplier.apply(packet));
        }
        return objects;
    }

    private static <U> void clearAndAddAll(Collection<U> target, Collection<U> source) {
        target.clear();
        target.addAll(source);
    }

    private static <U, V> void clearAndAddAll(Map<U, V> target, Map<U, V> source) {
        target.clear();
        target.putAll(source);
    }

    private static TrainClient getTrainById(long id) {
        try {
            return TRAINS.stream().filter(item -> item.id == id).findFirst().orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

