/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BlockTrainSensorBase
extends BlockMapper
implements EntityBlockMapper {
    public BlockTrainSensorBase() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50470_));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof TileEntityTrainSensorBase) {
                ((TileEntityTrainSensorBase)entity).syncData();
                PacketTrainDataGuiServer.openTrainSensorScreenS2C((ServerPlayer)player, pos);
            }
        });
    }

    public static boolean matchesFilter(Level world, BlockPos pos, long routeId, float speed) {
        BlockEntity entity = world.m_7702_(pos);
        return entity instanceof TileEntityTrainSensorBase && ((TileEntityTrainSensorBase)entity).matchesFilter(routeId, speed);
    }

    public static abstract class TileEntityTrainSensorBase
    extends BlockEntityClientSerializableMapper {
        private boolean stoppedOnly;
        private boolean movingOnly;
        private final Set<Long> filterRouteIds = new HashSet<Long>();
        private static final String KEY_ROUTE_IDS = "route_ids";
        private static final String KEY_STOPPED_ONLY = "stopped_only";
        private static final String KEY_MOVING_ONLY = "moving_only";

        public TileEntityTrainSensorBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            long[] routeIdsArray;
            for (long routeId : routeIdsArray = compoundTag.m_128467_(KEY_ROUTE_IDS)) {
                this.filterRouteIds.add(routeId);
            }
            this.stoppedOnly = compoundTag.m_128471_(KEY_STOPPED_ONLY);
            this.movingOnly = compoundTag.m_128471_(KEY_MOVING_ONLY);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128428_(KEY_ROUTE_IDS, new ArrayList<Long>(this.filterRouteIds));
            compoundTag.m_128379_(KEY_STOPPED_ONLY, this.stoppedOnly);
            compoundTag.m_128379_(KEY_MOVING_ONLY, this.movingOnly);
        }

        public boolean matchesFilter(long routeId, float speed) {
            if (!this.filterRouteIds.isEmpty() && !this.filterRouteIds.contains(routeId)) {
                return false;
            }
            return speed < 0.0f || !this.stoppedOnly && !this.movingOnly || this.stoppedOnly && speed == 0.0f || this.movingOnly && speed > 0.0f;
        }

        public Set<Long> getRouteIds() {
            return this.filterRouteIds;
        }

        public boolean getStoppedOnly() {
            return this.stoppedOnly;
        }

        public boolean getMovingOnly() {
            return this.movingOnly;
        }

        protected void setData(Set<Long> filterRouteIds, boolean stoppedOnly, boolean movingOnly) {
            this.filterRouteIds.clear();
            this.filterRouteIds.addAll(filterRouteIds);
            this.stoppedOnly = stoppedOnly;
            this.movingOnly = movingOnly;
            this.m_6596_();
            this.syncData();
        }

        public abstract void setData(Set<Long> var1, boolean var2, boolean var3, int var4, String ... var5);
    }
}

