/*
 * Decompiled with CFR 0.152.
 */
package mtr;

import mtr.EntityTypes;
import mtr.Keys;
import mtr.MTR;
import mtr.MTRClient;
import mtr.MTRClientLifts;
import mtr.MTRLifts;
import mtr.RegistryObject;
import mtr.client.CustomResources;
import mtr.item.ItemBlockEnchanted;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.DeferredRegisterHolder;
import mtr.mappings.ForgeUtilities;
import mtr.mappings.RegistryUtilitiesClient;
import mtr.render.RenderLift;
import mtr.render.RenderTrains;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mtr")
public class MTRForge {
    private static final DeferredRegisterHolder<Item> ITEMS = new DeferredRegisterHolder("mtr", Registry.f_122904_);
    private static final DeferredRegisterHolder<Block> BLOCKS = new DeferredRegisterHolder("mtr", Registry.f_122901_);
    private static final DeferredRegisterHolder<BlockEntityType<?>> BLOCK_ENTITY_TYPES = new DeferredRegisterHolder("mtr", Registry.f_122907_);
    private static final DeferredRegisterHolder<EntityType<?>> ENTITY_TYPES = new DeferredRegisterHolder("mtr", Registry.f_122903_);
    private static final DeferredRegisterHolder<SoundEvent> SOUND_EVENTS = new DeferredRegisterHolder("mtr", Registry.f_122898_);

    public MTRForge() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeUtilities.registerModEventBus("mtr", eventBus);
        ITEMS.register();
        BLOCKS.register();
        BLOCK_ENTITY_TYPES.register();
        ENTITY_TYPES.register();
        SOUND_EVENTS.register();
        eventBus.register(MTRModEventBus.class);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ForgeUtilities.renderTickAction(MTRClient::incrementGameTick);
            if (!Keys.LIFTS_ONLY) {
                ForgeUtilities.registerEntityRenderer(EntityTypes.SEAT::get, RenderTrains::new);
            }
            ForgeUtilities.registerEntityRenderer(EntityTypes.LiftType.SIZE_2_2.registryObject::get, RenderLift::new);
            ForgeUtilities.registerEntityRenderer(EntityTypes.LiftType.SIZE_2_2_DOUBLE_SIDED.registryObject::get, RenderLift::new);
            ForgeUtilities.registerEntityRenderer(EntityTypes.LiftType.SIZE_3_2.registryObject::get, RenderLift::new);
            ForgeUtilities.registerEntityRenderer(EntityTypes.LiftType.SIZE_3_2_DOUBLE_SIDED.registryObject::get, RenderLift::new);
            ForgeUtilities.registerEntityRenderer(EntityTypes.LiftType.SIZE_3_3.registryObject::get, RenderLift::new);
            ForgeUtilities.registerEntityRenderer(EntityTypes.LiftType.SIZE_3_3_DOUBLE_SIDED.registryObject::get, RenderLift::new);
            ForgeUtilities.registerEntityRenderer(EntityTypes.LiftType.SIZE_4_3.registryObject::get, RenderLift::new);
            ForgeUtilities.registerEntityRenderer(EntityTypes.LiftType.SIZE_4_3_DOUBLE_SIDED.registryObject::get, RenderLift::new);
            ForgeUtilities.registerEntityRenderer(EntityTypes.LiftType.SIZE_4_4.registryObject::get, RenderLift::new);
            ForgeUtilities.registerEntityRenderer(EntityTypes.LiftType.SIZE_4_4_DOUBLE_SIDED.registryObject::get, RenderLift::new);
            MinecraftForge.EVENT_BUS.register(ForgeUtilities.RenderTick.class);
            eventBus.register(ForgeUtilities.RegisterEntityRenderer.class);
        });
    }

    private static void registerItem(String path, RegistryObject<Item> item) {
        ITEMS.register(path, item::get);
    }

    private static void registerBlock(String path, RegistryObject<Block> block) {
        BLOCKS.register(path, block::get);
    }

    private static void registerBlock(String path, RegistryObject<Block> block, CreativeModeTab itemGroup) {
        MTRForge.registerBlock(path, block);
        ITEMS.register(path, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(itemGroup)));
    }

    private static void registerEnchantedBlock(String path, RegistryObject<Block> block, CreativeModeTab itemGroup) {
        MTRForge.registerBlock(path, block);
        ITEMS.register(path, () -> new ItemBlockEnchanted((Block)block.get(), new Item.Properties().m_41491_(itemGroup)));
    }

    private static void registerBlockEntityType(String path, RegistryObject<? extends BlockEntityType<? extends BlockEntityMapper>> blockEntityType) {
        BLOCK_ENTITY_TYPES.register(path, blockEntityType::get);
    }

    private static void registerEntityType(String path, RegistryObject<? extends EntityType<? extends Entity>> entityType) {
        ENTITY_TYPES.register(path, entityType::get);
    }

    private static void registerSoundEvent(String path, SoundEvent soundEvent) {
        SOUND_EVENTS.register(path, () -> soundEvent);
    }

    static {
        if (Keys.LIFTS_ONLY) {
            MTRLifts.init(MTRForge::registerItem, MTRForge::registerBlock, MTRForge::registerBlock, MTRForge::registerBlockEntityType, MTRForge::registerEntityType);
        } else {
            MTR.init(MTRForge::registerItem, MTRForge::registerBlock, MTRForge::registerBlock, MTRForge::registerEnchantedBlock, MTRForge::registerBlockEntityType, MTRForge::registerEntityType, MTRForge::registerSoundEvent);
        }
    }

    private static class MTRModEventBus {
        private MTRModEventBus() {
        }

        @SubscribeEvent
        public static void onClientSetupEvent(FMLClientSetupEvent event) {
            if (Keys.LIFTS_ONLY) {
                MTRClientLifts.init();
            } else {
                MTRClient.init();
            }
            RegistryUtilitiesClient.registerTextureStitchEvent(textureAtlas -> {
                if (textureAtlas.m_118330_().m_135815_().equals("textures/atlas/blocks.png")) {
                    CustomResources.reload(Minecraft.m_91087_().m_91098_());
                }
            });
        }
    }
}

