/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.spongepowered.include.com.google.common.io.ByteStreams;

public class UpdateSolder {
    private static final Path OUTPUT_PATH = Paths.get("temp", new String[0]);
    private static final String[] MINECRAFT_VERSIONS = new String[]{"1.16.5", "1.17.1", "1.18", "1.18.2", "1.19"};
    private static final Set<Thread> THREADS = new HashSet<Thread>();
    private static final Map<String, String> MOD_ID_MAP = new HashMap<String, String>();

    public static void main(String[] args) throws IOException {
        if (args.length < 5) {
            return;
        }
        String sftpHost = args[0];
        String sftpUsername = args[1];
        String sftpPassword = args[2];
        String sftpPath = args[3];
        String apiToken = args[4];
        SSHClient sshClient = new SSHClient();
        sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        sshClient.connect(sftpHost);
        sshClient.authPassword(sftpUsername, sftpPassword);
        SFTPClient sftpClient = sshClient.newSFTPClient();
        THREADS.clear();
        FileUtils.deleteQuietly((File)OUTPUT_PATH.toFile());
        String mtrVersion = UpdateSolder.readUrl("https://www.minecrafttransitrailway.com/libs/latest/latest.json", new JsonObject()).getAsJsonObject().get("version").getAsString();
        for (String minecraftVersion : MINECRAFT_VERSIONS) {
            for (Loader loader : Loader.values()) {
                String modVersion = loader.loader + "-" + minecraftVersion + "-" + mtrVersion;
                UpdateSolder.uploadZip("https://www.minecrafttransitrailway.com/libs/latest/MTR-" + loader.loader + "-" + minecraftVersion + "-latest.jar", "mtr", "mods/MTR-" + modVersion + ".jar", modVersion, sftpClient, sftpPath, apiToken);
            }
            try {
                String fabricLoaderVersion = UpdateSolder.readUrl("https://meta.fabricmc.net/v2/versions/loader/" + minecraftVersion, new JsonArray()).getAsJsonArray().get(0).getAsJsonObject().getAsJsonObject("loader").get("version").getAsString();
                UpdateSolder.uploadZip("https://meta.fabricmc.net/v2/versions/loader/" + minecraftVersion + "/" + fabricLoaderVersion + "/profile/json", "fabric-loader", "bin/version.json", minecraftVersion + "-" + fabricLoaderVersion, sftpClient, sftpPath, apiToken);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                JsonObject forgeVersionsObject = UpdateSolder.readUrl("https://files.minecraftforge.net/net/minecraftforge/forge/promotions_slim.json", new JsonObject()).getAsJsonObject().getAsJsonObject("promos");
                String forgeVersion = forgeVersionsObject.has(minecraftVersion + "-recommended") ? minecraftVersion + "-" + forgeVersionsObject.get(minecraftVersion + "-recommended").getAsString() : minecraftVersion + "-" + forgeVersionsObject.get(minecraftVersion + "-latest").getAsString();
                UpdateSolder.uploadZip("https://maven.minecraftforge.net/net/minecraftforge/forge/" + forgeVersion + "/forge-" + forgeVersion + "-installer.jar", "forge-loader", "bin/modpack.jar", forgeVersion, sftpClient, sftpPath, apiToken);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        UpdateSolder.uploadModrinthMod(Loader.FABRIC, "P7dR8mSH", "fabric-api", sftpClient, sftpPath, apiToken);
        UpdateSolder.uploadModrinthMod(Loader.FABRIC, "mOgUt4GM", "modmenu", sftpClient, sftpPath, apiToken);
        UpdateSolder.uploadModrinthMod(Loader.FORGE, "lhGA9TYQ", "forge-architectury", sftpClient, sftpPath, apiToken);
        THREADS.forEach(thread -> {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        FileUtils.deleteQuietly((File)OUTPUT_PATH.toFile());
        sftpClient.close();
        sshClient.disconnect();
    }

    private static void uploadZip(String url, String modId, String zipPath, String modVersion, SFTPClient sftpClient, String sftpPath, String apiToken) {
        if (!MOD_ID_MAP.containsKey(modId)) {
            return;
        }
        Thread thread = new Thread(() -> {
            try {
                Files.createDirectories(OUTPUT_PATH.resolve(modId), new FileAttribute[0]);
                InputStream inputStream = new URL(url).openStream();
                OutputStream outputStream = Files.newOutputStream(OUTPUT_PATH.resolve(modId).resolve(modId + "-" + modVersion + ".zip"), new OpenOption[0]);
                ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
                zipOutputStream.putNextEntry(new ZipEntry(zipPath));
                ByteStreams.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
                zipOutputStream.close();
                outputStream.close();
                inputStream.close();
                System.out.println("Uploading to SFTP: " + modId + "-" + modVersion);
                sftpClient.put(OUTPUT_PATH.toString(), sftpPath + "/mods");
                HttpURLConnection http = (HttpURLConnection)new URL(String.format("https://minecrafttransitrailway.com/api/mtr/add-version?mod-id=%s&add-version=%s", URLEncoder.encode(MOD_ID_MAP.get(modId), "UTF-8"), URLEncoder.encode(modVersion, "UTF-8"))).openConnection();
                http.setRequestMethod("POST");
                http.setDoOutput(true);
                http.setRequestProperty("Authorization", "Bearer " + apiToken);
                System.out.println("Updating Solder: " + modId + "-" + modVersion);
                System.out.println(IOUtils.toString((InputStream)http.getInputStream(), (Charset)StandardCharsets.UTF_8));
                http.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        thread.start();
        THREADS.add(thread);
    }

    private static <T extends JsonElement> JsonElement readUrl(String url, T defaultValue) {
        JsonElement jsonElement;
        block8: {
            InputStream inputStream = new URL(url).openStream();
            try {
                jsonElement = new JsonParser().parse((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return defaultValue;
                }
            }
            inputStream.close();
        }
        return jsonElement;
    }

    private static void uploadModrinthMod(Loader loader, String projectId, String modId, SFTPClient sftpClient, String sftpPath, String apiToken) {
        try {
            HashSet minecraftVersions = new HashSet();
            Collections.addAll(minecraftVersions, MINECRAFT_VERSIONS);
            JsonArray versionsArray = UpdateSolder.readUrl("https://api.modrinth.com/v2/project/" + projectId + "/version", new JsonArray()).getAsJsonArray();
            for (JsonElement jsonElement : versionsArray) {
                JsonObject versionObject = jsonElement.getAsJsonObject();
                if (!UpdateSolder.stringJsonArrayContains(versionObject.getAsJsonArray("loaders"), loader.loader)) continue;
                HashSet<String> minecraftVersionsToRemove = new HashSet<String>();
                for (String minecraftVersion : minecraftVersions) {
                    if (!UpdateSolder.stringJsonArrayContains(versionObject.getAsJsonArray("game_versions"), minecraftVersion)) continue;
                    JsonObject fileObject = versionObject.getAsJsonArray("files").get(0).getAsJsonObject();
                    UpdateSolder.uploadZip(fileObject.get("url").getAsString(), modId, "mods/" + fileObject.get("filename").getAsString(), UpdateSolder.appendMinecraftVersion(versionObject.get("version_number").getAsString(), minecraftVersion), sftpClient, sftpPath, apiToken);
                    minecraftVersionsToRemove.add(minecraftVersion);
                }
                minecraftVersionsToRemove.forEach(minecraftVersions::remove);
                if (!minecraftVersions.isEmpty()) continue;
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean stringJsonArrayContains(JsonArray jsonArray, String text) {
        for (JsonElement jsonElement : jsonArray) {
            if (!jsonElement.getAsString().equals(text)) continue;
            return true;
        }
        return false;
    }

    private static String appendMinecraftVersion(String text, String minecraftVersion) {
        String[] minecraftVersionSplit = minecraftVersion.split("\\.");
        int size = Math.min(minecraftVersionSplit.length, 2);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            stringBuilder.append(minecraftVersionSplit[i]);
            if (i >= size - 1) continue;
            stringBuilder.append(".");
        }
        if (text.contains(stringBuilder)) {
            return text;
        }
        return text + "-" + minecraftVersion;
    }

    static {
        MOD_ID_MAP.put("mtr", "1");
        MOD_ID_MAP.put("fabric-loader", "2");
        MOD_ID_MAP.put("fabric-api", "3");
        MOD_ID_MAP.put("forge-loader", "5");
        MOD_ID_MAP.put("forge-architectury", "6");
        MOD_ID_MAP.put("modmenu", "7");
    }

    private static enum Loader {
        FABRIC("fabric"),
        FORGE("forge");

        private final String loader;

        private Loader(String loader) {
            this.loader = loader;
        }
    }
}

