/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.mekores.client;

import io.github.phantamanta44.mekores.MekOres;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class ClientEventListener {
    private static int[] atlas;
    private static int atlasWidth;

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
        MekOres.LOGGER.info("Texture stitch event caught.");
        try {
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            if (width > 16 && height > 16) {
                MekOres.LOGGER.info("Caching {}x{} texture atlas...", (Object)width, (Object)height);
                IntBuffer buf = ByteBuffer.allocateDirect(4 * width * height).asIntBuffer();
                GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)buf);
                atlas = new int[buf.remaining()];
                buf.get(atlas);
                atlasWidth = width;
                MekOres.PROXY.cacheOreColours();
            } else {
                MekOres.LOGGER.info("Ignoring {}x{} atlas stitch event.", (Object)width, (Object)height);
            }
        }
        catch (Exception e) {
            MekOres.LOGGER.error("Failed to cache texture atlas!", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu) {
            MekOres.PROXY.gameInit();
        }
    }

    public static int[] getAtlas() {
        return atlas;
    }

    public static int getAtlasWidth() {
        return atlasWidth;
    }
}

