/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.GeneratorTags;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsFluids;
import mekanism.generators.common.slot.FluidFuelInventorySlot;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityBioGenerator
extends TileEntityGenerator {
    private static final int MAX_FLUID = 24000;
    public BasicFluidTank bioFuelTank;
    private FluidFuelInventorySlot fuelSlot;
    private EnergyInventorySlot energySlot;
    private float lastFluidScale;

    public TileEntityBioGenerator() {
        super((IBlockProvider)GeneratorsBlocks.BIO_GENERATOR, ((FloatingLong)MekanismGeneratorsConfig.generators.bioGeneration.get()).multiply(2L));
    }

    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSide(() -> ((TileEntityBioGenerator)this).getDirection());
        this.bioFuelTank = BasicFluidTank.create((int)24000, fluidStack -> fluidStack.getFluid().func_207185_a(GeneratorTags.Fluids.BIOETHANOL), (IContentsListener)this);
        builder.addTank((IExtendedFluidTank)this.bioFuelTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        return builder.build();
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityBioGenerator)this).getDirection());
        this.fuelSlot = FluidFuelInventorySlot.forFuel((IExtendedFluidTank)this.bioFuelTank, stack -> stack.func_77973_b().func_206844_a((ITag)MekanismTags.Items.FUELS_BIO) ? 200 : 0, (Int2ObjectFunction<FluidStack>)((Int2ObjectFunction)arg_0 -> GeneratorsFluids.BIOETHANOL.getFluidStack(arg_0)), (IContentsListener)this, 17, 35);
        builder.addSlot((IInventorySlot)this.fuelSlot, new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)this, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.RIGHT});
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.drainContainer();
        this.fuelSlot.fillOrBurn();
        if (MekanismUtils.canFunction((TileEntity)this) && !this.bioFuelTank.isEmpty() && this.getEnergyContainer().insert((FloatingLong)MekanismGeneratorsConfig.generators.bioGeneration.get(), Action.SIMULATE, AutomationType.INTERNAL).isZero()) {
            this.setActive(true);
            MekanismUtils.logMismatchedStackSize((long)this.bioFuelTank.shrinkStack(1, Action.EXECUTE), (long)1L);
            this.getEnergyContainer().insert((FloatingLong)MekanismGeneratorsConfig.generators.bioGeneration.get(), Action.EXECUTE, AutomationType.INTERNAL);
            float fluidScale = MekanismUtils.getScale((float)this.lastFluidScale, (IExtendedFluidTank)this.bioFuelTank);
            if (fluidScale != this.lastFluidScale) {
                this.lastFluidScale = fluidScale;
                this.sendUpdatePacket();
            }
        } else {
            this.setActive(false);
        }
    }

    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_218657_a("fluid", (INBT)this.bioFuelTank.serializeNBT());
        return updateTag;
    }

    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setCompoundIfPresent((CompoundNBT)tag, (String)"fluid", nbt -> this.bioFuelTank.deserializeNBT(nbt));
    }
}

