/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.VariableCapacityEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.turbine.TurbineGasTank;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class TurbineMultiblockData
extends MultiblockData {
    public static final long GAS_PER_TANK = 64000L;
    public static final float ROTATION_THRESHOLD = 0.001f;
    public static final Object2FloatMap<UUID> clientRotationMap = new Object2FloatOpenHashMap();
    @ContainerSync
    public IGasTank gasTank;
    @ContainerSync
    public IExtendedFluidTank ventTank;
    public final List<IExtendedFluidTank> ventTanks;
    @ContainerSync
    public IEnergyContainer energyContainer;
    @ContainerSync
    public TileEntityChemicalTank.GasMode dumpMode = TileEntityChemicalTank.GasMode.IDLE;
    private FloatingLong energyCapacity = FloatingLong.ZERO;
    @ContainerSync
    public int blades;
    @ContainerSync
    public int vents;
    @ContainerSync
    public int coils;
    @ContainerSync
    public int condensers;
    @ContainerSync
    public int lowerVolume;
    public BlockPos complex;
    @ContainerSync
    public long lastSteamInput;
    public long newSteamInput;
    @ContainerSync(getter="getDispersers")
    public int clientDispersers;
    @ContainerSync
    public long clientFlow;
    public float clientRotation;
    public float prevSteamScale;

    public TurbineMultiblockData(TileEntityTurbineCasing tile) {
        super((TileEntity)tile);
        this.gasTank = new TurbineGasTank(this, tile);
        this.gasTanks.add(this.gasTank);
        this.ventTank = VariableCapacityFluidTank.create(() -> !this.isFormed() ? 1000 : this.condensers * MekanismGeneratorsConfig.generators.condenserRate.get(), (stack, automationType) -> automationType != AutomationType.EXTERNAL || this.isFormed(), (BiPredicate)BasicFluidTank.internalOnly, fluid -> fluid.getFluid().func_207185_a((ITag)FluidTags.field_206959_a), null);
        this.ventTanks = Collections.singletonList(this.ventTank);
        this.energyContainer = VariableCapacityEnergyContainer.create(this::getEnergyCapacity, automationType -> automationType != AutomationType.EXTERNAL || this.isFormed(), (Predicate)BasicEnergyContainer.internalOnly, null);
        this.energyContainers.add(this.energyContainer);
    }

    public boolean tick(World world) {
        float scale;
        float newRotation;
        boolean needsPacket = super.tick(world);
        this.lastSteamInput = this.newSteamInput;
        this.newSteamInput = 0L;
        long stored = this.gasTank.getStored();
        double flowRate = 0.0;
        FloatingLong energyNeeded = this.energyContainer.getNeeded();
        if (stored > 0L && !energyNeeded.isZero()) {
            FloatingLong energyMultiplier = ((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply((long)Math.min(this.blades, this.coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get()));
            if (energyMultiplier.isZero()) {
                this.clientFlow = 0L;
            } else {
                double rate = (double)this.lowerVolume * ((double)this.getDispersers() * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get());
                rate = Math.min(rate, (double)this.vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
                double proportion = (double)stored / (double)this.getSteamCapacity();
                double origRate = rate;
                rate = Math.min(Math.min((double)stored, rate), energyNeeded.divide(energyMultiplier).doubleValue()) * proportion;
                flowRate = rate / origRate;
                this.energyContainer.insert(energyMultiplier.multiply(rate), Action.EXECUTE, AutomationType.INTERNAL);
                if (!this.gasTank.isEmpty()) {
                    this.gasTank.shrinkStack((long)rate, Action.EXECUTE);
                }
                this.clientFlow = (long)rate;
                this.ventTank.setStack(new FluidStack((Fluid)Fluids.field_204546_a, Math.min(MathUtils.clampToInt((double)rate), this.condensers * MekanismGeneratorsConfig.generators.condenserRate.get())));
            }
        } else {
            this.clientFlow = 0L;
        }
        if (this.dumpMode != TileEntityChemicalTank.GasMode.IDLE && !this.gasTank.isEmpty()) {
            long amount = this.gasTank.getStored();
            if (this.dumpMode == TileEntityChemicalTank.GasMode.DUMPING) {
                this.gasTank.shrinkStack(this.getDumpingAmount(amount), Action.EXECUTE);
            } else {
                long targetLevel = MathUtils.clampToLong((double)((double)this.gasTank.getCapacity() * MekanismGeneratorsConfig.generators.turbineDumpExcessKeepRatio.get()));
                if (targetLevel < amount) {
                    this.gasTank.shrinkStack(Math.min(amount - targetLevel, this.getDumpingAmount(amount)), Action.EXECUTE);
                }
            }
        }
        if (Math.abs((newRotation = (float)flowRate) - this.clientRotation) > 0.001f) {
            this.clientRotation = newRotation;
            needsPacket = true;
        }
        if ((scale = MekanismUtils.getScale((float)this.prevSteamScale, (IChemicalTank)this.gasTank)) != this.prevSteamScale) {
            needsPacket = true;
            this.prevSteamScale = scale;
        }
        return needsPacket;
    }

    private long getDumpingAmount(long stored) {
        return Math.min(stored, Math.max(stored / 50L, this.lastSteamInput * 2L));
    }

    public void readUpdateTag(CompoundNBT tag) {
        super.readUpdateTag(tag);
        NBTUtils.setFloatIfPresent((CompoundNBT)tag, (String)"scale", scale -> {
            this.prevSteamScale = scale;
        });
        NBTUtils.setIntIfPresent((CompoundNBT)tag, (String)"volume", this::setVolume);
        NBTUtils.setIntIfPresent((CompoundNBT)tag, (String)"lowerVolume", value -> {
            this.lowerVolume = value;
        });
        NBTUtils.setGasStackIfPresent((CompoundNBT)tag, (String)"gas", value -> this.gasTank.setStack((ChemicalStack)value));
        NBTUtils.setBlockPosIfPresent((CompoundNBT)tag, (String)"complex", value -> {
            this.complex = value;
        });
        NBTUtils.setFloatIfPresent((CompoundNBT)tag, (String)"rotation", value -> {
            this.clientRotation = value;
        });
        clientRotationMap.put((Object)this.inventoryID, this.clientRotation);
    }

    public void writeUpdateTag(CompoundNBT tag) {
        super.writeUpdateTag(tag);
        tag.func_74776_a("scale", this.prevSteamScale);
        tag.func_74768_a("volume", this.getVolume());
        tag.func_74768_a("lowerVolume", this.lowerVolume);
        tag.func_218657_a("gas", (INBT)((GasStack)this.gasTank.getStack()).write(new CompoundNBT()));
        tag.func_218657_a("complex", (INBT)NBTUtil.func_186859_a((BlockPos)this.complex));
        tag.func_74776_a("rotation", this.clientRotation);
    }

    public int getDispersers() {
        return (this.length() - 2) * (this.width() - 2) - 1;
    }

    public long getSteamCapacity() {
        return (long)this.lowerVolume * 64000L;
    }

    @Nonnull
    public FloatingLong getEnergyCapacity() {
        return this.energyCapacity;
    }

    public void setVolume(int volume) {
        super.setVolume(volume);
        this.energyCapacity = FloatingLong.createConst((long)((long)this.getVolume() * 16000000L));
    }

    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.gasTank.getStored(), (long)this.gasTank.getCapacity());
    }
}

